import numpy as np
from sklearn.datasets import make_moons
from sklearn.cluster import KMeans
from sklearn.metrics import pairwise_kernels
from sklearn.preprocessing import normalize
from scipy.linalg import eigh

# Step 1: Generate sample data
X, _ = make_moons(n_samples=300, noise=0.05)

# Step 2: Compute similarity matrix (RBF kernel)
W = pairwise_kernels(X, metric='rbf', gamma=15)

# Step 3: Compute degree matrix and Laplacian
D = np.diag(W.sum(axis=1))
L = D - W  # Unnormalized Laplacian

# Step 4: Compute first k eigenvectors
k = 2
eigvals, eigvecs = eigh(L, subset_by_index=[0, k-1])  # Smallest k eigenvalues

# Step 5: Normalize rows (optional but common)
U = normalize(eigvecs)

# Step 6: Run k-means on rows of U
labels = KMeans(n_clusters=k).fit_predict(U)

# Done! You can now visualize the clusters
import matplotlib.pyplot as plt
plt.scatter(X[:, 0], X[:, 1], c=labels, cmap='viridis')
plt.title("Spectral Clustering Result")
plt.show()
