import matplotlib.pyplot as plt
import numpy as np

# Example with linear schedule
T = 1000
beta_start = 0.0001
beta_end = 0.02
betas = np.linspace(beta_start, beta_end, T)
alphas = 1 - betas
alpha_bar = np.cumprod(alphas)

plt.figure(figsize=(10, 6))
plt.plot(range(T), alpha_bar, linewidth=2)
plt.xlabel('Timestep t', fontsize=14)
plt.ylabel(r'$\bar{\alpha}_t$', fontsize=14)
plt.title(r'Noise Schedule: $\bar{\alpha}_t$ vs Timestep', fontsize=16)
plt.grid(True, alpha=0.3)
plt.xlim(0, T)
plt.ylim(0, 1)

# Add annotations
plt.axhline(y=1, color='r', linestyle='--', alpha=0.5, label='No noise')
plt.axhline(y=0, color='r', linestyle='--', alpha=0.5, label='Pure noise')
plt.legend()

plt.tight_layout()
plt.savefig('alpha_bar_schedule.png', dpi=300, bbox_inches='tight')
plt.show()
