/*
 * client.c
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rpc/rpc.h>     /* always needed  */
#include "mprint.h"       /* print.h will be generated by rpcgen */

int main(argc, argv)
     int argc;
     char *argv[];
{
  CLIENT *cl;
  int *result;
  char *server;
  char *message;

 

  if (argc != 3) {
    fprintf(stderr,
	    "usage: %s host message\n", argv[0]);
    exit(1);
  }

  server = argv[1];
  message = argv[2];

  /*
   * Create client "handle" used for calling MESSAGEPROG on
   * the server designated on the command line.  We tell
   * the RPC package to use the TCP protocol when
   * contacting the server.
   */

  cl = clnt_create(server, MPRINTPROG, MPRINTVERS,
		   "tcp");
  if (cl == NULL) {

    /*
     * Couldn't establish connection with server.
     * Print error message and stop.
     */

    clnt_pcreateerror(server);
    exit(1);
  }

  /*
   * Call the remote procedure "printmessage" on the server
   */

  result = mprint_1(&message, cl);
  if (result == NULL) {

    /*
     * An error occurred while calling the server.
     * Print error message and stop.
     */
    clnt_perror(cl, server);
    exit(1);
  }
  /*
   * Okay, we successfully called the remote procedure.
   */
  if (*result == 0) {
    /*
     * Server was unable to print our message.
     * Print error message and stop.
     */
    fprintf(stderr, "%s: %s couldn't print your message\n",
	    argv[0], server);
    exit(1);
  }

  /*
   * The message got printed on the server's console
   */

  printf("Message delivered to %s!\n", server);
  exit(0);
}
