#! /usr/bin/python3
# Test program for module {block}
# Last edited on 2021-02-18 14:23:14 by jstolfi

import block
import path
import move 
import hacks
import job_parms
import rn
import pyx
import sys
from math import sqrt,sin,cos,pi

parms = job_parms.typical()

def test_basics(tag):
  sys.stderr.write("--- {from_paths,nchoices,choice,unpack,pick,has_move,min_extime} ----------------\n")

  p00 = (1,1)
  p01 = (4,1)
  p02 = (5,2)
  p03 = (2,2)
  wd = parms['solid_raster_width']
  pha = path.from_points(((p00, p01, p02, p03,),), wd, parms) # Bottom is LR
  phb = path.from_points(((p01, p00, p03, p02,),), wd, parms) # Bottom is RL
  phc = path.from_points(((p00, p01, p02, p03, p00,),), wd, parms) # Closed.
  
  bc = block.from_paths((pha, path.rev(pha), phb, path.rev(phb), phc,))
  block.validate(bc)

  mex = min(path.extime(pha), min(path.extime(phb), path.extime(phc)))
  assert block.min_extime(bc) == mex

  np = block.nchoices(bc)
  assert np == 5
  assert block.choice(bc, 0) == pha
  assert block.choice(bc, 1) == path.rev(pha)
  assert block.choice(bc, 2) == phb
  assert block.choice(bc, 3) == path.rev(phb)
  assert block.choice(bc, 4) == phc

  bcp = (bc, 2)
  assert (block.unpack(bcp)) == (bc, 2)
  assert block.pick(bcp) == phb
  
  # Some extra moves and paths not in {bc}:
  p10 = (5,4)
  p11 = (4,3)
  mvx = move.make(p10, p11, wd, parms)
  
  p20 = (4,4)
  p21 = (3,3)
  mvy = move.make(p20, p21, wd, parms)
  
  jmxy = move.make(p11, p20, 0, parms)
  jmyx = move.make(p21, p10, 0, parms)

  phxy = path.from_moves([mvx,jmxy,mvy])
  phyx = path.from_moves([mvy,jmyx,mvx])

  bcx = block.from_paths([phxy, phyx])
  
  for ip in range(np):
    oph = block.choice(bc,ip)
    ix = path.nelems(oph)//2
    omv = path.elem(oph,ix)
    assert block.has_move(bc, omv)
    assert not block.has_move(bc, mvx)
    assert not block.has_move(bcx, omv)
  
  waxes = 0.05*wd
  c = pyx.canvas.canvas()
  block.plot(c, bc, (0,0), waxes = waxes, axes = True, dots = True, arrows = True, matter = True)
  hacks.write_plot(c, ("tests/out/block_TST_%s" % tag))
  return
  # ----------------------------------------------------------------------

def test_contacts(tag):
  sys.stderr.write("--- {create_test_data,print_contact_table} ----------------\n")
  MS, PS, CS, BS = block.create_test_data(parms)
  block.print_contact_table(sys.stderr, BS, CS, MS)
  # ??? Should plot the blocks ???
  return
  # ----------------------------------------------------------------------

test_basics("one")
test_contacts("two")
