#! /usr/bin/python3
# Test program for module {input_data}.
# Last edited on 2021-02-18 21:12:12 by jstolfi

import example_block
import block
import path
import move
import contact
import hacks
import job_parms
import color
import rn
import pyx
import sys
from math import sqrt, sin, cos, floor, ceil, inf, nan, pi

parms = job_parms.typical()
wdf = parms['solid_raster_width']
wdc = parms['contour_trace_width']

def do_test(tag, bc):
  waxes = 0.05*wdf
  c = pyx.canvas.canvas()
  block.plot(c, bc, (0,0), waxes = waxes, axes = True, dots = True, arrows = True, matter = True)
  hacks.write_plot(c, ("tests/out/example_block_TST_" + tag))
  return
  # ----------------------------------------------------------------------

def test_single_raster():
  xlo = 2
  xhi = 4
  y = 2
  bc = example_block.single_raster(xlo, xhi, y, wdf, parms)
  do_test("single_raster", bc)
  return
  # ----------------------------------------------------------------------

def test_raster_rectangle():
  xlo = 2
  xhi = 4
  ylo = 2
  nr = 5
  bc = example_block.raster_rectangle(xlo, xhi, ylo, wdf, nr, parms)
  do_test("raster_rectangle", bc)
  return
  # ----------------------------------------------------------------------

def test_onion():
  ctr = (4,4)
  Rc = 3
  Rf = 1
  phase = -pi/4
  bc = example_block.onion(ctr, Rc, wdc, Rf, wdf, phase, parms)
  do_test("onion", bc)
  return
  # ----------------------------------------------------------------------

def test_raster_raster_contact():
  tag = "raster_raster_contact"
  xlo0 = 2
  xhi0 = 4
  ylo0 = 2
  nr0 = 3
  bc0 = example_block.raster_rectangle(xlo0, xhi0, ylo0, wdf, nr0, parms)
  
  xlo1 = 3
  xhi1 = 6
  ylo1 = ylo0 + nr0*wdf
  nr1 = 4
  bc1 = example_block.raster_rectangle(xlo1, xhi1, ylo1, wdf, nr1, parms)
  
  ct = example_block.raster_raster_contact(bc0, bc1, parms)
  
  # Plot the paths:
  waxes = 0.05*wdf
  c = pyx.canvas.canvas()
  oph0 = block.choice(bc0,0)
  ctraces0 = pyx.color.rgb( 0.200, 0.800, 0.000 )
  path.plot_standard(c, oph0, (0,0), None, ctraces0, waxes, True, True, True, True)
  oph1 = block.choice(bc1,0)
  ctraces1 = pyx.color.rgb( 0.700, 0.650, 0.000 )
  path.plot_standard(c, oph1, (0,0), None, ctraces1, waxes, True, True, True, True)

  # Plot the contact:
  wconts = 0.15*wdf; cconts = pyx.color.rgb( 0.900, 0.100, 0.000 )
  contact.plot(c, ct, (0,0), wconts, cconts)

  hacks.write_plot(c, ("tests/out/example_block_TST_%s" % tag))
  
  return
  # ----------------------------------------------------------------------

test_single_raster()
test_raster_rectangle()
test_onion()
test_raster_raster_contact()
