#! /usr/bin/python3
# Test program for the module {rootray}
# Last edited on 2021-02-07 20:49:22 by jstolfi

import rootray
from math import inf
import sys

sys.stderr.write("--- {rootray.minsep} ---------------\n")

for x1,x2 in (
    ( 1.000, 1.000 + 1.0e-7 ), 
    ( 1.0e8, 1.0e8 + 2 ),
  ):
    sep = rootray.min_sep(x1,x2)
    sys.stderr.write("minsep(%21.15e, %21.15e) = %21.15e\n" % (x1,x2,sep))

sys.stderr.write("--- {rootray.validate} ---------------\n")

fa = (+1, [ 0.234, 1.000, 1.0000001, 5,  10,   100000000, 100000002 ])
sys.stderr.write("fa = %s\n" % str(fa))
rootray.validate(fa)

fb = (-1, [ 0.3, 0.4, 0.5, 5, 6, 7, 8, 9, 10,    100000002, 100000004 ])
sys.stderr.write("fb = %s\n" % str(fb))
rootray.validate(fb)

sys.stderr.write("--- {rootray.complement} ---------------\n")

fc1 = rootray.complement(fa)
sys.stderr.write("fa  = %s\n" % str(fa))
sys.stderr.write("fc1 = %s\n" % str(fc1))
rootray.validate(fc1)
assert fc1[0] == -1
assert fc1[1] == fa[1]

sys.stderr.write("--- {rootray.union} ---------------\n")

fu2 = rootray.union(fa, fb)
sys.stderr.write("fu2 = %s\n" % str(fu2))
rootray.validate(fu2)
assert fu2[0] == -1
assert len(fu2[1]) == 8

fu3 = rootray.union(fa, rootray.complement(fa))
rootray.validate(fu3)
assert fu3[0] == -1
assert len(fu3[1]) == 0

fu4 = rootray.union(fa, rootray.vacuum())
rootray.validate(fu4)
assert fu4 == fa

fu5 = rootray.union(fb, rootray.plenum())
rootray.validate(fu5)
assert fu5[0] == -1
assert len(fu5[1]) == 0

fu6 = rootray.union(fa, fa)
rootray.validate(fu6)
assert fu6 == fa

fu8a = (+1, [-2, +2])
fu8b = (-1, [-1, +1])
fu8 = rootray.intersection(fu8a, fu8b)
sys.stderr.write("fu8 = %s\n" % str(fu8))
assert fu8 == (+1, [-2, -1, +1, +2 ])

sys.stderr.write("--- {rootray.intersection} ---------------\n")

fi2 = rootray.intersection(fa, fb)
sys.stderr.write("fi2 = %s\n" % str(fi2))
rootray.validate(fi2)
assert fi2[0] == +1
assert len(fi2[1]) == 6

fi3 = rootray.intersection(fa, rootray.complement(fa))
rootray.validate(fi3)
assert fi3[0] == +1
assert len(fi3[1]) == 0

fi4 = rootray.intersection(fa, rootray.plenum())
rootray.validate(fi4)
assert fi4 == fa

fi5 = rootray.intersection(fb, rootray.vacuum())
rootray.validate(fi5)
assert fi5[0] == +1
assert len(fi5[1]) == 0

fi6 = rootray.intersection(fb, fb)
rootray.validate(fi6)
assert fi6 == fb

fi8a = (+1, [-2, +2])
fi8b = (-1, [-1, +1])
fi8 = rootray.intersection(fi8a, fi8b)
sys.stderr.write("fi8 = %s\n" % str(fi8))
assert fi8 == (+1, [-2, -1, +1, +2 ])

sys.stderr.write("--- {rootray.difference} ---------------\n")

fd2 = rootray.difference(fa, fb)
sys.stderr.write("fd2 = %s\n" % str(fd2))
rootray.validate(fd2)
assert fd2[0] == +1
assert len(fd2[1]) == 9

fd3 = rootray.difference(fa, rootray.complement(fa))
rootray.validate(fd3)
assert fd3 == fa 

fd4 = rootray.difference(fa, rootray.vacuum())
rootray.validate(fd4)
assert fd4 == fa

fd5 = rootray.difference(fb, rootray.plenum())
rootray.validate(fd5)
assert fd5[0] == +1
assert len(fd5[1]) == 0

fd6 = rootray.difference(fb, fb)
rootray.validate(fd6)
assert fd6[0] == +1
assert len(fd6[1]) == 0

fd8a = (+1, [-2, +2])
fd8b = (+1, [-1, +1])
fd8 = rootray.difference(fd8a, fd8b)
sys.stderr.write("fd8 = %s\n" % str(fd8))
assert fd8 == (+1, [-2, -1, +1, +2 ])

sys.stderr.write("--- {rootray.clip_times} ---------------\n")

fx1 = rootray.clip_time(fa, 4, 100)
rootray.validate(fx1)
assert fx1[0] == -1
assert len(fx1[1]) == 2

fx2 = rootray.clip_time(fa, -1, 1.0e10)
rootray.validate(fx2)
assert fx2 == fa

fx3 = rootray.clip_time(fa, -5, -1)
rootray.validate(fx3)
assert fx3[0] == +1
assert len(fx3[1]) == 0

fx4 = rootray.clip_time(fa, 1.0e10, 2.0e10)
rootray.validate(fx4)
assert fx4[0] == -1
assert len(fx4[1]) == 0
