#! /usr/bin/python3
# Test program for module {rootray_cart}
# Last edited on 2021-02-08 20:33:19 by jstolfi

import rootray_cart
import rootray
import hacks
import rn
import sys
from math import sqrt, sin, cos, floor, ceil, inf, nan, pi

def closenough(f1, f2):
  s1, T1 = f1
  s2, T2 = f2
  if s1 != s2: return False
  if len(T1) != len(T2): return False
  if rn.dist(T1, T2) > 1.0e-10: return False
  return True
  

sys.stderr.write("--- testing {halfspace} ------------------\n")

pa1 = (-1, -2, -3, -4)
qa1 = (+4, +5, +6, +7)
fa1 = rootray_cart.halfspace(pa1, qa1, 2)
sys.stderr.write("fa1 = %s\n" % str(fa1))
assert closenough(fa1, (-1, [ 1.0/3.0 ]))

sys.stderr.write("--- testing {slab} ------------------\n")

pb1 = (-1, -2, -3, -4)
qb1 = (+4, +5, +6, +7)
fb1 = rootray_cart.slab(pb1, qb1, 2)
sys.stderr.write("fb1 = %s\n" % str(fb1))
assert closenough (fb1, (+1, [ 2.0/9.0, 4.0/9.0 ]))

sys.stderr.write("--- testing {ball} ------------------\n")

pc1 = (00, 00, 00)
qc1 = (+2, +2, +1)
fc1 = rootray_cart.ball(pc1, qc1)
sys.stderr.write("fc1 = %s\n" % str(fc1))
assert closenough (fc1, (+1, [ -1.0/3.0, +1.0/3.0 ]))

pc2 = (-3.00, 00.00, +0.50)
qc2 = (+6.00, 00.00, +0.50)
fc2 = rootray_cart.ball(pc2, qc2)
cc2a = cos(pi/6)
tc2a = (-cc2a - pc2[0])/(qc2[0] - pc2[0])
tc2b = (+cc2a - pc2[0])/(qc2[0] - pc2[0])
sys.stderr.write("fc2 = %s\n" % str(fc2))
assert closenough (fc2, (+1, [ tc2a, tc2b ]))

