# --- begin comments by J. Stolfi --------------------------
# Last edited on 1998-12-02 05:40:01 by stolfi
#
# Mapping the interlinear file to the EVA encoding
# Jorge Stolfi 05 Nov 1997 (Corrected 31 Mar 1998)
#
# This transformation was done with "fsg2eva", an AWK
# script. The main step is the following:
#
#   function fsg_to_eva(txt)
#   {
#     # Converts a chunk of comment-free FSG text to EVA
#
#     # We discard  "%" and "!" since the conversion
#     # will destroy synchronism anyway.
#     gsub(/[% !]/, "", txt);
#
#     # Now convert
#     gsub(/IIIE/, "iiil",  txt);
#     gsub(/IIIK/, "iiim",  txt);
#     gsub(/IIIL/, "iiin",  txt);
#     gsub(/IIIR/, "iiir",  txt);
#     gsub(/IIE/,  "iil",   txt);
#     gsub(/IIK/,  "iim",   txt);
#     gsub(/IIL/,  "iin",   txt);
#     gsub(/IIR/,  "iir",   txt);
#     gsub(/IE/,   "il",    txt);
#     gsub(/IK/,   "im",    txt);
#     gsub(/IL/,   "in",    txt);
#     gsub(/IR/,   "ir",    txt);
#     gsub(/HZ/,   "cth",   txt);
#     gsub(/PZ/,   "cph",   txt);
#     gsub(/DZ/,   "ckh",   txt);
#     gsub(/FZ/,   "cfh",   txt);
#     gsub(/2/,    "s",     txt);
#     gsub(/4/,    "q",     txt);
#     gsub(/6/,    "g",     txt);
#     gsub(/7/,    "j",     txt);
#     gsub(/8/,    "d",     txt);
#     gsub(/A/,    "a",     txt);
#     gsub(/C/,    "e",     txt);
#     gsub(/D/,    "k",     txt);
#     gsub(/E/,    "l",     txt);
#     gsub(/F/,    "f",     txt);
#     gsub(/G/,    "y",     txt);
#     gsub(/H/,    "t",     txt);
#     gsub(/I/,    "i",     txt);
#     gsub(/K/,    "m",     txt);
#     gsub(/L/,    "n",     txt);
#     gsub(/M/,    "iin",   txt);
#     gsub(/N/,    "in",    txt);
#     gsub(/O/,    "o",     txt);
#     gsub(/P/,    "p",     txt);
#     gsub(/R/,    "r",     txt);
#     gsub(/S/,    "sh",    txt);
#     gsub(/T/,    "ch",    txt);
#     gsub(/V/,    "v",     txt);
#     gsub(/Y/,    "x",     txt);
#
#     return txt
#   }
#
# This procedure was applied to the Voynich text proper, preserving
# the '#' and '{}' comments as well as the location codes.
#
# I had to edit manually some '{}' comments that contained Voynich
# characters in FSG or Currier notation.  The affected pages are
#
#   f100r.P1  f100r.m  f100v.M  f103r.P  f104r.P  f49v.P  f65v.P
#   f66r.R    f76r.R   f89r1.b  f89r2.b
#
# Note: The 05 Nov 1997 version of this script incorrectly mapped "IK" to
# "ik" instead of "im". This error affected 79 lines of Gabriel Landini's
# interlinar v1.6, representing about 50 distinct words. The error was
# corrected on 31 Mar 1998, by manually editing the EVA translation of
# those lines. The endings "IIIK", "IIK", and "K" were not affected by
# this error.
#
# The following is a cumulative list of other format and alignment bugs
# that were fixed by hand in the EVA translation, up to 26 Oct 1998:
#
#
#   <f1r.P3.17;C>   replaced "iiir" by "o".
#   <f1r.P3.18;C>   deleted "." at end of line.
#
#   <f3v.P.4;C>     replaced "iiir" by "o".
#   <f3v.P.13;C>    replaced "iiir" by "o".
#
#   <f6v.P.4;C>     replaced "iiir" by "o".
#   <f6v.P.4;D>     replaced "iiir" by "o".
#
#   <f8r.P2.10;F>   added "m" at end of line.
#   <f8r.P2.11;F>   deleted "m." at beginning of line.
#   <f8r.T2.13;F>   added "m" at end of line.
#   <f8r.P3.14;F>   deleted "m." at beginning of line.
#   <f8r.P3.17;F>   deleted whole line.
#   <f8r.P3.18;F>   added "okar." at beginning of line.
#
#   <f11v.P.1;C>    replaced "." by "-" between words 4 and 5.
#   <f11v.P.1;F>    replaced "." by "-" between words 4 and 5.
#   <f11v.P.2;C>    replaced "." by "-" between words 6 and 7.
#   <f11v.P.2;F>    replaced "." by "-" between words 6 and 7.
#   <f11v.P.3;C>    replaced "." by "-" between words 6 and 7.
#   <f11v.P.3;F>    replaced "." by "-" between words 6 and 7.
#   <f11v.P.4;C>    replaced "." by "-" between words 5 and 6.
#   <f11v.P.4;F>    replaced "." by "-" between words 5 and 6.
#   <f11v.P.4;F>    added "on" at end of line.
#   <f11v.P.5;C>    replaced "." by "-" between words 6 and 7.
#   <f11v.P.5;F>    replaced "." by "-" between words 5 and 6.
#   <f11v.P.5;F>    deleted "on." from beginning of line.
#   <f11v.P.5;F>    added "m" at end of line.
#   <f11v.P.6;F>    deleted "m." from beginning of line.
#
#   <f13r.P.1;F>    added "m" at end of line.
#   <f13r.P.2;F>    deleted "m." at beginning of line.
#
#   <f14r.P.12;F>   added "m" at end of line.
#   <f14r.P.13;F>   deleted "m" at beginning of line.
#
#   <f14v.P.8;C>    replaced "." by "-" between words 2 and 3.
#   <f14v.P.8;F>    replaced "." by "-" between words 2 and 3.
#   <f14v.P.9;C>    replaced "." by "-" between words 2 and 3.
#   <f14v.P.9;F>    replaced "." by "-" between words 2 and 3.
#
#   <f15r.P.9;F>    deleted ".y" at end of line.
#   <f15r.P.10;F>   added "y" at beginning of line.
#
#   <f15v.P.7;F>    added "s" at end of line.
#   <f15v.P.8;F>    deleted "s." at beginning of line.
#
#   <f17r.P.9;C>    replaced "iiir" by "o".
#
#   <f17v.P.16;F>   added "m" at end of line.
#   <f17v.P.17;F>   deleted "m." at beginning of line.
#
#   <f18r.P.2;F>    added "iiin" at end of line.
#   <f18r.P.3;F>    deleted "iiin." at beginning of line.
#   <f18r.P.3;F>    added "m" at end of line.
#   <f18r.P.4;F>    deleted "m." at beginning of line.
#
#   <f18v.P.4;F>    added "r" at end of line.
#   <f18v.P.5;F>    deleted "r." from beginning of line.
#
#   <f19v.P.6;C>    replaced by "{missing line}" comment.
#   <f19v.P.6;F>    truncated after "chocthy.s".
#   <f19v.P.6a;C>   new line, same as old <f19v.P.6;C>.
#   <f19v.P.6a;F>   new line, with the part of old <f19v.P.6;F> after "chocthy.s".
#
#   <f20v.P.7;C>    replaced "." by "-" between words 7 and 8.
#   <f20v.P.7;F>    replaced "." by "-" between words 7 and 8.
#   <f20v.P.10;F>   deleted "*." at beginning of line.
#
#   <f21v.P.4;C>    replaced "." by "-" between words 7 and 8.
#   <f21v.P.4;F>    replaced "." by "-" between words 7 and 8.
#
#   <f22v.P.1;C>    replaced "." by "-" between words 5 and 6.
#   <f22v.P.1;F>    replaced "." by "-" between words 5 and 6.
#   <f22v.P.2;C>    replaced "." by "-" between words 5 and 6.
#   <f22v.P.2;F>    replaced "." by "-" between words 5 and 6.
#   <f22v.P.3;C>    replaced "." by "-" between words 5 and 6.
#   <f22v.P.3;F>    replaced "." by "-" between words 6 and 7.
#   <f22v.P.4;C>    replaced "." by "-" between words 3 and 4, 5 and 6.
#   <f22v.P.4;F>    replaced "." by "-" between words 3 and 4, 5 and 6.
#
#   <f23r.P.7;F>    added "m" at end of line.
#   <f23r.P.8;F>    deleted "m." at beginning of line.
#
#   <f23v.P.2;C>    replaced "." by "-" between words 5 and 6.
#   <f23v.P.2;F>    replaced "." by "-" between words 6 and 7.
#   <f23v.P.3;C>    replaced "." by "-" between words 7 and 8.
#   <f23v.P.3;F>    replaced "." by "-" between words 7 and 8.
#   <f23v.P.4;C>    replaced "." by "-" between words 5 and 6.
#   <f23v.P.4;F>    replaced "." by "-" between words 4 and 5.
#
#   <f24r.P.4;F>    added "a" at end of line.
#   <f24r.P.5;F>    deleted "a." at beginning of line.
#
#   <f24v.P.4;F>    deleted "y." at beginning of line.
#   <f24v.P.4;F>    deleted ".oeor" at end of line.
#   <f24v.P.5;F>    added "oeor." at beginning of line.
#
#   <f25r.P.3;F>    added "in" at end of line.
#   <f25r.P.4;F>    deleted "in." at beginning of line.
#
#   <f26r.P.2;F>    added "r" at end of line.
#   <f26r.P.3;F>    deleted "r." at beginning of line.
#
#   <f27r.P.9;F>    added "m" at end of line.
#   <f27r.P.10;F>   deleted "m." at beginning of line.
#
#   <f27v.P.4;F>    bogus "=" in middle of line; replaced by ".".
#   <f27v.P.5;C>    replaced by "{missing line}" comment.
#   <f27v.P.5;F>    truncated after "ctho.dol".
#   <f27v.P.6;C>    added old <f27v.P.5;C> at beginning of line.
#   <f27v.P.6;F>    added the truncated part of old <f27v.P.5;F> at beginning of line.
#
#   <f28v.P2.7;C>   replaced "." by "-" between words 6 and 7.
#   <f28v.P2.7;F>   replaced "." by "-" between words 6 and 7.
#
#   <f29v.P.4;F>    replaced "." by "-" between words 6 and 7.
#   <f29v.P.4;F>    deleted "-" between words 7 and 8.
#   <f29v.P.5;C>    replaced "." by "-" between words 3 and 4.
#   <f29v.P.5;F>    replaced "." by "-" between words 3 and 4.
#   <f29v.P.6;C>    replaced "." by "-" between words 5 and 6.
#   <f29v.P.6;F>    replaced "." by "-" between words 5 and 6.
#   <f29v.P.6;C>    replaced "." by "-" between words 7 and 8.
#   <f29v.P.6;F>    replaced "." by "-" between words 7 and 8.
#   <f29v.P.7;C>    deleted extra "-" between words 5 and 6.
#   <f29v.P.7;F>    deleted "--" between words 5 and 6.
#   <f29v.P.7;F>    replaced "." by "-" between words 5 and 6.
#   <f29v.P.8;C>    replaced "." by "-" between words 4 and 5.
#   <f29v.P.8;F>    replaced "." by "-" between words 5 and 6.
#   <f29v.P.9;C>    replaced "." by "-" between words 6 and 7.
#   <f29v.P.9;F>    replaced "." by "-" between words 6 and 7.
#   <f29v.P.10;C>   replaced "." by "-" between words 3 and 4.
#   <f29v.P.10;C>   replaced "." by "-" between words 4 and 5.
#   <f29v.P.10;F>   replaced "." by "-" between words 3 and 4.
#   <f29v.P.10;F>   inserted "-" in word 4 between "cth" and "chyd".
#
#   <f30r.P.3;F>    added "im" at end of line.
#   <f30r.P.4;F>    deleted "im." from beginning of line.
#   <f30r.P.12;F>   added "iin" at end of line.
#   <f30r.P.13;F>   deleted "iin." at beginning of line.
#
#   <f30v.P.7;C>    replaced "iiir" by "o".
#
#   <f31r.P.15;F>   added "r" at end of line.
#   <f31r.T.16;F>   deleted "r." at beginning of line.
#
#   <f31v.P.2;F>    deleted starting from "ykeeo"
#   <f31v.P.3;F>    created from parts of lines 2 and 4.
#   <f31v.P.4;F>    deleted up to "lkedy".
#   <f31v.P.4;F>    added "m" at end of line.
#   <f31v.P.5;F>    deleted "m." at beginning of line.
#
#   <f32r.P.2;F>    added "f" at end of line.
#   <f32r.P.3;F>    deleted "f." at beginning of line.
#
#   <f33r.P.5;C>    replaced "iir" by "o".
#
#   <f33v.P.1;C>    replaced "." by "-" between words 2 and 3.
#   <f33v.P.1;F>    replaced "." by "-" between words 2 and 3.
#   <f33v.P.1;F>    added ".es" at end of line.
#   <f33v.P.2;F>    deleted "es." from beginning of line.
#   <f33v.P.2;C>    replaced "." by "-" between "oky" and "otal.
#   <f33v.P.2;F>    replaced "." by "-" between "oky" and "otal.
#   <f33v.P.4;F>    added "iin" at end of line.
#   <f33v.P.5;F>    deleted "iin." at beginning of line.
#   <f33v.P.7;C>    replaced "." by "-" between "oky" and "cheol".
#   <f33v.P.7;F>    replaced "." by "-" between "oky" and "cheol".
#   <f33v.P.8;C>    replaced "." by "-" between "chy" and "daiin".
#   <f33v.P.8;F>    replaced "." by "-" between "chy" and "daiin".
#   <f33v.P.9;C>    replaced "." by "-" between "chckhy" and "ar.aiin".
#   <f33v.P.9;F>    replaced "." by "-" between "chckhy" and "ar.aiin".
#   <f33v.P.9;C>    replaced ".-" by "-".
#   <f33v.P.9;F>    replaced ".-" by "-".
#
#   <f34r.P.7;F>    moved "iir.amm." to end of line.
#   <f34r.P.9;F>    "chZt" replaced by "chcth" (from ";C>" version).
#
#   <f34v.P.6;F>    deleted ".olchdaiin" at end of line.
#   <f34v.P.7;F>    added "olchdaiin." at beginning of line.
#
#   <f36v.P.7;C>    replaced "iiir" by "o".
#
#   <f37r.P.10;F>   added "iir" at end of line.
#   <f37r.P.11;F>   deleted "iir." at beginning of line.
#
#   <f37v.P.15;F>   added "in" at end of line.
#   <f37v.P.16;F>   deleted "in." at beginning of line.
#   <f37v.P.19;F>   truncated line after "qokoiiin.ykeeols".
#   <f37v.P.19a;F>  created line with part of <f37v.P.19;F>.
#   <f37v.P.19b;F>  created line with part of <f37v.P.19;F>.
#   <f37v.P.19;C>   renumbered <f37v.P.19b;C>.
#
#   <f39r.P.4;F>    added "m" at end of line.
#   <f39r.P.5;F>    deleted "m." at beginning of line.
#
#   <f39v.P.6;C>    replaced "iiir" by "o".
#   <f39v.P.10;F>   added "p" at end of line.
#   <f39v.P.11;F>   deleted "p." at beginning of line.
#
#   <f40r.P.8;F>    added "m" at end of line.
#   <f40r.P.9;F>    deleted "m." from beginning of line.
#
#   <f40v.P.7;F>    added "r" at end of line.
#   <f40v.P.8;F>    deleted "r." at beginning of line.
#
#   <f41r.P.10;C>   replaced "iiir" by ".".
#
#   <f41v.P.3;C>    replaced "iiir" by "o" (twice).
#
#   <f42r.P2.9;C>   renamed <f42r.P2.9a;C>.
#   <f42r.P2.9;F>   truncated line after "shol.ety.chary".
#   <f42r.P2.9;G>   deleted, tail became <f42r.P2.9a;G>.
#   <f42r.P2.9a;F>  created from tail of line <f42r.P2.9;F>.
#   <f42r.P2.9a;G>  created from tail of line <f42r.P2.9;G>.
#   <f42r.P2.14;F>  added "-{plant}daim" at end of line.
#   <f42r.T2.15;F>  deleted "daim=" at beginning of line.
#
#   <f42v.P.4;F>    added "m" at end of line.
#   <f42v.P.4;G>    added "m" at end of line.
#   <f42v.P.5;F>    deleted "m." at beginning of line.
#   <f42v.P.5;G>    deleted "m." at beginning of line.
#
#   <f43r.P.4;G>    leading ".", deleted.
#   <f43r.P.8;F>    replaced "-d.dshedy" on by "d-".
#   <f43r.P.8;G>    deleted from "-d.dshedy" on.
#   <f43r.P.9;C>    replaced by <f43v.P.1;C>.
#   <f43r.P.9;F>    replaced by part of line 8 from "dshedy" on.
#   <f43r.P.10;C>   replaced "iir" by "o".
#   <f43r.P.12;C>   replaced "iir" by "o".
#   <f43r.P.12;F>   added "iin" at end of line.
#   <f43r.P.13;F>   deleted "iin." at beginning of line.
#   <f43r.P.13;G>   deleted "iin." at beginning of line.
#
#   <f43v.P.1;C>    replaced by <f43r.P.9;C>.
#   <f43v.P.2;F>    deleted "y." at beginning of line.
#   <f43v.P.1;F>    added "y" at end of line.
#   <f43v.P.1;G>    added "y" at end of line.
#
#   <f44v.P.5;F>    added "in" at end of line.
#   <f44v.P.5;G>    added "in" at end of line.
#   <f44v.P.6;F>    deleted "in." at beginning of line.
#   <f44v.P.6;G>    deleted "in." at beginning of line.
#   <f44v.P.10;C>   replaced "iiir" by "*".
#
#   <f45r.P.8;F>    added ".m" at end of line.
#   <f45r.P.8;G>    added ".m" at end of line.
#   <f45r.P.9;F>    deleted "m." at beginning of line.
#   <f45r.P.9;G>    deleted "m." at beginning of line.
#
#   <f45v.P.6;F>    added "m" at end of line.
#   <f45v.P.6;G>    added "m" at end of line.
#   <f45v.P.7;F>    deleted "m." at beginning of line.
#
#   <f46v.P.7;G>    duplicate ".", replaced by single ".".
#
#   <f47v.P.9;F>    added "iin" at end of line.
#   <f47v.P.10;F>   deleted "iin." at beginning of line.
#   <f47v.P.10;G>   deleted "iin." at beginning of line.
#   <f47v.P.12;F>   duplicate ".", replaced by single ".".
#   <f47v.P.12;G>   leading ".", deleted.
#
#   <f48v.P.7;F>    bogus "=" in middle of line; replaced by ".".
#   <f48v.P.7;F>    added "y" at end of line.
#   <f48v.P.8;F>    deleted "y." at beginning of line.
#   <f48v.P.8;G>    deleted "y." at beginning of line.
#   <f48v.P.10;C>   replaced "=" by "-" at end of line.
#   <f48v.P.10;F>   deleted ".ykeedal.chckhy. ... .dary=" at end of line.
#   <f48v.P.10;F>   added "-" at end of line.
#   <f48v.P.10;G>   deleted ".ykeedal.*ckhy. ... .dary=" at end of line.
#   <f48v.P.10;G>   added "-" at end of line.
#   <f48v.P.11;C>   created line with "{skipped line}!!! ...".
#   <f48v.P.11;F>   created line with "ykeedal.chckhy. ... .dary=" from <f48v.P.10;F>.
#   <f48v.P.11;G>   created line with "ykeedal.*ckhy. ... .dary=" from <f48v.P.10;G>.
#
#   <f49r.P.20;F>   added "iin" at end of line.
#   <f49r.P.21;F>   deleted "iin." at beginning of line.
#   <f49r.P.21;G>   deleted "iin." at beginning of line.
#
#   <f49v.P.16;F>   added "m" at end of line.
#   <f49v.P.16;G>   added "m" at end of line.
#   <f49v.P.17;F>   deleted "m." from beginning of line.
#   <f49v.P.17;G>   deleted "m." from beginning of line.
#   <f49v.P.19;F>   added "m" at end of line.
#   <f49v.P.19;G>   added "m" at end of line.
#   <f49v.P.20;F>   deleted "m." from beginning of line.
#   <f49v.P.20;G>   deleted "m." from beginning of line.
#   <f49v.P.23;F>   added ".r" at end of line.
#   <f49v.P.23;G>   added ".r" at end of line.
#   <f49v.P.24;F>   deleted "r." from beginning of line.
#   <f49v.P.24;G>   deleted "r." from beginning of line.
#
#   <f50r.P.2;F>    added "ar.okam" at end of line.
#   <f50r.P.3;C>    replaced "iiin" by "o".
#   <f50r.P.3;F>    deleted "ar.okam." from beginning of line.
#   <f50r.P.3;G>    deleted "ar.okam." from beginning of line.
#
#   <f50r.P.4;C>    replaced "iiin" by "o".
#   <f50r.P.4;F>    deleted ".s" from end of line.
#   <f50r.P.4;G>    deleted ".s" from end of line.
#   <f50r.P.5;F>    added "s" at beginning of line.
#   <f50r.P.5;G>    added "s" at beginning of line.
#   <f50r.P.7;C>    replaced "iim" by "o".
#
#   <f51r.P.7;C>    renamed <f51r.P.7a;C>.
#   <f51r.P.7;F>    truncated line after "daiin.ykald".
#   <f51r.P.7;G>    deleted; part of it became <f51r.P.7a;G>.
#   <f51r.P.7a;F>   created from second half of <f51r.P.7;F>.
#   <f51r.P.7a;F>   added "l" at end of line.
#   <f51r.P.7a;G>   created from second half of <f51r.P.7;G>.
#   <f51r.P.7a;G>   added "l" at end of line.
#   <f51r.P.8;F>    deleted "l." from beginning of line.
#
#   <f51v.P.4;F>    added "m" at end of line.
#   <f51v.P.4;F>    added "m" at end of line.
#   <f51v.P.5;F>    deleted "m." from beginning of line.
#
#   <f52r.P.7;F>    added "l" at end of line.
#   <f52r.P.7;G>    added "l" at end of line.
#   <f52r.P.8;F>    deleted "l." from beginning of line.
#   <f52r.P.8;G>    deleted "l." from beginning of line.
#
#   <f52v.P.5;F>    added "m" at end of line.
#   <f52v.P.6;F>    deleted "m." at beginning of line.
#
#   <f53v.P.2;F>    added "y" at end of line.
#   <f53v.P.3;F>    deleted "y." at beginning of line.
#
#   <f54r.P.6;F>    added "ar" at end of line.
#   <f54r.P.7;F>    deleted "ar." at beginning of line.
#
#   <f54v.P.8;C>    deleted bogus text after "okal.om-".
#   <f54v.P.8;F>    deleted "y-" at end of line.
#   <f54v.P.9;F>    added "y" at beginning of line.
#
#   <f55r.P.11;F>   added "iin" at end of line.
#   <f55r.P.12;F>   deleted "iin." at beginning of line.
#
#   <f55v.P.11;F>   added "iin" at end of line.
#   <f55v.P.12;F>   deleted "iin." at beginning of line.
#
#   <f56v.P.4;F>    added "iin" at end of line.
#   <f56v.P.5;F>    deleted "iin." at beginning of line.
#   <f56v.P.12;F>   added "iin" at end of line.
#   <f56v.P.13;F>   deleted "iin." at beginning of line.
#
#   <f58r.P.32;F>   truncated after "qokaldy", moved to <f58r.P.32a;F>.
#   <f58r.P.32a;F>  created from right 2/3 of <f58r.P.32;F>.
#   
#   <f66r.L.14;F>   bogus FSG "Z", replaced by "*".
#
#   <f66r.R.3;C>    duplicate ".", replaced by single ".".
#   <f66r.R.24;C>   replaced "iiir" by "o".
#
#   <f66r.W.1;C>    replaced "iil" by "t" (twice).
#   <f66r.W.1;C>    replaced "ir" by "ch" (four times).
#   <f66r.W.1;C>    replaced "il" by "y" (twice).
#
#   <f66v.P.7;F>    bogus FSG "J", replaced by "*".
#
#   <f68r1.P.3;C>   added "okeey.rar.eckhear.daraj-" at end of line.
#   <f68r1.P.3;F>   added "okey.ror.chckhar.daram-" at end of line.
#   <f68r1.P.4;C>   deleted "okeey.rar.eckhear.daraj-" from end of line.
#   <f68r1.P.4;F>   deleted "okey.ror.chckhar.daram-" from end of line.
#   
#   <f68r2.S.18;R>  added ".chol" at end of line, from <f68r2.S.19;R>.
#   <f68r2.S.18;V>  added ".chol" at end of line, from <f68r2.S.19;V>.
#                   
#   <f68r2.S.19;R>  deleted, merged into <f68r2.S.18;R>
#   <f68r2.S.19;V>  deleted, merged into <f68r2.S.18;V>
#
#   <f68v2.C.1;C>   replaced by join of C.1 thru C.4, with new break at 10:30.
#   <f68v2.C.1;D>   replaced by join of D.1 and C2 thru C.4, with new break at 10:30.
#   <f68v2.C.1;C>   replaced "iiir" by "o".
#   <f68v2.C.1;D>   replaced "iiir" by "o".
#   <f68v2.C.2;C>   deleted line.
#   <f68v2.C.3;C>   deleted line.
#   <f68v2.C.4;C>   deleted line.
#
#   <f68v2.R.2;C>   replaced "iiir" by "o".
#   <f68v2.R.6;C>   replaced "iiir" by "o".
#
#   <f68v3.P.0;F>   deleted ".sshey" from end of line.
#   <f68v3.P.1;F>   added "sshey." at beginning of line.
#
#   <f70r2.P.4;F>   bogus FSG "Z", replaced by "*".
#   <f70r2.P.9;F>   deleted "qokal.chol...cheey.okal-" from end of line.
#   <f70r2.P.9a;F>  created line with "{crease}qokal.chol...cheey.okal-".
#   <f70r2.P.10;F>  deleted "qokal.shkal...qokal.chdy-" from end of line.
#   <f70r2.P.10a;F> created line "qokal.shkal...qokal.chdy-".
#   <f70r2.P.11;F>  deleted "okaiin.chcthey.s.or.ary=" frm end of line.
#   <f70r2.P.11a;F> created line with "okaiin.chcthey.s.or.ary=".
#
#   <f70v2.???;C>   renamed <f70v2.R1.1;C>.
#   <f70v2.???;C>   renamed <f70v2.R2.1;C>.
#   <f70v2.???;C>   renamed <f70v2.R3.1;C>.
#
#   <f70v2.01A;K>   renamed <f70v2.S1.10;K>.  
#   <f70v2.02A;K>   renamed <f70v2.S1.1;K>.  
#   <f70v2.03A;K>   renamed <f70v2.S1.2;K>.   
#   <f70v2.04A;K>   renamed <f70v2.S1.3;K>.   
#   <f70v2.05A;K>   renamed <f70v2.S1.4;K>.   
#   <f70v2.06A;K>   renamed <f70v2.S1.5;K>.   
#   <f70v2.07A;K>   renamed <f70v2.S1.6;K>.   
#   <f70v2.08A;K>   renamed <f70v2.S1.7;K>.   
#   <f70v2.09A;K>   renamed <f70v2.S1.8;K>.   
#   <f70v2.10A;K>   renamed <f70v2.S1.9;K>.
#   <f70v2.11A;K>   renamed <f70v2.S2.17;K>.
#   <f70v2.12A;K>   renamed <f70v2.S2.18;K>.
#   <f70v2.13A;K>   renamed <f70v2.S2.19;K>.
#   <f70v2.14A;K>   renamed <f70v2.S2.1;K>.
#   <f70v2.15A;K>   renamed <f70v2.S2.2;K>.
#   <f70v2.16A;K>   renamed <f70v2.S2.3;K>.
#   <f70v2.17A;K>   renamed <f70v2.S2.4;K>.
#   <f70v2.18A;K>   renamed <f70v2.S2.5;K>.
#   <f70v2.19A;K>   renamed <f70v2.S2.6;K>.
#   <f70v2.20A;K>   renamed <f70v2.S2.7;K>.
#   <f70v2.21A;K>   renamed <f70v2.S2.8;K>.
#   <f70v2.22A;K>   renamed <f70v2.S2.9;K>.
#   <f70v2.23A;K>   renamed <f70v2.S2.10;K>.
#   <f70v2.24A;K>   renamed <f70v2.S2.11;K>.
#   <f70v2.25A;K>   renamed <f70v2.S2.12;K>.
#   <f70v2.26A;K>   renamed <f70v2.S2.13;K>.
#   <f70v2.27A;K>   renamed <f70v2.S2.14;K>.
#   <f70v2.28A;K>   renamed <f70v2.S2.15;K>.
#   <f70v2.29A;K>   renamed <f70v2.S2.16;K>.
#
#   <f70v1.01A;K>   renamed <f70v1.S2.11;K>.
#   <f70v1.02A;K>   renamed <f70v1.S2.12;K>.
#   <f70v1.03A;K>   renamed <f70v1.S2.13;K>.
#   <f70v1.04A;K>   renamed <f70v1.S2.14;K>.
#   <f70v1.05A;K>   renamed <f70v1.S2.15;K>.
#   <f70v1.06A;K>   renamed <f70v1.S1.1;K>.
#   <f70v1.07A;K>   renamed <f70v1.S1.2;K>.
#   <f70v1.08A;K>   renamed <f70v1.S1.3;K>.
#   <f70v1.09A;K>   renamed <f70v1.S1.4;K>.
#   <f70v1.10A;K>   renamed <f70v1.S1.5;K>.
#   <f70v1.11A;K>   renamed <f70v1.S1.6;K>.
#   <f70v1.12A;K>   renamed <f70v1.S1.7;K>.
#   <f70v1.13A;K>   renamed <f70v1.S1.8;K>.
#   <f70v1.14A;K>   renamed <f70v1.S1.9;K>.
#   <f70v1.15A;K>   renamed <f70v1.S1.10;K>.
#
#   <f71r.01A;K>    renamed <f71r.S2.1;K>.
#   <f71r.02A;K>    renamed <f71r.S2.2;K>.
#   <f71r.03A;K>    renamed <f71r.S2.3;K>.
#   <f71r.04A;K>    renamed <f71r.S2.4;K>.
#   <f71r.05A;K>    renamed <f71r.S2.5;K>.
#   <f71r.06A;K>    renamed <f71r.S1.1;K>.
#   <f71r.07A;K>    renamed <f71r.S1.2;K>.
#   <f71r.08A;K>    renamed <f71r.S1.3;K>.
#   <f71r.09A;K>    renamed <f71r.S1.4;K>.
#   <f71r.10A;K>    renamed <f71r.S1.5;K>.
#   <f71r.11A;K>    renamed <f71r.S1.6;K>.
#   <f71r.12A;K>    renamed <f71r.S1.7;K>.
#   <f71r.13A;K>    renamed <f71r.S1.8;K>.
#   <f71r.14A;K>    renamed <f71r.S1.9;K>.
#   <f71r.15A;K>    renamed <f71r.S1.10;K>.
# 
#   <f71v.???;C>    renamed <f71v.R1.1;C>.
#   <f71v.???;C>    renamed <f71v.R2.1;C>.
#   <f71v.???;C>    renamed <f71v.R3.1;C>.
#
#   <f71v.01A;K>    renamed <f71v.S2.1;K>.
#   <f71v.02A;K>    renamed <f71v.S2.2;K>.
#   <f71v.03A;K>    renamed <f71v.S2.3;K>.
#   <f71v.04A;K>    renamed <f71v.S2.4;K>.
#   <f71v.05A;K>    renamed <f71v.S2.5;K>.
#   <f71v.06A;K>    renamed <f71v.S1.1;K>.
#   <f71v.07A;K>    renamed <f71v.S1.2;K>.
#   <f71v.08A;K>    renamed <f71v.S1.3;K>.
#   <f71v.09A;K>    renamed <f71v.S1.4;K>.
#   <f71v.10A;K>    renamed <f71v.S1.5;K>.
#   <f71v.11A;K>    renamed <f71v.S1.6;K>.
#   <f71v.12A;K>    renamed <f71v.S1.7;K>.
#   <f71v.13A;K>    renamed <f71v.S1.8;K>.
#   <f71v.14A;K>    renamed <f71v.S1.9;K>.
#   <f71v.15A;K>    renamed <f71v.S1.10;K>.
#
#   <f72r1.01A;K>    renamed <f72r1.S2.1;K>.
#   <f72r1.02A;K>    renamed <f72r1.S2.2;K>.
#   <f72r1.03A;K>    renamed <f72r1.S2.3;K>.
#   <f72r1.04A;K>    renamed <f72r1.S2.4;K>.
#   <f72r1.05A;K>    renamed <f72r1.S2.5;K>.
#   <f72r1.06A;K>    renamed <f72r1.S1.1;K>.
#   <f72r1.07A;K>    renamed <f72r1.S1.2;K>.
#   <f72r1.08A;K>    renamed <f72r1.S1.3;K>.
#   <f72r1.09A;K>    renamed <f72r1.S1.4;K>.
#   <f72r1.10A;K>    renamed <f72r1.S1.5;K>.
#   <f72r1.11A;K>    renamed <f72r1.S1.6;K>.
#   <f72r1.12A;K>    renamed <f72r1.S1.7;K>.
#   <f72r1.13A;K>    renamed <f72r1.S1.8;K>.
#   <f72r1.14A;K>    renamed <f72r1.S1.9;K>.
#   <f72r1.15A;K>    renamed <f72r1.S1.10;K>.
#
#   <f72r2.01A;K>    renamed <f72r2.S2.1;K>.
#   <f72r2.02A;K>    renamed <f72r2.S2.2;K>.
#   <f72r2.03A;K>    renamed <f72r2.S2.3;K>.
#   <f72r2.04A;K>    renamed <f72r2.S2.4;K>.
#   <f72r2.05A;K>    renamed <f72r2.S2.5;K>.
#   <f72r2.06A;K>    renamed <f72r2.S2.6;K>.
#   <f72r2.07A;K>    renamed <f72r2.S2.7;K>.
#   <f72r2.08A;K>    renamed <f72r2.S2.8;K>.
#   <f72r2.09A;K>    renamed <f72r2.S2.9;K>.
#   <f72r2.10A;K>    renamed <f72r2.S1.1;K>.
#   <f72r2.11A;K>    renamed <f72r2.S1.2;K>.
#   <f72r2.12A;K>    renamed <f72r2.S1.3;K>.
#   <f72r2.13A;K>    renamed <f72r2.S1.4;K>.
#   <f72r2.14A;K>    renamed <f72r2.S1.5;K>.
#   <f72r2.15A;K>    renamed <f72r2.S1.6;K>.
#   <f72r2.16A;K>    renamed <f72r2.S1.7;K>.
#   <f72r2.17A;K>    renamed <f72r2.S1.8;K>.
#   <f72r2.18A;K>    renamed <f72r2.S1.9;K>.
#   <f72r2.19A;K>    renamed <f72r2.S1.10;K>.
#   <f72r2.20A;K>    renamed <f72r2.S1.11;K>.
#   <f72r2.21A;K>    renamed <f72r2.S1.12;K>.
#   <f72r2.22A;K>    renamed <f72r2.S1.13;K>.
#   <f72r2.24A;K>    renamed <f72r2.S1.15;K>.
#   <f72r2.25A;K>    renamed <f72r2.S1.16;K>.
#   <f72r2.26A;K>    renamed <f72r2.S0.1;K>.
#   <f72r2.27A;K>    renamed <f72r2.S0.2;K>.
#   <f72r2.28A;K>    renamed <f72r2.S0.3;K>.
#   <f72r2.29A;K>    renamed <f72r2.S0.4;K>.
#   <f72r2.30A;K>    renamed <f72r2.S0.5;K>.
#   
#   <f75r.P.7;F>    added right half of <f75r.P.8;F>.
#   <f75r.P.8;F>    replaced right half by right half of <f75r.P.9;F>.
#   <f75r.P.9;F>    deleted right half.
#
#   <f75v.P.28;C>   leading ".", deleted.
#
#   <f76r.R.5;F>    added "r" at end of line.
#
#   <f76r.L.6;F>    deleted "r." at beginning of line.
#   <f76r.L.13;F>   deleted "ir." at beginning of line.
#   <f76r.L.14;F>   added "o" label.
#   <f76r.L.15;F>   deleted "o" label.
#   <f76r.L.26;F>   deleted "r" label.
#   <f76r.L.38;F>   deleted "iin" label.
#
#   <f76r.R.12;F>   added "ir" at end of line.
#   <f76r.R.14;F>   added "dchedy.qolchey.qokefy" from line <f76r.R.15;F>.
#   <f76r.R.15;F>   deleted "dchedy.qolchey.qokefy" from beginning of line.
#   <f76r.R.25;F>   added "r" at end of line.
#   <f76r.R.33;F>   added ".lchedy.qolain....otalam" at end of line.
#   <f76r.R.34;F>   deleted "lchedy.qolain....otalam." at beginning of line.
#   <f76r.R.37;F>   added "iin" at end of line.
#
#   <f77v.P.28;F>   added "iin" at end of line.
#   <f77v.P.29;F>   deleted "iin." at beginning of line.
#
#   <f78r.P.7;F>    deleted ".dar.alocfhy" at end of line.
#   <f78r.P.11;F>   deleted ".dchedaly" at end of line.
#   <f78r.P.24;F>   deleted ".otarodl.shy.orory" at end of line.
#
#   <f78r.X.4;F>    added line "dchedaly=" from <f78r.P.11;F>.
#   <f78r.X.3;F>    added line "dar.alocfhy=" from <f78r.P.7;F>.
#   <f78r.X.5;F>    added line "otarodl.shy.orory=" from <f78r.P.24;F>.
#
#   <f78v.P.3;F>    added "m" at end of line.
#   <f78v.P.4;F>    deleted "m." at beginning of line.
#   <f78v.P.8;G>    replaced "iiim" by "in".
#   <f78v.P.8;F>    added "iin" at end of line.
#   <f78v.P.9;F>    deleted "iin." at beginning of line.
#   <f78v.P.15;F>   added "s" at end of line.
#   <f78v.P.16;F>   deleted "s." at beginning of line.
#
#   <f79r.P.9;F>    added "m" at end of line.
#   <f79r.P.10;F>   deleted "m." at beginning of line.#
#   <f79r.P.14;F>   added ".cheey.chey.daiin.chedy.qol" at end of line.
#   <f79r.P.15;F>   deleted "cheey.chey.daiin.chedy.qol." at beginning of line.
#   <f79r.P.16;F>   added "m" at end of line.
#   <f79r.P.17;F>   deleted "m." at beginning of line.
#   <f79r.P.30;F>   deleted bogus "-" in "olon".
#
#   <f79v.P.8;F>    added "l" at end of line.
#   <f79v.P.9;F>    deleted "l" at beginning of line.
#   <f79v.P.13;F>   added "m" at end of line.
#   <f79v.P.14;F>   deleted "m." at beginning of line.
#   <f79v.P.15;F>   added "iin" at end of line.
#   <f79v.P.16;F>   deleted "iin." at beginning of line.
#   <f79v.P.18;F>   deleted ".y" from linendof line.
#   <f79v.P.19;F>   added "y" at beginning of line.
#   <f79v.P.26;F>   added "*" at end of line.
#   <f79v.P.27;F>   deleted "*." at beginning of line.
#   <f79v.P.31;F>   added "iin" at end of line.
#   <f79v.P.32;F>   deleted "iin." at beginning of line.
#   <f79v.P.38;F>   added "m" at end of line.
#   <f79v.P.39;F>   deleted ""m."" at beginning of line.
#   <f79v.P.41;F>   added "iin" at end of line.
#   <f79v.P.42;F>   deleted "iin." at beginning of line.
#
#   <f80r.P.2;F>    added "s" at end of line.
#   <f80r.P.3;F>    deleted "s." at beginning of line.
#   <f80r.P.3;F>    added "m" at end of line.
#   <f80r.P.4;F>    deleted "m." at beginning of line.
#   <f80r.P.7;F>    added "m" at end of line.
#   <f80r.P.8;F>    deleted "m." at beginning of line.
#   <f80r.P.10;F>   added "m" at end of line.
#   <f80r.P.11;F>   deleted "m." at beginning of line.
#   <f80r.P.16;F>   deleted whole line.
#   <f80r.P.17;F>   added "qol." in front from pev line.
#   <f80r.P.38;F>   added "m" at end of line.
#   <f80r.P.39;F>   deleted "m." at beginning of line.
#   <f80r.P.41;F>   added "***.*" at beginning of line.
#   <f80r.P.40;F>   replaced "o-" by "o**-"
#
#   <f80v.P.14;F>   added "r" at end of line.
#   <f80v.P.15;F>   deleted "r." at beginning of line.
#   <f80v.P.21;F>   added "m" at end of line.
#   <f80v.P.22;F>   deleted "m." at beginning of line.
#   <f80v.P.33;F>   added "m" at end of line.
#   <f80v.P.34;F>   deleted "m." at beginning of line.
#   <f80v.P.31;F>   added "iin" at end of line.
#   <f80v.P.32;F>   deleted "iin." at beginning of line.
#
#   <f81r.P.5;F>    added "iin" at end of line.
#   <f81r.P.6;F>    deleted "iin." at beginning of line.
#   <f81r.P.7;F>    added "iin" at end of line.
#   <f81r.P.8;F>    deleted "iin." at beginning of line.
#
#   <f81v.P.4;F>    added "y" at end of line.
#   <f81v.P.5;F>    deleted "y." at beginning of line.
#
#   <f81v.P.5;F>    added ".kar.daiin.okar" at end of line.
#   <f81v.P.6;F>    deleted "kar.daiin.okar." at beginning of line.
#
#   <f81v.P.15;F>   added "*{skipped text}" after ".chedy.o"
#   <f81v.P.15;F>   deleted ".qor." at end of line.
#   <f81v.P.16;F>   added "qor." at beginning of line.
#
#   <f82r.P1.10;C>  renamed <f82r.P2.10;C>.
#   <f82r.P1.10;F>  renamed <f82r.P2.10;F>.
#   <f82r.P1.10;V>  renamed <f82r.P2.10;V>.
#                   
#   <f82r.P1.11;C>  renamed <f82r.P2.11;C>.
#   <f82r.P1.11;F>  renamed <f82r.P2.11;F>.
#   <f82r.P1.11;V>  renamed <f82r.P2.11;V>.
#                   
#   <f82r.P1.12;C>  renamed <f82r.P2.12;C>.
#   <f82r.P1.12;F>  renamed <f82r.P2.12;F>.
#   <f82r.P1.12;V>  renamed <f82r.P2.12;V>.
#                   
#   <f82r.P1.13;C>  renamed <f82r.P2.13;C>.
#   <f82r.P1.13;F>  renamed <f82r.P2.13;F>.
#   <f82r.P1.13;V>  renamed <f82r.P2.13;V>.
#                   
#   <f82r.P1.14;C>  renamed <f82r.P2.14;C>.
#   <f82r.P1.14;F>  renamed <f82r.P2.14;F>.
#   <f82r.P1.14;V>  renamed <f82r.P2.14;V>.
#                   
#   <f82r.P1.15;C>  renamed <f82r.P2.15;C>.
#   <f82r.P1.15;F>  renamed <f82r.P2.15;F>.
#   <f82r.P1.15;V>  renamed <f82r.P2.15;V>.
#                   
#   <f82r.P1.16;C>  renamed <f82r.P2.16;C>.
#   <f82r.P1.16;F>  renamed <f82r.P2.16;F>.
#   <f82r.P1.16;V>  renamed <f82r.P2.16;V>.
#                   
#   <f82r.P1.17;C>  renamed <f82r.P2.17;C>.
#   <f82r.P1.17;F>  renamed <f82r.P2.17;F>.
#   <f82r.P1.17;V>  renamed <f82r.P2.17;V>.
#
#   <f82r.T1>       unit renamed <f82r.T2>.
#
#   <f82r.T1.18;C>  renamed <f82r.T2.18;C>.
#   <f82r.T1.18;F>  renamed <f82r.T2.18;F>.
#   <f82r.T1.18;V>  renamed <f82r.T2.18;V>.
#
#   <f82r.P3>       unit created.
#
#   <f82r.P2.19;C>  renamed <f82r.P3.19;C>.
#   <f82r.P2.19;F>  renamed <f82r.P3.19;F>.
#   <f82r.P2.19;V>  renamed <f82r.P3.19;V>.
#                   
#   <f82r.P2.20;C>  renamed <f82r.P3.20;C>.
#   <f82r.P2.20;F>  renamed <f82r.P3.20;F>.
#   <f82r.P2.20;V>  renamed <f82r.P3.20;V>.
#                   
#   <f82r.P2.21;C>  renamed <f82r.P3.21;C>.
#   <f82r.P2.21;F>  renamed <f82r.P3.21;F>.
#   <f82r.P2.21;V>  renamed <f82r.P3.21;V>.
#                   
#   <f82r.P2.22;C>  renamed <f82r.P3.22;C>.
#   <f82r.P2.22;F>  renamed <f82r.P3.22;F>.
#   <f82r.P2.22;V>  renamed <f82r.P3.22;V>.
#                   
#   <f82r.P2.23;C>  renamed <f82r.P3.23;C>.
#   <f82r.P2.23;F>  renamed <f82r.P3.23;F>.
#   <f82r.P2.23;V>  renamed <f82r.P3.23;V>.
#                   
#   <f82r.P2.24;C>  renamed <f82r.P3.24;C>.
#   <f82r.P2.24;F>  renamed <f82r.P3.24;F>.
#   <f82r.P2.24;V>  renamed <f82r.P3.24;V>.
#                   
#   <f82r.P2.25;C>  renamed <f82r.P3.25;C>.
#   <f82r.P2.25;F>  renamed <f82r.P3.25;F>.
#   <f82r.P2.25;V>  renamed <f82r.P3.25;V>.
#                   
#   <f82r.P2.26;C>  renamed <f82r.P3.26;C>.
#   <f82r.P2.26;F>  renamed <f82r.P3.26;F>.
#   <f82r.P2.26;V>  renamed <f82r.P3.26;V>.
#                   
#   <f82r.P2.27;C>  renamed <f82r.P3.27;C>.
#   <f82r.P2.27;F>  renamed <f82r.P3.27;F>.
#   <f82r.P2.27;V>  renamed <f82r.P3.27;V>.
#                   
#   <f82r.P2.28;C>  renamed <f82r.P3.28;C>.
#   <f82r.P2.28;F>  renamed <f82r.P3.28;F>.
#   <f82r.P2.28;V>  renamed <f82r.P3.28;V>.
#                   
#   <f82r.P2.29;C>  renamed <f82r.P3.29;C>.
#   <f82r.P2.29;F>  renamed <f82r.P3.29;F>.
#   <f82r.P2.29;V>  renamed <f82r.P3.29;V>.
#                   
#   <f82r.P2.30;C>  renamed <f82r.P3.30;C>.
#   <f82r.P2.30;F>  renamed <f82r.P3.30;F>.
#   <f82r.P2.30;V>  renamed <f82r.P3.30;V>.
#                   
#   <f82r.P2.31;C>  renamed <f82r.P3.31;C>.
#   <f82r.P2.31;F>  added "iin" at end of line.
#   <f82r.P2.31;F>  renamed <f82r.P3.31;F>.
#   <f82r.P2.31;V>  renamed <f82r.P3.31;V>.
#                   
#   <f82r.P2.32;C>  renamed <f82r.P3.32;C>.
#   <f82r.P2.32;F>  deleted "iin." at beginning of line.
#   <f82r.P2.32;F>  renamed <f82r.P3.32;F>.
#   <f82r.P2.32;V>  renamed <f82r.P3.32;V>.
#
#   <f82r.X>        unit deleted, split into <f82r.L1> and <f822.L2>
#
#   <f82r.X.1;V>    renamed <f82r.L2.11;V>.
#   <f82r.X.2;V>    renamed <f82r.L2.2;V>.
#   <f82r.X.3;V>    renamed <f82r.L2.1;V>.
#   <f82r.X.4;V>    renamed <f82r.L2.10;V>.
#   <f82r.X.5;V>    renamed <f82r.L2.6;V>.
#   <f82r.X.6;V>    renamed <f82r.L2.5;V>.
#   <f82r.X.7;V>    renamed <f82r.L2.4;V>.
#   <f82r.X.8;V>    renamed <f82r.L2.3;V>.
#   <f82r.X.9;V>    renamed <f82r.L2.8;V>.
#   <f82r.X.10;V>   renamed <f82r.L2.12;V>.
#   <f82r.X.11;V>   renamed <f82r.L1.1;V>.
#   <f82r.X.12;V>   renamed <f82r.L2.7;V>.
#   <f82r.X.13;V>   renamed <f82r.L2.9;V>.
#
#   <f82v.P.21;F>   added "***." at beginning of line.
#   <f82v.P.30;F>   added "iin" at end of line.
#   <f82v.P.31;F>   deleted "iin." at beginning of line.
#
#   <f83r.P.11;F>   added "o" at end of line.
#   <f83r.P.12;F>   deleted "o." at beginning of line.
#   <f83r.P.25;F>   added "l" at end of line.
#   <f83r.P.26;F>   deleted "l." at beginning of line.
#   <f83r.P.30;F>   added "iin" at end of line.
#   <f83r.P.31;F>   deleted "iin." at beginning of line.
#   <f83r.P.33;F>   added "iin" at end of line.
#   <f83r.P.34;F>   deleted "iin." at beginning of line.
#   <f83r.P.32;F>   split part to "shedal" as line <f83r.X.3;F>
#   <f83r.P.33;F>   split part to "chdal aiin" as line <f83r.X.4;F>
#   <f83r.P.34;F>   split part to "chedy" as line <f83r.X.5;F>
#   <f83r.P.41;C>   split part to "raly.ol" as line <f83r.Z.8;F>
#   <f83r.P.41;F>   split part to "raly.ol" as line <f83r.Z.8;F>
#   <f83r.P.42;C>   split part to "qotar.ol" as line <f83r.Z.9;F>
#   <f83r.P.42;F>   split part to "qotar.ol" as line <f83r.Z.9;F>
#   <f83r.P.43;C>   split part to "ldalor" as line <f83r.Z.10;F>
#   <f83r.P.43;F>   split part to "ldalor" as line <f83r.Z.10;F>
#   <f83r.P.44;C>   split part to "ctheil" as line <f83r.Z.11;F>
#   <f83r.P.44;F>   split part to "cthol" as line <f83r.Z.11;F>
#   
#   <f83v.P.14;F>   deleted "qokain.cheeal" (nothing left on the line).
#   <f83v.P.15;F>   added "qokain.cheeal." at beginning of line.
#   <f83v.P.16;F>   deleted ".chedy.qol" at end of line.
#   <f83v.P.17;F>   added "chedy.qol" at beginning of line.
#   <f83v.P.20;F>   added "s" at end of line.
#   <f83v.P.20;F>   deleted "okchdy." at beginning of line, moved to <f83v.Y.8;F>.
#   <f83v.P.21;F>   deleted "s." at beginning of line.
#   <f83v.P.25;F>   added "s" at end of line.
#   <f83v.P.26;F>   deleted "s." at beginning of line.
#
#   <f83v.Y.8;F>    created with "okchdy=" from <f83v.P.20;F>.
#
#   <f84r.P.24;C>   deleted to "orol.", moved to <f84r.Z.24;C>.
#   <f84r.P.24;F>   deleted to "orol.", moved to <f84r.Z.24;C>.
#
#   <f84r.P.16;F>   added "iin" at end of line.
#   <f84r.P.17;F>   deleted "iin." at beginning of line.
#   <f84r.P.18;F>   deleted "otaly." at beginning of line.
#   <f84r.P.30;F>   deleted up to first "shedy.saiin.".
#
#   <f84r.X.13;F>   added "otaly=" from <f84r.P.18;F>.
#
#   <f84v.P.12;F>   added "iin" at end of line.
#   <f84v.P.13;F>   deleted "iin." at beginning of line.
#   <f84v.P.21;F>   deleted "okar." at beginning of line.
#   <f84v.P.22;F>   deleted "ydairol." at beginning of line.
#   <f84v.P.23;F>   deleted "ychckhy." at beginning of line.
#   <f84v.P.24;F>   deleted "dshedy." at beginning of line.
#   <f84v.P.31;F>   deleted "okchdy." at beginning of line.
#   <f84v.P.32;F>   deleted "solchey." at beginning of line.
#   <f84v.P.33;F>   deleted "dairoldy." at beginning of line.
#   <f84v.P.34;F>   deleted "dorchy." at beginning of line.
#   <f84v.P.35;F>   added "s" at end of line.
#   <f84v.P.35;F>   deleted "qckhy." at beginning of line.
#   <f84v.P.36;F>   deleted "ochedy." at beginning of line.
#   <f84v.P.36;F>   deleted "s." at beginning of line.
#   <f84v.X.20;F>   created with "okar" from <f84v.P.21;F>.
#   <f84v.X.21;F>   created with "ydairol" from <f84v.P.22;F>.
#   <f84v.X.22;F>   created with "ychckhy" from <f84v.P.23;F>.
#   <f84v.X.23;F>   created with "dshedy" from <f84v.P.24;F>.
#   <f84v.Y.30;F>   created with "okchdy" from <f84v.P.31;F>.
#   <f84v.Y.31;F>   created with "solchey" from <f84v.P.32;F>.
#   <f84v.Y.32;F>   created with "dairoldy" from <f84v.P.33;F>.
#   <f84v.Y.33;F>   created with "dorchy" from <f84v.P.34;F>.
#   <f84v.Y.34;F>   created with "qckhy" from <f84v.P.35;F>.
#   <f84v.Y.35;F>   created with "ochedy" from <f84v.P.36;F>.
#
#   <f85r1.P.29;F>  split off after "qokchdy." as separate line.
#   <f85r1.P.29a;F> created from second half of <f85r1.P.29;F>.
#
#   <f86v4.P.4;F>   deleted ".dar.oleey.olyy" at end of line.
#   <f86v4.P.5;F>   new line with "{centered -- "title"?}dar.oleey.olyy=".
#
#   <f86v6.P.22;F>  bogus FSG "X", replaced by "*".
#
#   <f86v5.P.7;F>   deleted ".octhal" at end of line.
#   <f86v5.P.8;F>   added "octhal." at beginning of line.
#   <f86v5.P.9;F>   truncated line after "al.ykain".
#   <f86v5.P.9a;F>  created line from right half of <f86v5.P.9;F>.
#   <f86v5.P.18;F>  truncated line after "chey.shckhy".
#   <f86v5.P.18a;F> created line from right half of <f86v5.P.18;F>.
#   <f86v5.P.22;F>  deleted ".sair" at end of line. 
#   <f86v5.P.23;F>  added "sair." at beginning of line.
#
#   <f86v3.P.4;F>   added "ykaiin{skipped line}m" at beginning of line
#   <f86v3.P.5;F>   deleted "ykaiinm." from beginning of line.
#
#   <f87v.P.3;F>    truncated from "ycheockhy.okey" onwards.
#   <f87v.P.3a;F>   created from right half of <f87v.P.3;F>.
#   <f87v.P.4;F>    truncated from "dcheos.shey" onwards.
#   <f87v.P.4a;F>   created from right half of <f87v.P.4;F>.
#   <f87v.P.6;F>    truncated from "techol.qoshcheody" onwards.
#   <f87v.P.6a;F>   created from right half of <f87v.P.6;F>.
#
#   <f88r.b.3;L>    replaced "iiir" by "o".
#
#   <f88v.P1.3;L>   replaced "iiir" by "o".
#   <f88v.P1.4;L>   replaced "iiir" by "o" (twice).
#
#   <f88v.P2.7;L>   replaced "iiir" by "o".
#   <f88v.P2.8;L>   replaced "iiir" by "o" (twice).
#   <f88v.P2.9;L>   replaced "iiir" by "o".
#   <f88v.P2.14;L>  replaced "iiir" by "o".
#
#   <f89r1.P1.1;L>  replaced "iiir" by "o".
#   <f89r1.P1.2;L>  replaced "iiir" by "o".
#   <f89r1.P1.3;L>  replaced "iiir" by "o" (twice).
#   <f89r1.P1.4;L>  replaced "iiir" by "o".
#
#   <f89r1.P2.8;L>  replaced "iiir" by "o".
#   <f89r1.P2.9;L>  replaced "iiir" by "o".
#
#   <f89r1.P2.9;F>  replaced ".ssheyr.qokair.ydam.daly=" at end of line by "=".
#   <f89r1.P2.10;F> added "ssheyr.qokair.ydam.daly" at end of line.
#
#   <f89r1.b.4;K>   replaced "iiir" by "o".
#
#   <f89r2.t> unit  renamed <f89r2.L1>.
#
#   <f89r2.t.1;L>   renamed <f89r2.L1.0;L>.
#   <f89r2.t.2;L>   renamed <f89r2.L1.1;L>.
#   <f89r2.t.3;L>   renamed <f89r2.L1.2;L>.
#   <f89r2.t.4;L>   renamed <f89r2.L1.3;L>.
#   <f89r2.t.5;L>   renamed <f89r2.L1.4;L>.
#
#   <f89r2.m1>      unit renamed <f89r2.L2>.
#
#   <f89r2.m1.1;L>  renamed <f89r2.L2.0;L>.
#   <f89r2.m1.2;L>  renamed <f89r2.L2.1;L>.
#   <f89r2.m1.3;L>  renamed <f89r2.L2.2;L>.
#
#   <f89r2.m2>      unit renamed <f89r2.L3>.
#
#   <f89r2.m2.1;L>  renamed <f89r2.L3.0;L>.
#   <f89r2.m2.2;L>  renamed <f89r2.L3.1;L>.
#   <f89r2.m2.3;L>  renamed <f89r2.L3.2;L>.
#   <f89r2.m2.4;L>  renamed <f89r2.L3.3;L>.
#   <f89r2.m2.5;L>  renamed <f89r2.L3.4;L>.
#   <f89r2.m2.6;L>  renamed <f89r2.L3.5;L>.
#
#   <f89r2.b.0;K>   deleted, moved to <f89r2.L3.5;K>.
#
#   <f89r2.b>       unit renamed <f89r2.L4>.
#
#   <f89r2.b.0;L>   renamed <f89r2.L4.0a;L>.
#   <f89r2.b.1;L>   renamed <f89r2.L4.0b;L>.
#   <f89r2.b.2;L>   renamed <f89r2.L4.1;L>.
#   <f89r2.b.3;L>   renamed <f89r2.L4.2;L>.
#   <f89r2.b.4;L>   renamed <f89r2.L4.3;L>.
#   <f89r2.b.5;L>   renamed <f89r2.L4.4;L>.
#
#   <f89r2.P1.2;L>  replaced "iiir" by "o" (twice).
#
#   <f89r2.P2.4;F>  deleted garbled part "oldaq.gtgl ...*egl.gtglf*y.tar".
#   <f89r2.P2.4;F>  inserted guessed fix "oldaiin.otol.sheo*.sho*.olsaiin.ot*ol.*eol.otolf*y.dar" after "qoteol".
#   <f89r2.P2.4;L>  replaced "iiir" by "o".
#   <f89r2.P2.5;L>  replaced "iiir" by "o".
#   <f89r2.P3.10;L> replaced "iiir" by "o".
#   <f89r2.P3.11;L> replaced "iiir" by "o".
#   <f89r2.P3.12;L> replaced "iiir" by "o".
#   <f89r2.P3.14;L> replaced "iiir" by "o".
#
#   <f89v.33A;K>    renamed <f89r2.L1.0;K>.
#   <f89v.33B;K>    renamed <f89r2.L1.1;K>.
#   <f89v.34A;K>    renamed <f89r2.L1.2;K>.
#   <f89v.35A;K>    renamed <f89r2.L1.3;K>.
#   <f89v.36A;K>    renamed <f89r2.L1.4;K>.
#   <f89v.37A;K>    renamed <f89r2.L2.0;K>.
#   <f89v.38A;K>    renamed <f89r2.L2.1;K>.
#   <f89v.38A;Q>    renamed <f89r2.L2.1;Q>.
#   <f89v.39A;K>    renamed <f89r2.L2.2;K>.
#   <f89v.40A;K>    renamed <f89r2.L3.0;K>.
#   <f89v.41A;K>    renamed <f89r2.L3.1;K>.
#   <f89v.42A;K>    renamed <f89r2.L3.2;K>.
#   <f89v.43A;K>    renamed <f89r2.L3.3;K>.
#   <f89v.44A;K>    renamed <f89r2.L3.4;K>.
#   <f89v.45A;K>    renamed <f89r2.L3.5;K> (previously <f89r2.b.0;K>).
#   <f89v.45A;K>    renamed <f89r2.L4.0b;K>.
#   <f89v.46B;K>    renamed <f89r2.L4.1;K>.
#   <f89v.47A;K>    renamed <f89r2.L4.2;K>.
#   <f89v.48A;K>    renamed <f89r2.L4.3;K>.
#   <f89v.49A;K>    renamed <f89r2.L4.4;K>.
#
#   <f89v2.P2.9;F>  deleted "p*y.dairy.sheos."
#   <f89v2.P2.9;F>  deleted "{lost synch}" at end of line.
#   <f89v2.P2.9;F>  inserted ".qokor.okeor.otol.sheey.dal.daiin" from <f89v2.P2.10;F> at end of line.
#   <f89v2.P2.9;L>  deleted bogus text ".odor.sheos ... ltcheody.otal" at end of line.
#   <f89v2.P2.9;L>  inserted "{skipped rest of line}" at end of line.
#   <f89v2.P2.9;L>  replaced "iiir" by "o".
#   <f89v2.P2.10;F> deleted "qokor.okeor ... daiin." at beginning of line, moved to <f89v2.P2.10;F>.
#   <f89v2.P2.10;L> replaced "iiir" by "o".
#   <f89v2.P2.12;L> replaced "iiir" by "o" (twice).
#   <f89v2.P2.13;L> replaced "iiir" by "o".
#   <f89v2.P2.10;F> inserted ".odor.sheos.aiin ... ltcheody.otal" from <f89v2.P2.11;F> at end of line.
#   <f89v2.P2.10;F> deleted "{lost synch}" at end of line.
#   <f89v2.P2.11;F> deleted line, joined to <f89v2.P2.10;F>.
#   <f89v2.P2.11;L> deleted blank line.
#
#   <f89v2.t>       unit renamed <f89v2.L1>.
#
#   <f89v2.t.1;L>   renamed <f89v2.L1.0;L>.
#   <f89v2.t.2;L>   renamed <f89v2.L1.1;L>.
#   <f89v2.t.3;L>   renamed <f89v2.L1.2;L>.
#   <f89v2.t.4;L>   renamed <f89v2.L1.3;L>.
#   <f89v2.t.5;L>   renamed <f89v2.L1.4;L>.
#   <f89v2.t.6;L>   renamed <f89v2.L1.5;L>.
#
#   <f89v2.m>       unit renamed <f89v2.L2>.
#
#   <f89v2.m.1;L>   renamed <f89v2.L2.0;L>.
#   <f89v2.m.2;L>   renamed <f89v2.L2.1;L>.
#   <f89v2.m.3;L>   renamed <f89v2.L2.2;L>.
#   <f89v2.m.4;L>   renamed <f89v2.L2.3;L>.
#
#   <f89v2.b>       unit renamed <f89v2.L3>.
#
#   <f89v2.b.1;L>   renamed <f89v2.L3.0;L>.
#   <f89v2.b.2;L>   renamed <f89v2.L3.1;L>.
#   <f89v2.b.3;L>   renamed <f89v2.L3.2;L>.
#   <f89v2.b.4;L>   renamed <f89v2.L3.3;L>.
#   <f89v2.b.5;L>   renamed <f89v2.L3.4;L>.
#
#   <f89v2.X>       (Grove's) unit deleted, merged into <f89r2.L1> thru <f89r2.L4>
#   <f89v2.Y>       (Grove's) unit deleted, no contents.
#
#   <f89v1.P1.7;F>  truncated from "" onwards.
#   <f89v1.P1.7a;F> created from right half of <f89v1.P1.7;F>.
#   <f89v1.P1.7;L>  truncated from "" onwards.
#   <f89v1.P1.7a;L> created from right half of <f89v1.P1.7;L>.
#   <f89v1.P1.7;L>  replaced "iiir" by "o".
#
#   <f89v1.b.2;L>   deleted bogus "-siiir" at end of line.
#   <f89v1.b.3;L>   deleted bogus "-siiir" at end of line.
#   <f89v1.b.4;L>   deleted, bogus copy of <f89v1.t.4;L>.
#   <f89v1.b.4;V>   deleted, bogus copy of <f89v1.t.4;V>.
#
#   <f90r2.P.4;L>   replaced "iiir" by "o".
#   <f90r2.P.5;L>   truncated from "daiin.qokor." onwards.
#   <f90r2.P.5a;L>  created from right half of <f90r2.P.5;L>.
#   <f90r2.P.5;F>   truncated from "daiin.qokor." onwards.
#   <f90r2.P.5a;F>  created from right half of <f90r2.P.5;F>.
#
#   <f90v1.P.5;L>   replaced "iiir" by "o".
#
#   <f93r.P.4;C>    deelted "-chodain" at end of line.
#   <f93r.P.5;C>    replaced "iiir" by "o".
#
#   <f95v2.P.2;F>   truncated from "ekaiin.okar.or." onwards.
#   <f95v2.P.2a;F>  created from right half of <f95v2.P.2;F>.
#
#   <f99v.P3.11;F>  truncated from "ol.olal.okeol" onwards.
#   <f99v.P.12;F>   leading "." deleted.
#   <f99v.P3.14;F>  deleted "ychol.olkeeoldy-" at end of line.
#   <f99v.P3.14a;F> created from "ychol.olkeeoldy" of line <f99v.P3.14;F>.
#
#   <f100v.T.1;C>   deleted, mislabeled copy of <f100v2.R1.5;C>.
#   <f100v.T.1;K>   added, was <f100v.31A;K>.
#   <f100v.T.1;V>   added, was <f100v.B.1;V>.
#   <f100v.T.2;C>   deleted, mislabeled copy of <f100v2.R1.7;C>.
#   <f100v.T.2;K>   added, was <f100v.32A;K>.
#   <f100v.T.2;V>   added, was <f100v.B.2;V>.
#   <f100v.T.3;C>   deleted, moved to <f101v2.R1.8;D>.
#   <f100v.T.3;K>   added, was <f100v.33A;K>.
#   <f100v.T.3;V>   added, was <f100v.B.3;V>.
#   <f100v.T.4;C>   deleted, moved to <f101v2.R1.9;D>.
#   <f100v.T.4;K>   added, was <f100v.34A;K>.
#   <f100v.T.4;V>   added, was <f100v.B.4;V>.
#
#   <f100v.M.1;C>   deleted, moved to <f101v2.R2.5;D>.
#   <f100v.M.1;K>   added, was <f100v.35A;K>.
#   <f100v.M.1;V>   added, was <f100v.B.5;V>.
#   <f100v.M.2;C>   deleted, mislabeled copy of <f101v2.R2.6;C>.
#   <f100v.M.2;K>   added, was <f100v.36A;K>.
#   <f100v.M.2;V>   added, was <f100v.B.6;V>.
#   <f100v.M.3;C>   deleted, moved to <f101v2.R2.7;D>.
#   <f100v.M.3;K>   added, was <f100v.37A;K>.
#   <f100v.M.3;V>   added, was <f100v.B.7;V>.
#   <f100v.M.4;C>   deleted, mislabeled copy of <f101v2.R2.9;C>.
#   <f100v.M.4;K>   added, was <f100v.38A;K>.
#   <f100v.M.4;V>   added, was <f100v.B.8;V>.
#   <f100v.M.5;C>   deleted, moved to <f101v2.R2.9;D>.
#   <f100v.M.5;K>   added, was <f100v.39A;K>.
#   <f100v.M.5;V>   added, was <f100v.B.9;V>.
#
#   <f100v.B.1;K>   added, was <f100v.40A;K>.
#   <f100v.B.1;V>   deleted, moved to <f100v.T.1;V>.
#   <f100v.B.1;V>   added, was <f100v.B.10;V>.
#   <f100v.B.2;K>   added, was <f100v.41A;K>.
#   <f100v.B.2;V>   deleted, moved to <f100v.T.2;V>.
#   <f100v.B.2;V>   added, was <f100v.B.11;V>.
#   <f100v.B.3;K>   added, was <f100v.42A;K>.
#   <f100v.B.3;V>   deleted, moved to <f100v.T.3;V>.
#   <f100v.B.3;V>   added, was <f100v.B.12;V>.
#   <f100v.B.4;K>   added, was <f100v.43A;K>.
#   <f100v.B.4;V>   deleted, moved to <f100v.T.4;V>.
#   <f100v.B.4;V>   added, was <f100v.B.13;V>.
#   <f100v.B.5;V>   deleted, moved to <f100v.M.1;V>.
#   <f100v.B.6;V>   deleted, moved to <f100v.M.2;V>.
#   <f100v.B.7;V>   deleted, moved to <f100v.M.3;V>.
#   <f100v.B.8;V>   deleted, moved to <f100v.M.4;V>.
#   <f100v.B.9;V>   deleted, moved to <f100v.M.5;V>.
#   <f100v.B.10;V>  deleted, moved to <f100v.B.1;V>.
#   <f100v.B.11;V>  deleted, moved to <f100v.B.2;V>.
#   <f100v.B.12;V>  deleted, moved to <f100v.B.3;V>.
#   <f100v.B.13;V>  deleted, moved to <f100v.B.4;V>.
#
#   <f100v.31A;K>   deleted, moved to <f100v.T.1;K>.
#   <f100v.32A;K>   deleted, moved to <f100v.T.2;K>.
#   <f100v.33A;K>   deleted, moved to <f100v.T.3;K>.
#   <f100v.34A;K>   deleted, moved to <f100v.T.4;K>.
#   <f100v.35A;K>   deleted, moved to <f100v.M.1;K>.
#   <f100v.36A;K>   deleted, moved to <f100v.M.2;K>.
#   <f100v.37A;K>   deleted, moved to <f100v.M.3;K>.
#   <f100v.38A;K>   deleted, moved to <f100v.M.4;K>.
#   <f100v.39A;K>   deleted, moved to <f100v.M.5;K>.
#   <f100v.40A;K>   deleted, moved to <f100v.B.1;K>.
#   <f100v.41A;K>   deleted, moved to <f100v.B.2;K>.
#   <f100v.42A;K>   deleted, moved to <f100v.B.3;K>.
#   <f100v.43A;K>   deleted, moved to <f100v.B.4;K>.
#
#   <f101v2.R1.8;D> added, was <f100v.T.3;C>.
#   <f101v2.R1.9;D> added, was <f100v.T.4;C>.
#
#   <f101v2.R2.5;D> added, was <f100v.M.1;C>.
#   <f101v2.R2.7;D> added, was <f100v.M.3;C>.
#   <f101v2.R2.9;D> added, was <f100v.M.5;C>.
#
#   <f101v2.P.1;F>  deleted "ol-" at end of line.
#   <f101v2.P.1;F>  added "{skipped}.orar...odaiiny-" at end of line, from <f101v1.P.1;F>.
#   <f101v2.P.1a;F> created missing line with "{skipped}******".
#   <f101v2.P.1a;F> added "ol...okody.dar" at end of line, from <f101v1.P.2;F>.
#   <f101v2.P.2;F>  added "cthy.daiin.ch*do.dydy" at end of line, from <f101v1.P.3;F>.
#   <f101v2.P.3;F>  added "eol.....sodaiin.dy" at end of line, from <f101v1.P.4;F>.
#   <f101v2.P.4;F>  added ".qokeol.....dy.dar" at end of line, from <f101v1.P.5;F>.
#   <f101v2.P.5;F>  deleted "da*" at end of line.
#   <f101v2.P.5;F>  added "daiin.cheeody.....cheedy" at end of line, from <f101v1.P.6;F>.
#   <f101v2.P.6;F>  added ".okeey.ckheo.....olchor" at end of line, from <f101v1.P.7;F>.
#   <f101v2.P.7;F>  added ".cheey.tey.....ary" at end of line, from <f101v1.P.8;F>.
#   <f101v2.P.8;F>  deleted "sh*" at end of line.
#   <f101v2.P.8;F>  added "cheeeo.***.{skipped}.cheol...cheodam" at end of line, from <f101v1.P.9;F>.
#
#   <f101v2.T.9;F> deleted "o" at end of line.
#   <f101v2.T.9;F> added "*qor.cheol....qkar" at end of line, from <f101v1.T.10;F>.
#
#   <f101v1.P.1;F> deleted line (joined to <f101v2.P.1;F>).
#   <f101v1.P.2;F> deleted line (joined to <f101v2.P.1a;F>).
#   <f101v1.P.3;F> deleted line (joined to <f101v2.P.2;F>).
#   <f101v1.P.4;F> deleted line (joined to <f101v2.P.3;F>).
#   <f101v1.P.5;F> deleted line (joined to <f101v2.P.4;F>).
#   <f101v1.P.6;F> deleted line (joined to <f101v2.P.5;F>).
#   <f101v1.P.7;F> deleted line (joined to <f101v2.P.6;F>).
#   <f101v1.P.8;F> deleted line (joined to <f101v2.P.7;F>).
#   <f101v1.P.9;F> deleted line (joined to <f101v2.P.8;F>).
#
#   <f101v1.T.10;F> deleted line (joined to <f101v2.T.9;F>).
#
#   <f102v1.P1.6;F> deleted ".toiin.ol.daiin-" at end of line.
#   <f102v1.P1.6;F> added "=" at end of line.
#   <f102v1.P1.7;F> added "toiin.ol.daiin." at beginning of line.
#
#   <f103r.P.1;J>   leading ".", deleted.
#   <f103r.P.2;J>   leading ".", deleted.
#   <f103r.P.2;I>   leading ".", deleted.
#   <f103r.P.3;J>   leading ".", deleted.
#
#   <f103v.P.1;J>   added ".olpchey.qoky.dy.qokeey.qokeey.daiin.okeedaky.qotear.shedy.dal" at end of line.
#   <f103v.P.4;J>   added "lkees.ol.qoteedy.okeedy" at end of line.
#   <f103v.P.5;J>   added "qokshdy.qokaiin.okechdy.qopchdy.qotedy.qokaiin.oly" at end of line.
#   <f103v.P.6;J>   added "cheol.qoeeor.lshor.qoky.shedy.qokaiin.chedy.qoka" at end of line.

#   <f104r.P.4;F>   leading ".", deleted.
#   <f104r.P.7;J>   added "dchodees.sheor.odaiin.otchedy.qodaiin.shedy.chedy.qodaiin.okar" at beginning of line.
#   <f104r.P.8;J>   added "olsheedy.lkeedy.lkeody.qokaiin.chedal.qokar.odar.qokal" at beginning of line.
#
#   <f104r.P.44;F>  replaced ".l.saiin.otaiin....otaiin.otaiin=" by "-" at end of line.
#   <f104r.P.45;F>  created with ".l.saiin.otaiin.ar.chedy.qokaiin.otaiin.otaiin=" from line <f104r.P.44;F>.
#
#   <f105r.P.16;F>  leading ".", deleted.
#
#   <f105v.P.15;F>  added ".r" at end of line.
#   <f105v.P.16;F>  deleted "r." at beginning of line.
#
#   <f106r.P.30;T>  deleted (empty) line.
#   <f106r.P.30;F>  deleted line "saiin.chal.chlal.akal.ykalaiin.okaiin.qokaiin.ar.okaiin.char.aiiny-".
#
#   <f107r.P.33;T>  duplicate ".", replaced by single ".".
#
#   <f107r.P.8;F>   replaced "iiir" by "o".
#   <f107r.P.24;F>  replaced "iiir" by "o".
#   <f107r.P.27;F>  replaced "iiir" by "o".
#   <f107r.P.33;F>  replaced "iiir" by "o" (twice).
#   <f107v.P.32;F>  replaced "iiir" by "o".
#   <f107v.P.46;F>  replaced "iiir" by "o".
#
#   <f108v.P.17;F>  replaced "iiir" by "o".
#   <f108v.T.52;F>  replaced "iiirfin" by ".ol".
#
#   <f111r.P.1;F>   replaced "iiir by "ii".
#   <f111r.P.16;F>  replaced "iiir" by "**".
#   <f111r.P.18;F>  replaced "iiiriiir" by "**".
#   <f111r.P.20;F>  replaced "iiir" by "im".
#   <f111r.P.21;F>  replaced "liiir" by "**".
#   <f111r.P.24;F>  replaced "iiiriiir" by "im".
#   <f111r.P.25;F>  replaced "iiir" by "o".
#   <f111r.P.29;F>  replaced "iiiriiir" by "chr".
#   <f111r.P.50;F>  replaced "iiir" by "*".
#
#   <f112v.P.42;F>  added ".otaray.shaiin.qokedy" at end of line.
#   <f112v.P.42;G>  added ".otaray.shain.qokedy" at end of line.
#   <f112v.P.43;F>  deleted "otaray.shaiin.qokedy." from beginning of line.
#   <f112v.P.43;F>  added ".am" at end of line.
#   <f112v.P.43;G>  deleted "otaray.shain.qokedy." from beginning of line.
#   <f112v.P.43;G>  added ".am" at end of line.
#   <f112v.P.44;F>  deleted "am." at beginning of line.
#   <f112v.P.44;G>  deleted ".am." at beginning of line.
#   <f112v.P.45;F>  deleted ".*ltar.aim" at end of line.
#   <f112v.P.45;G>  deleted ".e.otar.aim" at end of line.
#   <f112v.P.46;T>  renumbered <f112v.P.44a;T>
#   <f112v.P.46;F>  renumbered <f112v.P.44a;F>
#   <f112v.P.46;G>  renumbered <f112v.P.44a;G>
#   <f112v.P.47;F>  added "*ltar.aim." at beginning of line.
#   <f112v.P.47;G>  added "e.otar.aim." at beginning of line.
#
#   <f114v.P.38;F>  deleted ".qoleechedy" at end of line.
#   <f114v.P.39;F>  added "qoleechedy." at beginning of line.
#
#   <f115r.P.36;F>  replaced "sorols.cheos....pchar-" by "=".
#   <f115r.P.36a;F> created from right half of <f115r.P.36;F>.
#
#   <f116r.P.43;F>  deleted ".saykeedy.....chey.qol.okam" at end of line.
#   <f116r.P.43a;F> created with "saykeedy.....chey.qol.okam-" from <f116r.P.43;F>.
#
#   <f116r.P.28;F>  bogus FSG "Z", replaced by "*".
#
# --- end comments by J. Stolfi ----------------------------
