# The "michiton" paragraph
# Last edited on 1998-11-25 03:38:33 by stolfi
#
# "U" transcription by J.Stolfi from a scanned image.
# Only the first two words of line 3 look like Voynichese.
#
# Transcription uses the "best matches" from Rene's German alphabet (RGA),
# with the following additions/deviations:
#
#   8    similar to RGA "d" (mainline variant), but the upper loop is smaller
#          than the lower loop, and almost straight above it.
#   h    very much like RGA "h", but with open bottom
#   j    a partially obscured glyph; what can be seen looks
#          like a printed lowercase "j", lower on 
#          the baseline and slanting to the left.
#   L    Similar to RGA "l" but more angular---a thin and tall triangle,
#          closed at the bottom and not connected to the neighbors.
#   M    like a large Greek "epsilon" or a "3" on its side, with 
#          first stroke turned inwards, the last slightly outwards.
#   m    with inclined strokes, like "\/\/\".
#   n    with inclined strokes, like "\/\".
#       like an "o" with a circumflex *under* it; or an EVA "l"
#          with very short "legs".
#   )    like a small close parenthesis, extending slightly below
#          the baseline; very much like the variant RGA "o" 
#          (bottom line of Rene's scan)
#   p    has an exaggerated "barb" on the left side of the 
#          stem.
#   r    like a Greek lowercase "nu".
#       an "u" or "n" with a macron or overline (which may be noise).
#   X    Like RGA "x", but with the two strokes ligated on the right.
#   y    similar to RGA "y", but more like a Greek "eta".
#   +    like a math "+", raised so as to stand on the baseline.
#   ^    partially obscured; the bottom part has two "feet"
#            on the baseline, very close together.
#
# In the "digits" line, "a" trough "d" mean "10" through "13", 
# each numeral being squeezed into single letter slot.
#
<f116v.P.1;U>      **e**eo*.o*a*a*ad.*.****ld.*.ch.*.ch*.ch**,*.*o*ead.****-
# Line 1 Roman:    nuchiton.ola6ba8.+.mLc8.+.te.+,tar.terc,+.porta8.+M++-
# Line 1.5 Digits: .1234567.489a9bc*.*4**854d*.!**..,***.5545-
#
<f116v.P.2;U>      *******aii***o****,ii**a**a**a***a*-
# Line 2 Roman:    siX+*jariX+moriX+,viX+abta+ma+ria+-
# The "+" in "ma+ria" is raised and takes no space between the "a" and "r".
#
<f116v.P.3;U>      oror.sheey.***dc*!*****-{gap}!o.***.*a*.**c*.o=
# Line 3 Roman:    ****.*****.val8e^,vbreY-{gap}so.nim.gas.mich.o=
# The "8" is small and tilted to the right; it may be an EVA "d"
#   or a Roman "a" with some noise.
# The final "o" may be a spot, or a vellum defect.
