#! /bin/bash
# Last edited on 2012-06-23 01:12:00 by stolfilocal


source define-points.sh

tmp="/tmp/$$"

convert \
  -background 'rgba(0,0,0,0)' \
  aster-2012-04-barao-geraldo-dim.png +repage \
  -resize '343.000%' \
  -rotate 0.8 \
  -crop '2049x1683+53+67' \
  ${tmp}-a.png  

annotate-pic.sh \
    unicamp-12-transp.png \
    24 Black Yellow \
    \
    -color Yellow -strokewidth 6 \
    -S  ${UN[@]} \
    \
    -color YellowGreen -strokewidth 2 \
    -S   ${CD[@]} \
    \
    -color Salmon -strokewidth 6 \
    -S  ${FZ[@]} \
    \
    -color Yellow -strokewidth 3 \
    -L  556  366    500   40  FACAMP \
    -L  690  178    650   40  LNLS \
    -L  879  440   1050   40  CPQD \
    -L  435 1254    300 1289  SH.DP \
    -L  813  904   1282 1050  PUC \
    -L  579  426    457  424  OBS \
    -L  514  537    344  574  FEAGRI \
    -L  519  682    245  673  PQ.ECO \
    -color Sienna2 -strokewidth 3 \
    -L 1190  585   1192  585  ALPHAV \
    -L   70  818     72  818  B.GER \
  > ${tmp}-b.png
  
convert \
  \( ${tmp}-a.png +repage \) \
  \( ${tmp}-b.png +repage -repage '+0302+0326' \) \
  -layers flatten \
  unicamp-12-aster.png
  
rm -f ${tmp}-a.png ${tmp}-b.png

# Linha de alta tensão
#     \
#     -color DeepSkyBlue -strokewidth 4 \
#     -D  ${AT[@]} \
