#! /usr/bin/gawk -f
# Last edited on 2012-06-22 14:34:51 by stolfilocal

BEGIN {

  # Generates "S" commands to completely hatch an image.
  
  nx = 1322;   # Image width
  ny = 1309;   # Image height
  sign = +1;   # Defines slant of hatches.
  step = 6;    # Spacing in position (must be even).
  phase = 4;   # In {0..step-1}.
  M = step*1000000; # A large multiple of {step}.
  
  assert((step % 2) == 0, "bad step", step);
  assert((0 <= phase) && (phase < step), "bad phase", phase);
  
  d = step/2;
  for (p = phase; p < nx + ny; p += step)
    { amin = get_amin(p,sign,nx,ny);
      amax = get_amax(p,sign,nx,ny);
      if (amin <= amax)
        { x0 = get_x(p,amin-2,sign); y0 = get_y(p,amin-2,sign); 
          x1 = get_x(p,amax+2,sign); y1 = get_y(p,amax+2,sign); 
          printf "    -S %4d %4d  %4d %4d \n", x0, y0, x1, y1;
        }
    }
}

function position(x,y,sign)
{ 
  # Position of hatch line:
  return x + sign*y;
}

function argum(x,y,sign)
{ 
  # Place along a hatch line:
  return x - sign*y;
}

function get_amin(p,sign,nx,ny,  a0,a1)
{ 
  a0 = - p;
  a1 = p - (sign > 0 ? 2*ny : 0) 
  return (a0 > a1 ? a0 : a1);
}

function get_amax(p,sign,nx,ny,  a0,a1)
{ 
  a0 = - p + 2*nx;
  a1 = p + (sign > 0 ? 0 : 2*ny) 
  return (a0 < a1 ? a0 : a1);
}
    
function get_x(p,a,sign)
{ 
  # Return X given position and argum
  assert(((p+a) % 2) == 0, "parity error", (p " " a));
  assert((p % step) == phase, "phase error", p);
  return (p+a)/2;
}
    
function get_y(p,a,sign)
{ 
  # Return Y given position and argum
  assert(((p+a) % 2) == 0, "parity error", (p " " a));
  assert((p % step) == phase, "phase error", p);
  return sign*(p-a)/2;
}
    
function assert(c,msg,arg)
{ 
  if (! c) 
    { printf "** assert failed: %s (%s)\n", msg, arg > "/dev/stderr"; 
      exit(1);
    }
}
