#!/bin/bash
# Last edited on 2012-06-23 00:45:01 by stolfilocal

bgc="$1"; shift # Background color, "black" or "white"
txc="$1"; shift # Text color, "white" or "black"

tmp="/tmp/$$"

convert \
  unicamp-12-legbg-${bgc}.png \
  \( unicamp-12-legpatch-wat.png +repage -repage '+0020+0150' \) \
  \( unicamp-12-legpatch-apa.png +repage -repage '+0020+0200' \) \
  \( unicamp-12-legpatch-frm.png +repage -repage '+0020+0250' \) \
  \( unicamp-12-legpatch-urb.png +repage -repage '+0020+0300' \) \
  \( unicamp-12-legpatch-can.png +repage -repage '+0620+1100' \) \
  \( unicamp-12-legpatch-emp.png +repage -repage '+0620+0050' \) \
  -layers flatten \
  ${tmp}.png

annotate-pic.sh \
    ${tmp}.png \
    20 White Yellow \
    -color Yellow -strokewidth 4  -Q   20   50   67   50   67   85   20   85  \
    -textcolor ${txc} -T  80   68 0.0 0.5  'UNICAMP' \
    \
    -color Salmon -strokewidth 4  -Q   20  100   67  100   67  135   20  135  \
    -textcolor ${txc} -T  80  118 0.0 0.5  'FAZENDA ARGENTINA' \
    \
    -color White -strokewidth 1   -Q   20  150   67  150   67  185   20  185  \
    -textcolor ${txc} -T  80  168 0.0 0.5  'RIOS E LAGOS' \
    \
    -color White -strokewidth 1   -Q   20  200   67  200   67  235   20  235  \
    -textcolor ${txc} -T  80  218 0.0 0.5  'PROTECAO AMBIENTAL (EST.)' \
    \
    -color White -strokewidth 1   -Q   20  250   67  250   67  285   20  285  \
    -textcolor ${txc} -T  80  268 0.0 0.5   'FAZENDA / MATO / VAGO' \
    \
    -color White -strokewidth 1   -Q   20  300   67  300   67  335   20  335  \
    -textcolor ${txc} -T  80  318 0.0 0.5  'AREAS URBANIZADAS' \
    \
    -color Tan \
    -textcolor Black -L   44  370    46  370 BG  -textcolor ${txc} -T   80  370 0.0 0.5  'BARAO GERALDO' \
    -textcolor Black -L   44  410    46  410 U1  -textcolor ${txc} -T   80  410 0.0 0.5  'CIDADE UNIVERSITARIA 1' \
    -textcolor Black -L   44  450    46  450 U2  -textcolor ${txc} -T   80  450 0.0 0.5  'CIDADE UNIVERSITARIA 2' \
    -textcolor Black -L   44  490    46  490 BC  -textcolor ${txc} -T   80  490 0.0 0.5  'BARAO DO CAFE' \
    -textcolor Black -L   44  530    46  530 JM  -textcolor ${txc} -T   80  530 0.0 0.5  'JARDIM MYRIAM' \
    -textcolor Black -L   44  570    46  570 AV  -textcolor ${txc} -T   80  570 0.0 0.5  'ALPHAVILLE' \
    -textcolor Black -L   44  610    46  610 PI  -textcolor ${txc} -T   80  610 0.0 0.5  'PARQUE IMPERIAL' \
    -textcolor Black -L   44  650    46  650 JN  -textcolor ${txc} -T   80  650 0.0 0.5  'JARDIM NILOPOLIS' \
    -textcolor Black -L   44  690    46  690 FC  -textcolor ${txc} -T   80  690 0.0 0.5  'FAZENDA SANTA CANDIDA' \
    -textcolor Black -L   44  730    46  730 PJ  -textcolor ${txc} -T   80  730 0.0 0.5  'PARQUE DOS JEQUITIBAS' \
    -textcolor Black -L   44  770    46  770 PU  -textcolor ${txc} -T   80  770 0.0 0.5  'PARQUE DAS UNIVERSIDADES' \
    -textcolor Black -L   44  810    46  810 SG  -textcolor ${txc} -T   80  810 0.0 0.5  'JARDIM SANTA GENEBRA' \
    \
    -color LightGray -strokewidth 6 \
    -S    20  968   40  962   50  974   60  968 \
    -color LightGray -strokewidth 3 \
    -S    40  962   50  950 \
    -textcolor ${txc} -T  80  968 0.0 0.5   'VIAS PRINCIPAIS EXISTENTES' \
    \
    -color Orange -strokewidth 6 \
    -S    20 1018   40 1012   50 1024   60 1018 \
    -color Orange -strokewidth 3 \
    -S    40 1012   50 1000 \
    -textcolor ${txc} -T  80 1018 0.0 0.5   'VIAS A ALARGAR / DUPLICAR' \
    \
    -color Red -strokewidth 6 \
    -S    20 1068   40 1062   50 1074   60 1068 \
    -color Red -strokewidth 3 \
    -S    40 1062   50 1050 \
    -textcolor ${txc} -T  80 1068 0.0 0.5   'VIAS PROPOSTAS' \
    \
    -color Orange \
    -textcolor Black -L   48 1120    50 1120 1  -textcolor ${txc} -T   80 1120 0.0 0.5  'DUPL. G. SCOLFARO / G. NAPOLLI' \
    -color Red \
    -textcolor Black -L   48 1160    50 1160 2  -textcolor ${txc} -T   80 1160 0.0 0.5  'EXTENSAO DA GUILHERME DE CAMPOS' \
    -textcolor Black -L   48 1200    50 1200 3  -textcolor ${txc} -T   80 1200 0.0 0.5  'ANTIGA VIA UNICAMP-CPQD' \
    -textcolor Black -L   48 1240    50 1240 4  -textcolor ${txc} -T   80 1240 0.0 0.5  'ACESSO ALTERN. PARA UNICAMP / FACAMP' \
    \
    \
    -color White -strokewidth 1   -Q  620   50  667   50  667  85  620   85  \
    -textcolor ${txc} -T 680   68 0.0 0.5  'ENTIDADES / PREDIOS' \
    \
    -color Yellow \
    -textcolor Black -L  648  120   650  120 U  -textcolor ${txc} -T  680  120 0.0 0.5  'FUNCAMP' \
    -textcolor Black -L  648  160   650  160 E  -textcolor ${txc} -T  680  160 0.0 0.5  'INSTITUTO ELDORADO' \
    -textcolor Black -L  648  200   650  200 N  -textcolor ${txc} -T  680  200 0.0 0.5  'INSTITUTO INGO HOFFMANN' \
    -textcolor Black -L  648  240   650  240 R  -textcolor ${txc} -T  680  240 0.0 0.5  'RADIOTERAPIA BOLDRINI' \
    -textcolor Black -L  648  280   650  280 F  -textcolor ${txc} -T  680  280 0.0 0.5  'FACAMP' \
    -textcolor Black -L  648  320   650  320 S  -textcolor ${txc} -T  680  320 0.0 0.5  'DATACENTRO DO SANTANDER' \
    -textcolor Black -L  648  360   650  360 K  -textcolor ${txc} -T  680  360 0.0 0.5  'LAB. DE LUZ SINCROTRON' \
    -textcolor Black -L  648  400   650  400 B  -textcolor ${txc} -T  680  400 0.0 0.5  'BENCHMARK ELECTRONICS (?)' \
    -textcolor Black -L  648  440   650  440 H  -textcolor ${txc} -T  680  440 0.0 0.5  'TRB PHARMA (?)' \
    -textcolor Black -L  648  480   650  480 W  -textcolor ${txc} -T  680  480 0.0 0.5  'SUB-ESTACAO DE ENERGIA' \
    -textcolor Black -L  648  520   650  520 G  -textcolor ${txc} -T  680  520 0.0 0.5  'COND. EMPR. GLOBALTECH (EX PROMON)' \
    -textcolor Black -L  648  560   650  560 T  -textcolor ${txc} -T  680  560 0.0 0.5  'CLUBE TELECAMP' \
    -textcolor Black -L  648  600   650  600 C  -textcolor ${txc} -T  680  600 0.0 0.5  'CPQD (MATERA, CI&T)' \
    -textcolor Black -L  648  640   650  640 X  -textcolor ${txc} -T  680  640 0.0 0.5  'XTAL FIBRAS OTICAS' \
    -textcolor Black -L  648  680   650  680 P  -textcolor ${txc} -T  680  680 0.0 0.5  'PUCC' \
    -textcolor Black -L  648  720   650  720 Y  -textcolor ${txc} -T  680  720 0.0 0.5  'SHOPPING DOM PEDRO' \
    -textcolor Black -L  648  760   650  760 A  -textcolor ${txc} -T  680  760 0.0 0.5  'SOBRAPAR' \
    -textcolor Black -L  648  800   650  800 Z  -textcolor ${txc} -T  680  800 0.0 0.5  'SUB-ESTACAO DE ENERGIA' \
    -textcolor Black -L  648  840   650  840 O  -textcolor ${txc} -T  680  840 0.0 0.5  'OBSERVATORIO / MUSEU DE CIENCIAS' \
    -textcolor Black -L  648  880   650  880 I  -textcolor ${txc} -T  680  880 0.0 0.5  'INSTITUTO DE COMPUTACAO' \
    -textcolor Black -L  648  920   650  920 M  -textcolor ${txc} -T  680  920 0.0 0.5  'FAC. ENG. AGRICOLA' \
    \
    -color LightGray -strokewidth 4 \
    -S   620 1018  668 1018 \
    -color Magenta -strokewidth 4 \
    -D   644 1018 \
    -textcolor ${txc} -T 680 1018 0.0 0.5   'GUARITAS' \
    \
    -color DeepSkyBlue -strokewidth 3 \
    -D   620 1068  640 1062  650 1074  660 1068 \
    -textcolor ${txc} -T 680 1068 0.0 0.5   'LINHA DE ALTA TENSAO' \
    \
    -textcolor ${txc} -T 680 1118 0.0 0.5   'CÓRREGO CANALIZADO' \
    \
  > unicamp-12-legend-${bgc}.png
  
rm -f ${tmp}.png  

# Reposiciona legendas:
#  gawk 'BEGIN{x=20;y=350;dx=26;dy=40;} /^ *-textco/{ C=$2; L=$8; D=$10; NU=15; yc=y+int(dy/2); printf "    -textcolor %s -L %4d %4d  %4d %4d %s  -textcolor %s -T %4d %4d 0.0 0.5 ", C, x+dx-2, yc, x+dx, yc, L, D, x+60, yc; for (i=NU+1; i<= NF; i++) { printf " %s", $(i);} printf "\n"; y=y+dy; next;} //{print}'
# Para prédios: "x=620;y=100;dx=30;dy=40;"
# Para bairros "x=20;y=350;dx=26;dy=40;"
# Para ruas futuras "x=620;y=1100;dx=30;dy=40;"
 
# Quadriculados - áreas urbanizadas residenciais ou industriais:
# 
#     BG - Barão Geraldo
#     U1 - Cidade Universitária 1
#     U2 - Cidade Universitária 2
#     BC - Barão do Café
#     JM - jardim Myriam M. C. Costa
#     AV - Alphaville
#     PI - Parque Imperial
#     JN - Jardim Nilópolis
#     FC - Fazenda Santa Cândida
#     PJ - Parque dos Jequitibás
#     PU - Parque das Universidades
#     SG - Jardim Santa Genebra
# 
# Contorno amarelo - UNICAMP atual
# Contorno rosa - Faz. Argentina
# Ciano - rios e lagoas
# Verde escuro (exceto UNICAMP) - terrenos vagos / floresta / lavoura
# Outras cores sólidas - imóveis/prédios relevantes,
#   em ordem antihorária:
# 
#     (I) - Prédios do IC
#     (O) - Observatório (Museu de Ciências) da UNICAMP
# 
#     (U) - FUNCAMP
#     (E) - Instituto Eldorado
#     (N) - Instituto Ingo Hoffmann
#     (R) - Centro de Radioterapia do Boldrini
#     (F) - FACAMP
#     (S) - Datacentro do Santander
#     (K) - Laboratório de Luz Síncrotron
#     (B) - Benchmark Electronics (?)
#     (H) - TRB Pharma (?)
#     (W) - Sub-estação de energia
#     (G) - Condomínio empresarial Globaltech (ex Promon)
#     (T) - Clube Telecamp
#     (C) - CPqD (Matera, CI&T)
#     (X) - XTAL Fibras Óticas
#     (P) - PUCC
#     (Y) - Shopping Dom Pedro
#     (A) - SOBRAPAR
#     (Z) - Sub-estação de energia
# 
# Linhas cinza claro - principais vias de acesso existentes
# Linha azul com bolinhas - linha de alta tensão
# Hachurado verde claro - APAs (estimadas)
# Bolinhas laranja - guaritas existentes
# Linhas laranja e vermelhas - possíveis estradas futuras
# 
#     (1) Estrada a ser duplicada pelas empresas do Polo
#     (2) Extensão da Av. G. Campos (trajeto chutado)
#     (3) Antiga via UNICAMP-CPqD
#     (4) Possivel acesso UNICAMP+FACAMP
# 
