## <f0.I> {}
# Last edited on 1998-12-05 11:19:09 by stolfi
#
# FILE INTERLN.EVT VERSION 1.6
# Original description by by Gabriel Landini, 27 Sep 1996.
#
# [ Amendments/additions by J. Stolfi in "[]" ]
# 
# This file [ INTERLN.EVT ] is an interlinear version of the Voynich
# manuscript transcriptions from:
#
# a) P. Currier + new additions by the VMS list members (Jim Gillogly,
#    Jim Reeds, Mike Roe 1990-1994)
# b) the First Study Group (W. Friedman 1945-1949)
# c) other pages transcriptions (Don Latham 1996, Mike Roe 1996,
#    John H. Tiltman 1951, Karl Kluge 1992, Jim Reeds 1996)
#
# Please report any problems to: G.Landini@bham.ac.uk or to the Voynich
# list: Voynich@rand.org
#
# To join the Voynich list, send e-mail to Voynich-request@rand.org
#
# I will be responsible for keeping this file corrected and updated,
# so if you find any corrections, please contact me so they can be
# included in the next version of this file. All credits and thanks to
# the members of the Voynich list who made the original transcriptions
# available on line.
#
# This file was produced for the EVMT project (European Voynich
# Manuscript Transcription) by G. Landini and R. Zandbergen. We intend
# to transcribe the whole manuscript from T. C. Petersen's hand
# transcription of a set of photostats (1931) and from previous
# transcriptions available in machine readable format. The
# transcription will use the EVA alphabet that will allow translation
# of the document into the three most common alphabets associated with
# the manuscript: FSG alphabet, Currier's alphabet and Frogguy (by
# Jacques Guy).
#
# INTERLN17.EVT is based on the files: voynich.now, FSG.NEW and
# tiltman.txt with some small corrections. The Currier version was
# originally coded in Currier's alphabet. I translated it to FSG
# "enhanced" alphabet using Jacques Guy's BITRANS program and a set of
# rules CUR2FSG2 based on a message by Jim Reeds to the Voynich
# mailing list.
#
# The FSG alphabet does not contain the Currier characters 6 and 7. To
# preserve these, characters 6 and 7 were kept unchanged in the resulting
# FSG version. Currier 6 usually corresponds to K in FSG, while 7 was
# transcribed as K or 8 by the FSG team.
#
# I added a few "end of line" - and "end of paragraph" = marks where missing
# to keep line lengths equal between versions.
# All double spaces ",," were replaced with single spaces.
#
# Format of this file:
# -------------------
# 
# [ The file is divided into logical "pages", which are subdivided into 
# "units", so that each unit contains only one type of text (paragraphs,
# labels, circular lines, etc; see section <f0.S> for more details. ]
#
# a) Lines starting with the hash symbol # are comments (can be ignored).
# b) All other lines have information which is either:
#  1) a [page/unit locator] plus "parsable information" (one per [page/unit]), or
#  2) a [line locator] plus one line of Voynich text (may have in-line comments).
#
# [ Page, unit and line locators ] appear in angle brackets <>.
#
# The format of the [ page locator ] is: "f" plus the folio number,
# plus "r" for "recto" or "v" for "verso", and sometimes a further number
# for complex folios. Ex: <f1v> indicates folio 1 verso.
#
# [ A unit locator has the form <fNNN.UU> where <fNNN> is the page
# locator and UU identifies the unit within the page: typically "P"
# or "P1", "P2",... for paragraph-formatted blocks, "L1", "L2", ...
# for labels, and so on. ]
#
# [ To simplify parsing by Unix tools, folio and unit indicator
# lines were "passivated" by inserting "## " in front of them.
# These are the only lines that begin with "##".]
#
# Rene Zandbergen has added the Parsable Information to this file:
#
# A special type of in-line comment appears after the [ page/unit
# locator in page/unit header lines (type b1) ]. We call this
# "parsable information". The information is coded in "variables" set
# to values specific for that [ page/unit ], to facilitate the parsing
# and filtering using VTT. The variable names are single characters
# preceded by the $ symbol and they take as value a single character:
#
#      $I = illustration type  (T,H,A,Z,B,C,P,S)
#           Text, Herbal, Astronomical, Zodiac, Biological, Cosmological,
#           Pharmaceutical or Stars.
#      $Q = Quire              (A-T)
#      $P = page in quire      (A-X)
#      $L = Currier's language (A,B)
#      $H = Currier's hand     (1,2,3,4,5,X,Y)
#      $N = has non-Voynich text   (Y)
#      $K = has key-like sequence  (Y)
#      $X = has extraneous writing (Y)
#
#    Ex:  <f5r> {$I=H $Q=A $P=I $L=A $H=1 $N=Y} indicates a Herbal page
#    in quire A, page I, Currier Language A, hand 1 and has non-Voynich
#    text. Refer to the VTT documentation for details on how to use the
#    parsable information.
#
# All other lines have [a line locator starting on
# column 1, and ] Voynich code starting at column 20.
#
# [ The line locators have the form <fNNN.UU.LL;T> where <fNNN.UU> is
# the unit locator; LL is the line number; and T is the transcriber's
# code.
#
# The line number is a non-negative integer, optionally followed by a
# lowercase letter { a ... e }. The transcriber code is an uppercase
# letter.  The following codes were inherited from INTERLN.EVT: ]
#
#   C: Currier's transcription plus new additions from members of the
#      voynich list as found in the file voynich.now.
#   F: First study group's (Friedman's) transcription including various
#      items as found in the file FSG.NEW.
#   T: John Tiltman's transcription of some pages.
#   L: Don Latham's recent transcription of some pages.
#   R: Mike Roe's recent transcription of some pages.
#   K: Karl Kluge's transcription of some labels from Petersen's copies.
#   J: Jim Reed's transcription of some previously unreadable characters.
#   
# [ The following codes were added by J. Stolfi after 05 Nov 1997,
# in the unfolding of "[|]" groups:
#
#   D: second choice from [|] in "C" lines.
#   G: second choice from [|] in "F" lines, mostly from [1609|16xx].
#   I: second choice from [|] in "J" lines.
#   Q: second choice from [|] in "K" lines.
#   M: second choice from [|] in "L" lines. 
#   
# The following codes were assigned by J. Stolfi for use in 
# "new" transcriptions:
#
#   N: Gabriel Landini.
#   U: Jorge Stolfi.
#   V: John Grove.
#   P: Father Th. Petersen.
#   X: Denis V. Mardle.
#   Z: Rene Zandbergen.
#
#   H: Takeshi Takahashi's full transcription (see f0.K).
# ]
#
# In some cases (mostly for labels) there is also information about the
# label position (M. Roe's transcriptions) or about the original numbering
# of the labels found in the Petersen's copies (K. Kluge's transcriptions).
# I left that numbering untouched from the original files but it will be
# changed and standardised in the new transcription exercise.
#
# Examples:
# <f100r.26A;K> K. Kluge's transcription of label number 26A from Petersen.
# <f67v2.C1;C>  M. Roe's transcription of text in a "circle" from
#               the file voynich.now.
#
# [ The label locators were standardized across versions, in all cases
# where there were conflicts, by J. Stolfi. The original locators
# were retained as '{}' comments. ]
#
# In a few places there was a "first" line not present in one
# of the other versions. These lines were numbered 0, or assigned letters
# [ in INTERLN.EVT ]. Examples: <f41v.0;C>, <f84v.a;C>, <f84v.b;F>.
# [ Such lines were later renumbered "0a", "0b", etc.. ] 
#
# [ In the INTERLN file, the character ] % (percent) marks a missing
# character that exists at the same location in the other versions and
# which breaks synchronism. "Synchronism" means the vertical alignment
# of the sequences. Loss of synchronism may be due to a missing
# character in that version or an extra character in the other. [ The
# "%" characters were deleted, since the conversion from FSG to EVA
# destroyed the synchronism anyway. ]
#
# [ The padding characters "%" and "!", which have no correspondent in
# the manuscript, should not be confused with the code "*", which
# represents a manuscript character that the transcriber noticed but
# was unable to identify. ]
#
# The Friedman version (FSG.NEW) is composed of various items and
# therefore there are variations within FSG.NEW. [ In INTERLN.EVT,
# this variation was ] indicated as [A|B], meaning that one item has a
# character transcribed as an "A" and the other a "B". [ These '[|]'
# constructs were later unfolded into separate lines, identified by
# distinctive transcriber codes; see the table above. ]
#
# Because the brackets and the "or" symbol | also break the
# synchronism but do not indicate any Voynich characters in the
# sequence, the exclamation mark "!" was used to indicate that the
# other version has extra characters that do not code Voynich text. [
# These synchronizing fillers were deleted when the text was converted
# to EVA; in a few places they were re-inserted afterwards.
#
# As in the original transcription files, text limited by curly brackets {}
# is a comment. [ ... Examples:
#  
#   <f17r.P.7;H> kSheo.qokchy.choldShy.!zepchy.!!!!!!!!dS!a.!!!!!!!!opchordy-
#   <f17r.P.7;C> ksheo.qokchy.choldshy.!!mpchy.!!!!!!!!d*!!.!!!!!!!!opchordy-
#   <f17r.P.7;F> ksheo.qokchy.choldshy.**!pchy.!!!!!!!!dshy.!!!!!!!!opchordy-
#   <f17r.P.7;U> ksheo.qokchy.choldshy.**epchy-{flower}dshy-{flower}opchordy-
#
# ... ] 
#
