//  The bipartite ring, textured, with ridges but without legends 

//  Assumes defined
//  
//    ring_i_thickness = thickness of ring at inner edge
//    ring_m_thickness = thickness of ring at middle line
//    ring_o_thickness = thickness of ring at outer edge
//
//    ring_i_radius = inner  ring radius
//    ring_m_radius = middle ring radius
//    ring_o_radius = outer  ring radius
//    ring_ridge_radius = radius of ridges
//    
//    ring_o_texture
//    ring_i_texture
//
//    ring_o_ridge_texture
//    ring_m_ridge_texture
//    ring_i_ridge_texture
//
//  Defines
//  
//    dcc_ring_adorned = the ring, with ridges but without legends

#include "dcc-ring-plain.inc"

#declare dcc_ring_adorned =
  union{
    object{ dcc_ring_plain_i texture{ ring_i_texture } }
    object{ dcc_ring_plain_o texture{ ring_o_texture } }
    torus{ 
      ring_o_radius - ring_ridge_radius, ring_ridge_radius
      translate < 0, ring_o_thickness, 0 >
      texture{ ring_o_ridge_texture }
    }
    torus{ 
      ring_m_radius, ring_ridge_radius
      translate < 0, ring_m_thickness, 0 >
      texture{ ring_m_ridge_texture }
    }
    torus{ 
      ring_i_radius + ring_ridge_radius, ring_ridge_radius 
      translate < 0, ring_i_thickness, 0 >
      texture{ ring_i_ridge_texture }
    }
  }
      
    

