// POVRAY description of the DCC "abacus" logo, stark black/white with grey bg

background{ color rgb <0.50, 0.50, 0.50> }

light_source {
  <0000.0000, +040.0000, +010.0000>
  color rgb <0.70, 0.70, 0.70>
} 

light_source {
  <+000.1000, +030.0000, -005.0000>
  color rgb <0.30, 0.30, 0.30>
} 

light_source {
  <-000.1000, +030.0000, -005.0000>
  color rgb <0.30, 0.30, 0.30>
} 

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#declare texture_chalk =
  texture{
    pigment{
      color rgb <1.00, 1.00, 1.00>
    }
    finish {diffuse 0.3 ambient 0.7}
  }

#declare texture_ash =
  texture{
    pigment{
      color rgb <0.70, 0.70, 0.70>
    }
    finish {diffuse 0.95 ambient 0.05}
  }

#declare texture_dusk =
  texture{
    pigment{
      color rgb <0.30, 0.30, 0.30>
    }
    finish {diffuse 0.95 ambient 0.05}
  }

#declare abacus_frame_texture = texture{texture_ash}

#declare abacus_stick_texture = texture{texture_ash}

#declare abacus_unit_slider_texture = texture{texture_chalk}
#declare abacus_unit_slider_interior = interior{}

#declare abacus_five_slider_texture = texture{texture_chalk}
#declare abacus_five_slider_interior = interior{}

#include "dcc-std-abacus.inc"

object{abacus}

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 0;
#declare camDY = 14;
#declare camDZ = 0;

#declare skyX = 0;
#declare skyY = 0;
#declare skyZ = 1;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+2.5000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +2.5000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

