//  Metal textures: silver and gold
//  
//  Assumes defined
//  
//    highlight_color
//  
//  Defines
//
//    metal_finish
//    silver_texture
//    gold_texture

#declare metal_finish =
  finish{
    metallic
    ambient 0.05
    diffuse 0.4
    brilliance 6
    reflection 0.55
    phong 0.75 phong_size 80
  }

#declare gold_texture = 
  texture{
    pigment{color rgb <0.80, 0.60, 0.10>}
    finish{metal_finish}
  }
  
#declare silver_texture = 
  texture{
    pigment{color rgb <0.95, 0.97, 1.00>}
    finish{metal_finish}
  }

