#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <assert.h>
#include <affirm.h>
#include <jsfile.h>
#include <float_image.h>
#include <float_pnm_image_io.h>
#include <float_image_heights.h>
#include "normais.h"


#define TINY (1.0e-200)
/* Um valor minúsculo usado para evitar divisão por zero. */

#define SQRT_2_PI (2.5066282746310005024)

#define K_09 1.5
/* K utilizado na EstLogProb_09*/

struct NoIndice{
  int indice;
  double valor;
};

typedef struct NoIndice noind;

/* Explicar estes pesos !!! */
double wRed = 0.4;
double wGrn = 0.4;
double wBlu = 0.2;

double corGab[3] = {1.0,1.0,1.0};

vetorn* cria_vetor(int tam);
noind* copy_vetorn(vetorn* v);
void libera_noind(noind* vet);
int compare (const void * a, const void * b);
double dist_alpha2(vetorn* s, vetorn* g);

double getRed(void){
  return wRed;
}

double getGrn(void){
  return wGrn;
}

double getBlu(void){
  return wBlu;
}

void set_Gab_Color(double R, double G, double B){
  corGab[0] = R;
  corGab[1] = G;
  corGab[2] = B;
}

void set_Peso(double Red, double Green, double Blue){
  wRed = Red;
  wGrn = Green;
  wBlu = Blue;
	
}

double media_ponderada(double R, double G, double B){
  double temp;
  temp = wRed*R;
  temp = temp + (wGrn*G);
  temp = temp + (wBlu*B);
  //temp = fabs(temp);// fabs - funcao do math.h que retorna o valor absoluto de um  double
  return temp;
}

double nova_media(double R, double G, double B, double* w){
  double divisor;
  double epslon = 0.01;
  double temp;
  divisor = (R*R) + (B*B) + (G*G) + epslon;
  *w = 1 /divisor;
	
  temp = wRed*R;
  temp = temp + (wGrn*G);
  temp = temp + (wBlu*B);

  return temp;
	
	
}

void extrai_assinatura(const double OBS[], double ass[], double *mag, int num_luzes)
{
  int i;
  double soma = TINY;
  for(i = 0; i < num_luzes; i++){ soma = soma + OBS[i]*OBS[i]; }
  (*mag) = sqrt(soma);
  for(i = 0; i < num_luzes; i++) { ass[i] = OBS[i]/(*mag); }
}

double dist_euclid(const double u[], const double v[], int n){
  int i;
  double soma = 0.0;
  for(i = 0; i< n;i++ ){
    double aux = (u[i] - v[i]);
    aux = (aux*aux);
    soma = soma + aux;
  }
	
  return sqrt(soma);
}



double dist_point_box(double p[],r2_t box[],int n){
	//compute the distance from point and a n-dimensional box 
	int i;
	int dist = 0;
	for(i = 0; i < n; i++){
		double blo = box[i].c[0];
		double bhi = box[i].c[1];
		if(p[i] < blo){
			dist+= ((blo - p[i])*(blo - p[i]));
		}else if(p[i] > bhi){
			dist+= ((bhi - p[i])*(bhi - p[i]));
		}
	}
	return  sqrt(dist);
	
}

double dist(vetorn* u, vetorn* v){
  return dist_euclid(u->valor,v->valor,u->tam);
}

int compare (const void * a, const void * b)
{
  double valora;
  double valorb;
  noind*  noa;
  noind*  nob;
  noa = (noind*) a;
  nob = (noind*) b;

  valora = noa->valor;
  valorb = nob->valor;
	
  //	fprintf(stderr,  "A:%f B:%f \n",valora,valorb);
  if(valora > valorb){
    return -1;
  }
  if(valora == valorb ) return 0;
  return 1;
}

int CompareDouble(const void* a, const void* b){
  double va,vb;
  va = *((double*)a);
  vb = *((double*)b);
  return va < vb;
}

bool_t debug_dist = FALSE;
/* Se esta variável for TRUE, as funções {EstLogPrSG_{NN}} se debugam. */

int localiza_simples
  ( Tabela* tab, 
    const double SO[], 
    estima_log_prob_S_G_t *estLogPrSG, 
    estima_albedo_t *estAlbedo, 
    double sigma, 
    double omg0, 
    double omg1, 
    double *logPrSG, 
    double *albedo, 
    normal_debug_opts_t *dbopt
  )
{
  int num_luzes = get_num_luzes(tab);
  int num_linhas = get_num_linhas(tab);

  /* Normaliza o vetor de observações {SO} obtendo a assinatura {so}: */
  double so[num_luzes];
  double Smag;
  extrai_assinatura(SO, so, &Smag, num_luzes);

  /* Melhor linha (candidata a resposta): */
  int melhor_linha = -1;
  double maior_logPrSG = -HUGE_VAL;
  
  /* Para debugging: */
  double menor_logPrSG = +HUGE_VAL;
  int pior_linha = -1;
  int segunda_melhor_linha = -1;

  /* Procura a entrada de {tab} que maximiza {estLogPrSG}: */
  int linha;
  debug_dist = (dbopt != NULL);
  for(linha = 0; linha < num_linhas; linha++) {
    const double *go = get_intdir(tab,linha);
    double Gmag = get_intmag(tab, linha);
    double logPrSG_linha = estLogPrSG(so, Smag, go, Gmag, num_luzes, sigma, omg0, omg1);
    
    if (logPrSG_linha > maior_logPrSG) {
      segunda_melhor_linha = melhor_linha;
      melhor_linha = linha;
      maior_logPrSG = logPrSG_linha;
    }
    if (logPrSG_linha < menor_logPrSG) {
      pior_linha = linha;
      menor_logPrSG = logPrSG_linha;
    }

    if (dbopt != NULL) {
      fprintf(dbopt->arq_debug, "SMP --- ");
      r3_t SN = get_normal(tab,linha);
      r3_t RN = dbopt->normal_ref;
      escreve_log_prob_e_alphas
        (dbopt->arq_debug, dbopt->hp, dbopt->vp, &RN, &SN, logPrSG_linha, so, Smag, go, Gmag, num_luzes);
    }
  }
  assert(melhor_linha != -1);
  assert(maior_logPrSG != -HUGE_VAL);
  
  /* Gera plots de {SO[i] x GO[i]} e {Pr(S)} em função de alpha, se solicitado: */
  if ((dbopt != NULL) && (dbopt->gera_plots_q)) { 
    /* Escolhe algumas linhas interessantes {lin[0..m-1]} da tabela: */
    int m = 5;
    int lin[m];
    r3_t zenite = (r3_t){{ 0,0,1 }};
    lin[0] = melhor_linha; /* Linha escolhida pela função de busca. */
    lin[1] = segunda_melhor_linha; /* Segunda melhor opção da função de busca. */
    lin[2] = localiza_linha_por_normal(tab, &(dbopt->normal_ref)); /* Linha da normal de referencia. */
    lin[3] = localiza_linha_por_normal(tab, &zenite); /* Linha com normal {(0,0,0)}. */
    lin[4] = pior_linha; /* Linha considerada pior pela função de busca. */
    escreve_linhas_interessantes(dbopt, tab, SO, estLogPrSG, sigma, omg0, omg1, lin, m);
    gera_plot_Si_Gi(dbopt, tab, SO, lin, m);
    gera_plot_Pr_alpha(dbopt, tab, SO, sigma, omg0, omg1, lin, m);
    gera_plots_Pr_alpha_CbP(dbopt, tab, SO, sigma, omg0, omg1, lin, m);
  }

  /* Gera mapa de logprob sobre o gabarito, se solicitado: */
  if ((dbopt != NULL) && (dbopt->mapa_gabarito)) { 
    gera_mapa_prob_gabarito(dbopt, tab, SO, estLogPrSG, sigma, omg0, omg1);
  }

  /* Devolve o log da probabilidade: */
  (*logPrSG) = maior_logPrSG;
  
  /* Calcula e devolve o albedo mais provável: */
  { const double *go = get_intdir(tab, melhor_linha);
    double Gmag = get_intmag(tab, melhor_linha);
    (*albedo) = estAlbedo(so, Smag, go, Gmag, num_luzes, sigma, omg0, omg1);
  }

  /* Devolve o índice da linha encontrada. */
  return melhor_linha;
}

int localiza_alternativa
  ( Tabela* tab, 
    const double SO[], 
    estima_log_prob_S_G_t *estLogPrSG, 
    estima_albedo_t *estAlbedo, 
    double sigma, 
    double omg0, 
    double omg1, 
    double *logPrSG, 
    double *albedo, 
    normal_debug_opts_t *dbopt
  )
{
  int linha_res;
  int logPrSG_res;
  double albedo_res;

  /* Primeiro, procura a entrada com {EstLogPrSG_00} (supondo que não há sombras): */
  double logPrSG_e = -HUGE_VAL;
  double albedo_e = 0.0;
  int linha_e = localiza_simples (
    tab, SO, 
    EstLogPrSG_00, estAlbedo, sigma, omg0, omg1, 
    &logPrSG_e, &albedo_e, 
    dbopt
  );
  assert(linha_e != -1);
  assert(logPrSG_e != -HUGE_VAL);

  /* Calcula o erro esperado se não houvesse sombras: */ 
  int num_linhas = get_num_linhas(tab);
  double logPrSG_corte = sqrt(M_PI/num_linhas); /* !!! Determinar a fórmula !!! */

  if(logPrSG_e <= logPrSG_corte) { 
      /* Aceitável: */ 
      logPrSG_res = logPrSG_e;
      linha_res = linha_e;
      albedo_res = albedo_e;
  } else { 
      /* Repete busca com estimador {estLogPrSG}: */
      double logPrSG_w = -HUGE_VAL;
      double albedo_w = 0.0;
      int linha_w = localiza_simples (
        tab, SO, 
        estLogPrSG, estAlbedo, sigma, omg0, omg1, 
        &logPrSG_w, &albedo_w, 
        dbopt
      );
      assert(linha_w != -1);
      assert(logPrSG_w != -HUGE_VAL);
      linha_res = linha_w;
      logPrSG_res = logPrSG_w;
      albedo_res = albedo_w;
  }

  /* Devolve a resposta: */
  (*logPrSG) = logPrSG_res;
  (*albedo) = albedo_res;
  return linha_res;
}

void escreve_linhas_interessantes (
    normal_debug_opts_t *dbopt,
    Tabela* tab, 
    const double SO[], 
    estima_log_prob_S_G_t *estLogPrSG, 
    double sigma, 
    double omg0, 
    double omg1,
    int lin[],
    int m
  ) 
  {
    char *nome_arq = NULL;
    asprintf(&nome_arq, "%s_%d_%04d_%04d_linhas.txt", dbopt->prefixo, dbopt->c, dbopt->hp, dbopt->vp);
    FILE *arq = open_write(nome_arq, TRUE);
    int n = get_num_luzes(tab);

    double so[n];
    double Smag;
    extrai_assinatura(SO, so, &Smag, n);

    int j, i;
    for (j = 0; j <= m; j++) {
      fprintf(arq, "%3d %6d", j, (j < 0 ? -1 : lin[j]));
      if (j == m) {
        fprintf(arq, "  %+9.6f %+9.6f %+9.6f", 0.0,0.0,0.0);
        /* Auto-gabarito: */
        double logPrSG_self = estLogPrSG(so, Smag, so, Smag, n, sigma, omg0, omg1);
        fprintf(arq, "  %+12.6lf", logPrSG_self);
        for (i = 0; i < n; i++) { fprintf(arq, " %5.3f", SO[i]); }
      } else {
        int linha = lin[j];
        const double *go = get_intdir(tab,linha);
        double Gmag = get_intmag(tab,linha);
        r3_t gn = get_normal(tab, linha);
        fprintf(arq, "  %+9.6f %+9.6f %+9.6f", gn.c[0], gn.c[1], gn.c[2]);
        double logPrSG_linha = estLogPrSG(so, Smag, go, Gmag, n, sigma, omg0, omg1);
        fprintf(arq, "  %+12.6lf", logPrSG_linha);
        for (i = 0; i < n; i++) { fprintf(arq, " %5.3f", Gmag*go[i]); }
      }
      fprintf(arq, "\n");
    }
    fclose(arq);
    free(nome_arq);
    fprintf(stderr, "pronto.\n");
  }

void gera_plot_Si_Gi (
    normal_debug_opts_t *dbopt,
    Tabela* tab, 
    const double SO[], 
    int lin[],
    int m
  ) 
  {
    char *nome_arq = NULL;
    asprintf(&nome_arq, "%s_%d_%04d_%04d_Si_Gi.txt", dbopt->prefixo, dbopt->c, dbopt->hp, dbopt->vp);
    FILE *arq = open_write(nome_arq, TRUE);
    int n = get_num_luzes(tab);
    int i;
    for (i = 0; i < n; i++) {
      fprintf(arq, "%3d %5.3f", i, SO[i]);
      int j;
      for (j = 0; j <= m; j++) {
        if (j == m) {
          /* Auto-gabarito: */
          fprintf(arq, " %5.3f", SO[i]);
        } else {
          int linha = lin[j];
          const double *go = get_intdir(tab,linha);
          double Gmag = get_intmag(tab,linha);
          fprintf(arq, " %5.3f", Gmag*go[i]);
	}
      }
      fprintf(arq, "\n");
    }
    fclose(arq);
    free(nome_arq);
    fprintf(stderr, "pronto.\n");
  }

void gera_plot_Pr_alpha (
    normal_debug_opts_t *dbopt,
    Tabela* tab, 
    const double SO[], 
    double sigma, 
    double omg0, 
    double omg1,
    int lin[],
    int m
  )
  {
    char *nome_arq = NULL;
    asprintf(&nome_arq, "%s_%d_%04d_%04d_Pr_S_a.txt", dbopt->prefixo, dbopt->c, dbopt->hp, dbopt->vp);
    FILE *arq = open_write(nome_arq, TRUE);
    int n = get_num_luzes(tab);
    
    double so[n];
    double Smag;
    extrai_assinatura(SO, so, &Smag, n);
    
    int nsteps = (int)ceil(3.0*sqrt(n)/sigma);
    int k;
    for (k = 0; k <= nsteps; k++) {
      double albedo = ((double)k)/((double)nsteps);
      fprintf(arq, "%5d %7.5f ", k, albedo);
      int j;
      for (j = 0; j <= m; j++) {
        double logPrSG;
        if (j == m) {
	  /* Auto-gabarito: */
          logPrSG = LogPrSGalb(so, Smag, so, Smag, n, albedo, sigma, omg0, omg1);
	} else {
          int linha = lin[j];
          const double *go = get_intdir(tab,linha);
          double Gmag = get_intmag(tab,linha);
          logPrSG = LogPrSGalb(so, Smag, go, Gmag, n, albedo, sigma, omg0, omg1);
	}
        fprintf(arq, " %+12.6lf", logPrSG);
      }
      fprintf(arq, "\n");
    }
    fclose(arq);
    free(nome_arq);
    fprintf(stderr, "pronto.\n");
  }

void gera_plots_Pr_alpha_CbP (
    normal_debug_opts_t *dbopt,
    Tabela* tab, 
    const double SO[], 
    double sigma, 
    double omg0, 
    double omg1,
    int lin[],
    int m
  )
  {
    int n = get_num_luzes(tab);
    double so[n];
    double Smag;
    extrai_assinatura(SO, so, &Smag, n);
    
    int j;
    for (j = 0; j <= m; j++) {
      char *nome_arq = NULL;
      asprintf(&nome_arq, "%s_%d_%04d_%04d_ln%02d_Pr_S_a_CbP.txt", dbopt->prefixo, dbopt->c, dbopt->hp, dbopt->vp, j);
      FILE *arq = open_write(nome_arq, TRUE);
      if (j == m) {
	/* Auto-gabarito: */
        (void)LogPrSG_CbP(SO, SO, n, sigma, omg0, omg1, K_09, arq); 
      } else {
        int linha = lin[j];
        const double *go = get_intdir(tab,linha);
        double Gmag = get_intmag(tab,linha);
        double GO[n];
        int k;
        for(k = 0; k < n; k++){ GO[k] = go[k]*Gmag; }
        (void)LogPrSG_CbP(SO, GO, n, sigma, omg0, omg1, K_09, arq);
      }
      fclose(arq);
      free(nome_arq);
      fprintf(stderr, "pronto.\n");
    }
  }

void gera_mapa_prob_gabarito (
    normal_debug_opts_t *dbopt,
    Tabela* tab, 
    const double SO[], 
    estima_log_prob_S_G_t *estLogPrSG, 
    double sigma, 
    double omg0, 
    double omg1
  )
  {
    int nx = 100;
    int ny = 100;
    float_image_t  *img = float_image_new(1, nx, ny);
    float_image_fill(img, -INF); 

    int n = get_num_luzes(tab);
    double so[n];
    double Smag;
    extrai_assinatura(SO, so, &Smag, n);
    
    int num_linhas = get_num_linhas(tab);
    int linha;
    for (linha = 0; linha < num_linhas; linha ++)
      { const double *go = get_intdir(tab,linha);
        double Gmag = get_intmag(tab,linha);
        r3_t gn = get_normal(tab, linha);
        double logPrSG = estLogPrSG(so, Smag, go, Gmag, n, sigma, omg0, omg1);
        int x = (int)floor(nx*(gn.c[0] + 1)/2);
        int y = (int)floor(ny*(gn.c[1] + 1)/2);
        float *p = float_image_get_sample_address(img, 0, x, y);
	if (logPrSG > (*p)) { (*p) = logPrSG; }
      }
  
    /* Find the range {[vmin _ vmax]} of all finite values in image: */
    float vmin = +INF, vmax = -INF;
    float_image_update_sample_range(img, 0, &vmin, &vmax);
    float_image_rescale_samples(img, 0, vmin, vmax, 0.0, 1.0);
    char *nome_arq = NULL;
    asprintf(&nome_arq, "%s_%d_%04d_%04d_pr_gab.pgm", dbopt->prefixo, dbopt->c, dbopt->hp, dbopt->vp);
    float_pnm_image_write(nome_arq, img, 1.000, 0.000,FALSE,TRUE,TRUE);
    free(nome_arq);
    float_image_free(img);
    fprintf(stderr, "pronto.\n");
  }

void calcula_alphas(const double so[], const double go[], int num_luzes, double epsilon, double alpha[]) 
{
  int luz;
  for (luz = 0; luz < num_luzes; luz++) {
    alpha[luz] = calcula_alpha(so[luz],go[luz],epsilon);
  }
}

int CompareAlphaObs (const void * a, const void * b){
  alpha_obs_t *va = (alpha_obs_t *)a;
  alpha_obs_t *vb = (alpha_obs_t *)b;
  return va->alpha < vb->alpha;
}

void calcula_alphas_ordenados
  ( const double so[], 
    double Smag, 
    const double go[], 
    double Gmag, 
    int num_luzes, 
    double epsilon,  
    alpha_obs_t ao[]
  ) 
{
  int i;
  for(i = 0; i < num_luzes; i++) {
    ao[i].S_p = so[i]*Smag;
    ao[i].G_q = go[i]*Gmag;
    ao[i].alpha = calcula_alpha(ao[i].S_p, ao[i].G_q, epsilon);
    ao[i].luz = i;
  }
  qsort (ao, num_luzes, sizeof(alpha_obs_t), CompareAlphaObs);
}

void escreve_candidato_Sp_Gq(FILE *arq, int hp, int vp, r3_t *snp, r3_t *normal_ref, int num_luzes, double SO[], double GO[])
{
  fprintf(arq,"%04d %04d", hp, vp);
  fprintf(arq,"  %+9.6lf %+9.6lf %+9.6lf", snp->c[0], snp->c[1], snp->c[2]);
  fprintf(arq,"  %+9.6lf %+9.6lf %+9.6lf", normal_ref->c[0], normal_ref->c[1], normal_ref->c[2]);
  int j;
  for(j = 0; j < num_luzes; j++){
    fprintf(arq,"  %8.6lf %8.6lf", SO[j], GO[j]);
  }
  fprintf(arq,"\n");
  fflush(arq);
}

void escreve_log_prob_e_alphas
( FILE *output, 
  int hp, int vp, 
  r3_t *rnp,
  r3_t *snp, 
  double logPrSG_est, 
  const double so[], 
  double Smag, 
  const double go[], 
  double Gmag, 
  int num_luzes
  )
{
  fprintf(output,"%04d %04d",hp,vp);
  fprintf(output,"  %+8.5lf %+8.5lf %+8.5lf", rnp->c[0], rnp->c[1], rnp->c[2]);
  fprintf(output,"  %+8.5lf %+8.5lf %+8.5lf", snp->c[0], snp->c[1], snp->c[2]);
  double distNormals = dist_euclid(snp->c, rnp->c, 3);
  fprintf(output,"  %8.6lf %+12.6lf ", distNormals, logPrSG_est);
  // double logRatio = (2*log(distNormals+0.000001) - logPrSG_est)/log(10.0);
  // fprintf(output,"  %+10.6lf", logRatio);
  alpha_obs_t ao[num_luzes];
  calcula_alphas_ordenados(so, Smag, go, Gmag, num_luzes, OBS_NOISE, ao) ;
  int i;
  for(i = 0; i < num_luzes; i++){
    fprintf(output,"  %12.6lf",ao[i].alpha);
    fprintf(output," %5.3lf %5.3lf %02d", ao[i].S_p, ao[i].G_q, ao[i].luz);
  }
  fprintf(output,"\n");
}

double calcula_alpha(double S,double G,double epsilon)
{
  return (sqrt(S*S+epsilon*epsilon) - epsilon)/sqrt(G*G + epsilon*epsilon);
  //return sqrt(S*S+(epsilon*epsilon*0.5))/sqrt(G*G + epsilon*epsilon);
}

double ProbSiGialb(double Si, double Gi, double alb, double sigma, double omg0, double omg1)
  { /* Supõe que 
        {Pr(Si | Gi,alb) = omg0*E + omg1*H + (1-omg0-omg1)*G}
      onde
        {E = (1/Mi)*(0.5 - 0.5*erf(r))}      # FDP supondo sombra.
        {H = (1/(1-Mi))*(0.5 + 0.5*erf(r))}  # FDP supondo highlight.
        {G = (1/sigma)*exp(-r*r/2)/sqrt(2*pi)}  # FDP supondo iluminação normal.
        {Mi = alb*Gi},
        {r = (Si - Mi)/sigma},
      !!! Deveriamos usar uma aproximação que evite calcular {exp} e {log}.
      !!! Compensar quando {Mi} é menor que {3*sigma} ou maor que {1-3*sigma} para integral ser 1. */

    double R = 2.0*sigma;
    double Mi = alb*Gi;  /* Valor esperado de {Si} */

    double r0 = (Si - Mi - R)/sigma;
    double ERF0 = (r0 < -4.0 ? 0.0 : (r0 > +4.0 ? 1.0 : 0.5*(1 + erf(r0))));
    double E = (1/(Mi + R))*(1 - ERF0);
    
    double r1 = (Si - Mi + R)/sigma;
    double ERF1 = (r1 < -4.0 ? 0.0 : (r1 > +4.0 ? 1.0 : (0.5 + 0.5*erf(r1))));
    double H = (1/(1-Mi+R))*ERF1;
      
    double r = (Si - Mi)/sigma;
    double G = (fabs(r) > 4.0 ? 0.0 : (1/sigma)*exp(-r*r/2)/sqrt(2*M_PI));
    double Pr = omg0*E + omg1*H + (1-omg0-omg1)*G;
    return Pr;
  }

double LogProbSiGialb(double Si, double Gi, double alb, double sigma, double omg0, double omg1)
  { return log(ProbSiGialb(Si, Gi, alb, sigma, omg0, omg1)); }

double LogPrSGalb(const double so[], double Smag, const double go[], double Gmag, int n, double alb, double sigma, double omg0, double omg1)
  { double logPrSG = 0.0;
    int i;
    for(i = 0; i < n; i++) {
      //  if (i != 1) { continue; } /* !!!!! TIRAR ISTO !!!!!!! */
      double lpri = LogProbSiGialb(Smag*so[i], Gmag*go[i], alb, sigma, omg0, omg1);
      logPrSG += lpri;
    }
    return logPrSG;
  }

double LogPrSG_CbP(const double SO[], const double GO[], int n, double sigma, double omg0, double omg1,double K, FILE *arq)
  {     
     
    double R = K*sigma; /* Largura do intervalo central no eixo {S}. */
    
    /* Obtém a lista ordenada dos extremos de intervalos: */
    int nex = 2*n;  /* Número de extremos de intervalos de albedo. */
    int ix[nex];    /* Identificadores de extremos em ordem crescente. */
    double vx[nex]; /* Valores dos extremos em ordem crescente. */
    CriaExtremosDeAlbedo_09(SO, GO, n, R, ix, vx);
    OrdenaExtremosDeAlbedo(ix, vx, nex);

    /* Calcula os três valores de cada fator: */
    double PrLoAlb[n]; /* Valor de Pr(S[i] | G[i],alb)} para {alb < alo[i]}. */ 
    double PrMdAlb[n]; /* Valor de Pr(S[i] | G[i],alb)} para {alb} entre {alo[i],ahi[i]}. */ 
    double PrHiAlb[n]; /* Valor de Pr(S[i] | G[i],alb)} para {alb > ahi[i]}. */ 
    int i;
    for (i = 0; i < n; i++) {

      double Si = SO[i];
      double Gi = GO[i];
    
      /* Limites da fórmula constante-por-partes de {Pr(Si|Gi,alb)}: */
      double alo = (Si < 2*R ? 0.0 : (Si > Gi + R ? 1.0 : (Si - R)/Gi ));
      double ahi = ((Si > Gi - R) || (Si > 1 - 2*R) ? 1.0 : (Si + R)/Gi);
      double amd = 0.5*(alo + ahi);
      
      double lam = 0.57735026918962576450; /* sqrt(1/3) para quadratura de Gauss. */
      double grd = lam * (ahi - amd); 

      PrLoAlb[i] = ProbSiGialb(Si,Gi,0.5*(0 + alo),sigma,omg0,omg1);
      PrHiAlb[i] = ProbSiGialb(Si,Gi,0.5*(1 + ahi),sigma,omg0,omg1);
      double P0 = ProbSiGialb(Si,Gi,amd - grd,sigma,omg0,omg1);
      double P1 = ProbSiGialb(Si,Gi,amd + grd,sigma,omg0,omg1);
      PrMdAlb[i] = 0.5*(P0 + P1);
      if (isnan(PrLoAlb[i]) || isnan(PrHiAlb[i]) || isnan(PrMdAlb[i])) { fprintf(stderr, "#@#! %d\n", i); }
    }
    
    /* Calcula o valor de {Pr(S|G,alb)} para {alb = 0}: */
    double Prob = 1.0;
    for (i = 0; i < n; i++) { Prob *= PrLoAlb[i]; }
    assert(Prob >= 1.0e-290);
      
    /* Percorre a lista {ix,vx}, atualizando o produto {Prob} e acumulando a integral. */
    double Intg = 0.0; /* Integral de {Pr(S|G,alb)dalb} até o albedo corrente. */
    int j;
    if (arq != NULL) { fprintf(arq, "%3d %8.6f %24.16e\n", -1, 0.0, Prob); }
    for (j = 0; j < nex; j++)
      { /* Neste momento o albedo corrente é {vx[j] - epsilon}. */
        if (j > 0) { assert(vx[j] >= vx[j-1]); }
        if (arq != NULL) { fprintf(arq, "%3d %8.6f %24.16e\n", j, vx[j], Prob); }
        /* Acumula a integral: */
        double dalb = vx[j] - (j == 0 ? 0.0 : vx[j-1]); /* Largura do trecho que terminou. */
        Intg += Prob*dalb;
        /* Atualiza o valor de {Prob}. */
        /* Determina o índice {i} do intervalo ao qual pertence o extremo {ix[j],vx[j]}:  */
        int i = (ix[j] > 0 ? +ix[j] - 1 : -ix[j] - 1);
	// if (i != 1) { continue; } /* !!!!! TIRAR ISTO !!!!!!! */
        if (ix[j] < 0) 
          { /* Extremo inferior de novo intervalo: */
            Prob /= PrLoAlb[i];
            Prob *= PrMdAlb[i];
          }
        else
    	  { /* Extremo superior de um intervalo: */
            Prob /= PrMdAlb[i];
            Prob *= PrHiAlb[i];
    	  } 
	/*   if (isnan(Prob)) { fprintf(stderr, " %d\n", i); }
	     if (TRUE) {  !!!!!! Prob < 1.0e-290 
          fprintf(stderr, "extremo vx[%d] = %24.16e S[%d] = %24.16e  G[%d] = %24.16e\n", j, vx[j], i, SO[i], i, GO[i]);
          fprintf(stderr, "PrLoAlb = %24.16e\n", PrLoAlb[i]);
          fprintf(stderr, "PrMdAlb = %24.16e\n", PrMdAlb[i]);
          fprintf(stderr, "PrHiAlb = %24.16e\n", PrHiAlb[i]);
          fprintf(stderr, "Prob = %24.16e\n", Prob);
	  assert(isfinite(Prob) && (Prob >= 1.0e-290));
 	}*/
        if (arq != NULL) { fprintf(arq, "%3d %8.6f %24.16e\n", j, vx[j], Prob); }
      }
    if (arq != NULL) { fprintf(arq, "%3d %8.6f %24.16e\n", nex, 1.0, Prob); }
    double dalb = 1 - vx[nex-1]; /* Largura do último trecho da integração. */
    Intg += Prob*dalb;
    
    return log(Intg);
  }

void CriaExtremosDeAlbedo_08(const double SO[], const double GO[], int n, double R, int ix[], double vx[])
  {
    int nex = 2*n; /* Número de extremos. */
    int i;

    /* double QUASE_UM =   0.999999999; */
    /* double QUASE_ZERO = 0.000000001; */
    
    /* Coloca todos os extremos em {ix[0..2*n-1], vx[0..2*n-1]}: */
    int j = 0;
    for (i = 0; i < n; i++)
      { double Si = SO[i];
        double Gi = GO[i];
        ix[j] = -i-1;  /* Reprsenta {alo[i]} */
	vx[j] = fmin(1.0, fmax(0.0, (Si - R)/(Gi + TINY)));  /* {alo[i]} */
        j++;
        ix[j] = +i+1; /* Representa {ahi[i]} */
	vx[j] = fmin(1.0, fmax(0.0, (Si + R)/(Gi + TINY))); /* {ahi[i]} */
        j++;
      }
    assert(j == nex);
  }

void CriaExtremosDeAlbedo_09(const double SO[], const double GO[], int n, double R, int ix[], double vx[])
  {
    int nex = 2*n; /* Número de extremos. */
    int i;

    /* double QUASE_UM =   0.999999999; */
    /* double QUASE_ZERO = 0.000000001; */
    
    /* Coloca todos os extremos em {ix[0..2*n-1], vx[0..2*n-1]}: */
    int j = 0;
    for (i = 0; i < n; i++)
      { double Si = SO[i];
        double Gi = GO[i];
    
        /* Limites da fórmula constante-por-partes de {Pr(Si|Gi,alb)}: */
        double aLO = (Si < 2*R ? 0.0 : (Si > Gi + R ? 1.0 : (Si - R)/Gi ));
	double aHI = ((Si > Gi - R) || (Si > 1 - 2*R) ? 1.0 : (Si + R)/Gi);
    
       /* Guarda no vetor: */
        ix[j] = -i-1;  /* Reprsenta {alo[i]} */
	vx[j] = aLO;  /* {alo[i]} */
        j++;
        ix[j] = +i+1; /* Representa {ahi[i]} */
	vx[j] = aHI; /* {ahi[i]} */
        j++;
      }
    assert(j == nex);
  }

void OrdenaExtremosDeAlbedo(int ix[], double vx[], int nex)
  {
    /* Insertion sort dos extremos: */
    int i;
    for (i = 0; i < nex; i++)
      { /* Insere {ix[i]} entre {ix[0..i-1]}: */
        int j = i;
        double vxi = vx[i];
        int ixi = ix[i];
        while ((j > 0) && (vxi < vx[j-1])) { vx[j] = vx[j-1]; ix[j] = ix[j-1];  j--; }
        ix[j] = ixi;
        vx[j] = vxi;
      }
    return;
  }

/* ESTIMADORES DE VEROSSIMILHANÇA */

double EstLogPrSG_00(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1)
{
//   double so_go = 0.0;
//   int i;
//   for (i = 0; i < n;i++){ so_go += so[i]*go[i]; }
//   double L1 = -n*log(sigma*SQRT_2_PI);
//   double t = Smag/sigma;
//   double L2 = -t*t*(1 - so_go);
//   return L1 + L2;'

//  double alb = (Smag + TINY)/(Gmag + TINY);
//  double sum  = 0.0;
//  int i;
//  for (i = 0; i < n;i++){ 
// 	double term  = (so[i]*Smag) - (alb*go[i]*Gmag);
// 	sum += term*term;
//  }
//  return -sum/(2.0*sigma*sigma);
   
    double dist_eu  = dist_euclid(so,go,n);
    double csi = (dist_eu*Smag/sigma);
    return -0.5*(csi*csi) + 2.0*log(Smag);
  
}

double EstLogPrSG_07(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1)
{
  /* Calcula {Pr(S|G) = \int_0^1 Pr(S|G,alb)Pr(alb)dalb} onde {alb} é o albedo hipotético 
    do pixel da cena.  O problema é que {Pr(S|G,alb)} é cheia de picos estreitos onde
    está toda a probabilidade.  Chutamos que esses picos podem ter 
    largura mínima {sigma/sqrt(n)}.  Portanto vamos dividir o intervalo de integração
    em {m} intervalos dessa largura, e usar a formula
    {C_PrG_S = \sum_{i=0}^{m-1} \int_{i/m}^{(i+1)/m} Pr(S|G,alb)Pr(alb)dalb} */

  int nsteps = (int)ceil(sqrt(n)/sigma);
  assert(nsteps >= 1);

  auto double IntPrSGalb(double amin, double amax);
  /* Calcula {\int_{amin}^{amax} Pr(S|G,alb)Pr(alb)dalb}, supondo {alb}
    uniformemente distribuida em [0_1]
    (isto é, {Pr(alb) = 1}), e que {Pr(S|G,alb)} é bem-compurtada no
    intervalo {[amin _ amax]}. */

  auto double PrSGalb(double alb);
  /* Calcula {Pr(S|G,alb)}, para um intervalo pequeno. */
  
  double PrSG = 0.0; /* Valor calculado de {A*Pr(G|S)}. */
  int i;
  for(i = 0; i < nsteps; i++) {	
    double amin = ((double)i)/nsteps;
    double amax = ((double)i+1)/nsteps;
    double intPr = IntPrSGalb(amin, amax);
    PrSG += intPr;
  }
  return log(PrSG);
  

  double IntPrSGalb(double amin, double amax)
    { /* Integral de Gauss com dois pontos. */
      double da = (amax - amin)*(0.5/sqrt(3));
      double f0 = PrSGalb(amin + da);
      double f1 = PrSGalb(amax - da);
      return 0.5*(f0 + f1)*(amax - amin);
    }

  double PrSGalb(double alb)
    { return exp(LogPrSGalb(so, Smag, go, Gmag, n, alb, sigma, omg0, omg1)); }
  
}

double EstLogPrSG_08(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1)
{
  /* Estima {Pr(S|G)} pela integral {\int_{aMIN}^{aMAX}
    Pr(S|G,alb)Pr(alb)dalb}, onde {alb} é o albedo hipotético do pixel
    da cena e {[aMIN _ aMAX]} é um intervalo de albedos onde se
    acredita que a integral seja significativa.

    Escolhemos {aMIN} e {aMAX} procurando primeiro o albedo {amed}
    onde há o maior número de pares {SO[i],GO[i]} ativos.  Um par
    {SO[i],GO[i]} é ativo para um albedo {alb} se {\abs{SO[i] -
    alb*GO[i]} <= K*sigma}, onde {K} é um parametro a ajustar
    (digamos, {K=3}).  Uma vez determinado {amed}, escolhemos {aMIN =
    amed - C} e {aMAX = amed + C}, onde {C} é outro
    parâmetro a ajustar. */

  double K = 2.0; /* Chute. */
  
  /* Obtém a lista ordenada dos extremos de intervalos: */
  double SO[n];
  double GO[n];
  int k ;
  for(k = 0; k < n;k++){ GO[k] = go[k]*Gmag; SO[k]= so[k]*Smag;}
  
  int nex = 2*n; /* Número de extremos de intervalos de albedo. */
  int ix[nex];    /* Identificadores de extremos em ordem crescente. */
  double vx[nex]; /* Valores dos extremos em ordem crescente. */
  CriaExtremosDeAlbedo_09(SO, GO, n, K*sigma, ix, vx);
  OrdenaExtremosDeAlbedo(ix, vx, nex);

  /* Procura o albedo {amed}: */
  int n_ativos = 0;           /* Número de intervalos que incluem o albedo corrente. */
  double sumGi2 = 0.0;        /* Soma de {G[i]^2} para esses intervalos. */

  int max_ativos = 0;         /* Número máximo de pares ativos para qualquer albedo. */
  double melhor_amed = -1.0;  /* Albedo para o qual esse máximo foi atingido. */
  double melhor_sumGi2 = 0.0; /* Valor correspondente de {sumGi2}. */
  
  int j;
  for (j = 0; j < nex; j++)
    { /* Neste momento o albedo corrente é {vx[j] - epsilon}. */
      if (j > 0) { assert(vx[j] >= vx[j-1]); }
      /* Determina o índice {i} do intervalo ao qual pertence o extremo {ix[j],vx[j]}:  */
      int i = (ix[j] > 0 ? +ix[j] - 1 : -ix[j] - 1);
      double Gi = Gmag*go[i];
      if (ix[j] < 0) 
        { /* Extremo inferior de novo intervalo: */
          n_ativos++; 
          sumGi2 += Gi*Gi;
        }
      else
	{ /* Extremo superior de um intervalo: */
          if (n_ativos > max_ativos)
	    { /* O trecho de albedo de onde estamos saindo é o melhor que já encontramos: */
              max_ativos = n_ativos;
	      assert(j > 0);
	      melhor_amed = (vx[j-1] + vx[j])/2;
	      melhor_sumGi2 = sumGi2;
	    }
          n_ativos--;
          sumGi2 -= Gi*Gi;
	}
    }
  assert(n_ativos == 0);
  bool_t debug_dist = (max_ativos >= 9);

  /* Estima o desvio padrão do produto das gaussianas ativas em {melhor_amed}: */
  double sigma_prod = sigma/sqrt(melhor_sumGi2 + TINY);

  if (debug_dist)
    {/* fprintf(stderr, "melhor albedo = %5.3f ativos = %2d sigma_prod = %7.5f", melhor_amed, max_ativos, sigma_prod);*/ }
  
  /* Escolhe o intervalo de integração: */
  double C = 3.0*sigma_prod; /* Outro chute. */
  double aMIN = fmin(1.0, fmax(0.0, melhor_amed - C));
  double aMAX = fmin(1.0, fmax(0.0, melhor_amed + C));
  
  /* Calcula o número de passos: */

  int nsteps = (int)ceil((aMAX-aMIN)/sigma_prod);
  assert(nsteps >= 1);
  
  if (debug_dist)
    { /*fprintf(stderr, "  intg = [ %5.3f _ %5.3f ] nsteps = %3d\n", aMIN, aMAX, nsteps);*/ }

  auto double IntPrSGalb(double amin, double amax);
  /* Calcula {\int_{amin}^{amax} Pr(S|G,alb)Pr(alb)dalb}, supondo {alb}
    uniformemente distribuida em [0_1]
    (isto é, {Pr(alb) = 1}), e que {Pr(S|G,alb)} é bem-compurtada no
    intervalo {[amin _ amax]}. */

  auto double PrSGalb(double alb);
  /* Calcula {Pr(S|G,alb)}, para um intervalo pequeno. */
  
  double PrSG = 0.0; /* Valor calculado de {A*Pr(G|S)}. */
  int i;
  for(i = 0; i < nsteps; i++) {	
    double tmin = ((double)i)/nsteps;
    double amin = (1-tmin)*aMIN + tmin*aMAX;
    double tmax = ((double)i+1)/nsteps;
    double amax = (1-tmax)*aMIN + tmax*aMAX;
    double intPr = IntPrSGalb(amin, amax);
    PrSG += intPr;
  }
  return log(PrSG);
  

  double IntPrSGalb(double amin, double amax)
    { /* Integral de Gauss com dois pontos. */
      double da = (amax - amin)*(0.5/sqrt(3));
      double f0 = PrSGalb(amin + da);
      double f1 = PrSGalb(amax - da);
      return 0.5*(f0 + f1)*(amax - amin);
    }

  double PrSGalb(double alb)
    { return exp(LogPrSGalb(so, Smag, go, Gmag, n, alb, sigma, omg0, omg1)); }
  
}

double EstLogPrSG_09(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1)
{
  /* Calcula {Pr(S|G) = \int_0^1 Pr(S|G,alb)Pr(alb)dalb} onde {alb} é o albedo hipotético 
    do pixel da cena.  Nesta versão, usamos uma aproximação constante-por-partes
    de cada fator {Pr(S[i]|G[i],alb)}. O intervalo {[0_1]} 
    é dividido em três partes, sendo a parte do meio um intervalo
    {[alo[i] _ ahi[i]]}, definido como na função {OrdenaExtremosDeAlbedo}
    com {R = K_09*sigma} para algum {K_09} 

    Uma vez que cada fator é constante-por-partes, o mesmo vale para 
    o produto {Pr(S|G,alb)}.  Basta então percorrer a lista ordenada 
    dos extremos dos intervalos {alo[i],ahi[i]}, calculando o valor
    em cada intervalo.  Custo: ordenação de {2*n} valores, mais
    constante vezes {n}.  */
  
  double SO[n];
  double GO[n];
  int i;
  for(i = 0; i < n;i++){ SO[i] = so[i]*Smag; GO[i] = go[i]*Gmag; }
  return LogPrSG_CbP(SO, GO, n, sigma, omg0, omg1, K_09, NULL);
}

/* ESTIMATIVAS DO ALBEDO **************************************************/

double EstAlbedo_00(const double so[], double Smag, const double go[], double Gmag, int n, double sigma, double omg0, double omg1)
{
  double alb = (Smag + TINY)/(Gmag + TINY);
  return fmax(0.0, fmin(1.0, alb));
}

double calcula_albedo(Tabela* tab, int resposta, const double SO[])
{
  int num_luzes = get_num_luzes(tab);
  int i;
  double soma = TINY;
  for(i = 0; i < num_luzes; i++ ){ soma += SO[i]*SO[i]; }
  double Smag = sqrt(soma);
  double Gmag = get_intmag(tab, resposta);
  return Smag/Gmag;
}

r3_t calcula_media_das_normais
  ( double peso_0, r3_t norm_0,
    double peso_1, r3_t norm_1,
    double peso_2, r3_t norm_2
  )
{
  /* Calcula a média ponderada das normais: */
  r3_t norm_media;
  int a;
  for (a = 0; a < 3; a++)
    { norm_media.c[a] = peso_0*norm_0.c[a] + peso_1*norm_1.c[a] + peso_2*norm_2.c[a]; }
  /* Normaliza {norm_media} para comprimento unitário: */
  double mag = r3_norm(&norm_media);
  if (mag != 0) { r3_scale(1/mag, &norm_media, &norm_media); }
  return norm_media;
}

double calcula_media_dos_pesos
  ( double dist_0, r3_t norm_0,
    double dist_1, r3_t norm_1,
    double dist_2, r3_t norm_2,
    r3_t norm_media
  )
{
  double eps = 0.01;
  double peso_0 = eps/hypot(dist_0, eps);
  double peso_1 = eps/hypot(dist_1, eps);
  double peso_2 = eps/hypot(dist_2, eps);
  //double peso = sqrt(wRed*peso_0*peso_0 + wGrn*peso_1*peso_1 + wBlu*peso_2*peso_2);
  /* O peso é menor quando a superfície é quase vertical: */

  double peso = eps/sqrt((wRed*peso_0*peso_0) +(wGrn*peso_1*peso_1) + (wBlu*peso_2*peso_2) + eps*eps);
  //double peso = eps/sqrt((wRed*dist_0*dist_0) +(wGrn*dist_1*dist_1) + (wBlu*dist_2*dist_2) + eps*eps);

  peso = peso * fmax(0.0, norm_media.c[2]);
  return peso;
}

estima_log_prob_S_G_t *escolhe_estLogPrSG(int num_funcao)
{
  switch(num_funcao) {
    case 0: return &EstLogPrSG_00;
   // case 2: return &EstLogPrSG_02;
    case 7: return &EstLogPrSG_07;
    case 8: return &EstLogPrSG_08;
    case 9: return &EstLogPrSG_09;
  default: demand(FALSE, "numero invalido da funcao de probabilidade"); return NULL;
  }
}
  
estima_albedo_t *escolhe_estAlbedo(int num_funcao)
{
  switch(num_funcao) {
    case 0: return &EstAlbedo_00;
    default: demand(FALSE, "numero invalido da funcao de albedo"); return NULL;
  }
}




double virtual_gab_phi1(double h,double r, double v){
	return h/r;
	//derivada em a1 da funcao phi
}

double virtual_gab_phi2(double h, double r, double v){
	return v/r;
}

double virtual_gab_phi3(double h, double r, double v){
	double aux;
	aux = r*r;
	aux = aux - (v*v);
	aux = aux - (h*h);
	if(aux < 0){
		aux = 0;
		//printf(" Menor %f %f.",h,v);
	}
	aux = sqrt(aux);
	aux = aux/r;
	//;printf("PHI3: %f",aux);
	return aux;
}

double virtual_gab_phi(double h, double r, double v,double a1, double a2, double a3){
	double resp;
	resp = a1*virtual_gab_phi1(h,r,v);
	resp = resp + (a2*virtual_gab_phi2(h,r,v));
	resp = resp + (a3*virtual_gab_phi3(h,r,v));
	if(resp < 0){
		resp =0;
	}
	return resp;

}


double virtual_gab_intensity(double x, double y,double radius,double a1,double a2, double a3, double x_center, double y_center){
	double h,v;
	v = y_center - y;
	h = x_center - x;
	
	return  virtual_gab_phi(h,radius,v,-a1,-a2,a3);
	
}

double lambertian_shading(r3_t dir_luz,double albedo, r3_t normal){
	double s = r3_dot(&dir_luz,&normal);
	return (s > 0 ? s*albedo: 0);
}

void converte_derivadas_para_normais(float_image_t* IDX, float_image_t* IDY, float_image_t* IN){
	assert(IN->sz[0] == 3);
	int nx = IN->sz[1];
	int ny = IN->sz[2];
	assert(IDX->sz[1] == nx);
	assert(IDX->sz[2] == ny);
	assert(IDY->sz[1] == nx);
	assert(IDY->sz[2] == ny);
	int x,y;
	for(x = 0; x < nx; x++){
		for(y = 0; y < ny; y++){
			r3_t vec;
			vec.c[0] = -float_image_get_sample(IDX,0,x,y); 
			vec.c[1] = -float_image_get_sample(IDY,0,x,y);
			vec.c[2] = 1.0 ;
			r3_dir(&vec,&vec);
			float_image_set_sample(IN,0,x,y,vec.c[0]);
			float_image_set_sample(IN,1,x,y,vec.c[1]);
			float_image_set_sample(IN,2,x,y,vec.c[2]);
		}
	}
} 

void interpola_normais(float_image_t* nrm,float_image_t* IW,char* prefDebug){
	
	
	
	float_image_t* IDX = calcula_derivadas(nrm, 'x', IW);
	float_image_t* IDY = calcula_derivadas(nrm, 'y', IW);
	interpola_derivadas_recursivo(IDX, IDY, IW,0, prefDebug);
	converte_derivadas_para_normais(IDX,IDY,nrm);
	float_image_free(IW);
}
