// Last edited on 2024-09-19 08:42:06 by stolfi

#include "slicing_cut_points.inc"

#debug "!! Loading slicing_skeleton.inc ...\n"

#macro slicing_skeleton(V, E, Zp, erad, vrad)
  // The edge and vertex skeleton of the fan.  Parameters:
  //
  // {V}           Array of vertex coordinates {V[1..Nv]}.
  // {E}           Array of edges {E[1..Ne]}.
  // {Zp}          List of slicing plane positions, {Zp[1..Np]}
  // {erad}        Radius of original edges.
  // {vrad}        Radius of vertices.
  
  // Assumes each entry {E[ke]} is a triple of integers {<kv_org,kv_dst,ty>}
  // where {kv_org,kv_dst} are indices into {V}, and {ty} is an edge type code.

  #debug "!! Generating skeleton edges and vertices ...\n"
  
  #local Nv = dimension_size(V, 1) - 1;
  #local Ne = dimension_size(E, 1) - 1;

  #local crad = 2.0*erad; // Radius of balls at cutpoints of original edges.
  
  // Uses array {Vmaxrad} to avoid generating multiple coincident spheres.
  // {Vmaxrad[kv]} is the max radius of spheres painted at vertex {kv}:
  #local Vmaxrad = array[Nv + 1];
  #for (kv, 0, Nv) #local Vmaxrad[kv] = 0;  #end

  #local skel = 
    union{
    
      #debug "!! Plotting all edges and vertices ...\n"
      #for (ke, 1, Ne)
        slicing_skeleton_edge_verts(V, E, ke, erad, vrad, Vmaxrad)
      #end
      
      #debug "!! Plotting edge-plane intersections...\n"
      #local cuts = slicing_cut_points(V, E, Zp, crad)
      object{ cuts }

      // To avoid stupid POV-Ray CSG warning:
      object{ nothing(1.77) }
      object{ nothing(1.87) }
    }
  skel
#end

#macro slicing_skeleton_edge_verts(V, E, ke, erad, vrad, Vmaxrad)   

  // #debug concat("!!   ke = ", str(ke,0,0), "\n")

  #local kv_org = E[ke].x; // Origin vertex index.
  #local kv_dst = E[ke].y; // Destination vertex index.
  #local ty = E[ke].z;  // Edge type.

  // #debug concat("!!   kv_org = ", str(kv_org,0,0), "\n")
  // #debug concat("!!   kv_dst = ", str(kv_dst,0,0), "\n")

  #if (ty = 0)
    // Original edge:
    #local tx = slicing_tx_skel_orig
    #local erad1 = erad;
    #local vrad1 = vrad;
  #elseif (ty = 1)
    // Subdivision edge:
    #local erad1 = 0.85 * erad;
    #local vrad1 = 0.85 * vrad; // So that orig vertices dominate diag vertices.
    #local tx = slicing_tx_skel_part
  #else
    // Ghost edge:
    #local erad1 = 0;
    #local tx = slicing_tx_skel_orig
  #end

  #local V_org = V[kv_org];   // Origin vertex.
  #local V_dst = V[kv_dst];   // Destination vertex.
  #if (kv_org != kv_dst)
    #if (erad1 > 0)
      cylinder{ V_org, V_dst, erad1 texture{ tx } }
    #end
  #end
  #if (vrad1 > 0)
    #if (vrad1 > Vmaxrad[kv_org])
      sphere{ V_org, vrad1 texture{ tx } }
      #local Vmaxrad[kv_org] = vrad1;
    #end
    #if (vrad1 > Vmaxrad[kv_dst])
      sphere{ V_dst, vrad1 texture{ tx } }
      #local Vmaxrad[kv_dst] = vrad1;
    #end
  #end
#end
