#include "eixos.inc"

#macro fan_view(thing, show_axes, show_ground, view)
  // Sets the {camlight} parameters for the specific {view}
  // of object {thing}
  // Assumes {+X} is front, {+Y} is right.
  
  #local thmin = min_extent(thing);
  #debug concat("\n!! thmin = ", vstr(3, thmin, " ", 0,1), "\n")
  
  #local thmax = max_extent(thing);
  #debug concat("\n!! thmax = ", vstr(3, thmax, " ", 0,1), "\n")
  
  #local thdim = thmax - thmin;
  #debug concat("\n!! thdim = ", vstr(3, thdim, " ", 0,1), "\n")
  
  #local thrad = vlength(thdim)/2;
  #local thctr = (thmin + thmax)/2;
  
  #local scene = 
    union{
      object{ thing }
      
      #if (show_axes)
        object{ eixos(1.3*thrad, 0.005*thrad) }
      #end
      
      #if (show_ground)

        #declare tx_ground =
          texture{
            pigment{ checker color rgb < 0.600, 0.650, 0.750 >, color rgb < 0.800, 0.850, 0.900 > }
            finish{ diffuse 0.900 ambient 0.100 }
            scale 300.0
          }
        #local ground = box{ <-2000,-2000,-10>, <+2000,+2000,-0.1> texture{ tx_ground } }
        object{ ground 
          #if (thmin.z < 0)
            translate thmin.z*z
          #end
        }
      #end
      object{ nothing(1.23) }
      object{ nothing(1.33) }
    }
    
  object{ scene }

  #local centro_cena_normal = thctr + (0.1*thdim.z)*z;
  #local raio_cena_normal = 1.12*thrad;
  #local dist_camera_normal = 9*raio_cena_normal;
  #local camera_dir_Z_normal = 6.5;
  
  // sphere{ centro_cena_normal,10 texture{ fan_tx_debug } }

  #if (view = 0)
    // Full view of object from right front:
    #declare centro_cena = centro_cena_normal;
    #declare raio_cena = raio_cena_normal;
    #declare dir_camera = < 14.00, 12.00, camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 1)
    // Full view from right back:
    #declare centro_cena = centro_cena_normal;
    #declare raio_cena = raio_cena_normal;
    #declare dir_camera = < -14.00, 12.00, camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 2)
    // Full view from front left:
    #declare centro_cena = centro_cena_normal;
    #declare raio_cena = raio_cena_normal;
    #declare dir_camera = < 14.00, -12.00, camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 3)
    // Full view from near top:
    #declare centro_cena = centro_cena_normal;
    #declare raio_cena = raio_cena_normal;
    #declare dir_camera = < 2.00, 3.00, 12.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 4)
    // Full orthogonal view from X axis:
    #declare centro_cena = centro_cena_normal;
    #declare raio_cena = raio_cena_normal;
    #declare dir_camera = < 1, 0, 0 >;
    #declare dist_camera = 1000*raio_cena;
  #elseif (view = 5)
    // Top front right corner larger detail:
    #declare centro_cena = centro_cena_normal + thdim/2;
    #declare raio_cena = 250;
    #declare dir_camera = < 14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 6)
    // Top front right corner larger detail from back:
    #declare centro_cena = thctr + thdim/2;
    #declare raio_cena = 250;
    #declare dir_camera = < -14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 7)
    // Center front detail:
    #declare centro_cena = thctr + thdim.x/2*x;
    #declare raio_cena = 100;
    #declare dir_camera = < 14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 8)
    // Top right edge middle larger detail from back:
    #declare centro_cena = thctr + < 0, thdim.y/2, thdim.z/2 >;
    #declare raio_cena = 250;
    #declare dir_camera = < -14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 9)
    // Left edge middle frontal full height:
    #declare centro_cena = thctr + < 0, thdim.z/2 - thdim.y/2, 0 >;
    #declare raio_cena = 0.90*thdim.z;
    #declare dir_camera = < +14.00, 0.00, 0.00 >;
    #declare dist_camera = dist_camera_normal;
  #end
#end
