#declare slicing_num_faces = 80;
#declare slicing_num_edges = 270;
#declare slicing_num_vertices = 192;

#declare slicing_num_planes = 0;
#declare slicing_planes_Z_min = -1.00000;
#declare slicing_planes_Z_max = 1.00000;
#declare slicing_edge_radius = 0.2979185;
#declare slicing_vertex_radius = 0.7447962;

#macro slicing_vertices()
  #local Nv = 192;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 26.60254, 0.00000, -50.00000 >; // vp.0.0
  #local V[   2] = < 21.52190, 15.63658, -50.00000 >; // vp.1.0
  #local V[   3] = < 8.22064, 25.30052, -50.00000 >; // vp.2.0
  #local V[   4] = < -8.22064, 25.30052, -50.00000 >; // vp.3.0
  #local V[   5] = < -21.52190, 15.63658, -50.00000 >; // vp.4.0
  #local V[   6] = < -26.60254, 0.00000, -50.00000 >; // vp.5.0
  #local V[   7] = < -21.52190, -15.63658, -50.00000 >; // vp.6.0
  #local V[   8] = < -8.22064, -25.30052, -50.00000 >; // vp.7.0
  #local V[   9] = < 8.22064, -25.30052, -50.00000 >; // vp.8.0
  #local V[  10] = < 21.52190, -15.63658, -50.00000 >; // vp.9.0
  #local V[  11] = < 33.96926, 0.00000, -34.20202 >; // vp.0.1
  #local V[  12] = < 29.05812, 0.00000, -44.73400 >; // ve.0.0.0
  #local V[  13] = < 31.51368, 0.00000, -39.46800 >; // ve.0.0.1
  #local V[  14] = < 27.48172, 19.96664, -34.20202 >; // vp.1.1
  #local V[  15] = < 23.50850, 17.07994, -44.73400 >; // ve.1.0.0
  #local V[  16] = < 25.49510, 18.52328, -39.46800 >; // ve.1.0.1
  #local V[  17] = < 10.49708, 32.30668, -34.20202 >; // vp.2.1
  #local V[  18] = < 8.97946, 27.63590, -44.73400 >; // ve.2.0.0
  #local V[  19] = < 9.73826, 29.97130, -39.46800 >; // ve.2.0.1
  #local V[  20] = < -10.49708, 32.30668, -34.20202 >; // vp.3.1
  #local V[  21] = < -8.97946, 27.63590, -44.73400 >; // ve.3.0.0
  #local V[  22] = < -9.73826, 29.97130, -39.46800 >; // ve.3.0.1
  #local V[  23] = < -27.48172, 19.96664, -34.20202 >; // vp.4.1
  #local V[  24] = < -23.50850, 17.07994, -44.73400 >; // ve.4.0.0
  #local V[  25] = < -25.49510, 18.52328, -39.46800 >; // ve.4.0.1
  #local V[  26] = < -33.96926, 0.00000, -34.20202 >; // vp.5.1
  #local V[  27] = < -29.05812, 0.00000, -44.73400 >; // ve.5.0.0
  #local V[  28] = < -31.51368, 0.00000, -39.46800 >; // ve.5.0.1
  #local V[  29] = < -27.48172, -19.96664, -34.20202 >; // vp.6.1
  #local V[  30] = < -23.50850, -17.07994, -44.73400 >; // ve.6.0.0
  #local V[  31] = < -25.49510, -18.52328, -39.46800 >; // ve.6.0.1
  #local V[  32] = < -10.49708, -32.30668, -34.20202 >; // vp.7.1
  #local V[  33] = < -8.97946, -27.63590, -44.73400 >; // ve.7.0.0
  #local V[  34] = < -9.73826, -29.97130, -39.46800 >; // ve.7.0.1
  #local V[  35] = < 10.49708, -32.30668, -34.20202 >; // vp.8.1
  #local V[  36] = < 8.97946, -27.63590, -44.73400 >; // ve.8.0.0
  #local V[  37] = < 9.73826, -29.97130, -39.46800 >; // ve.8.0.1
  #local V[  38] = < 27.48172, -19.96664, -34.20202 >; // vp.9.1
  #local V[  39] = < 23.50850, -17.07994, -44.73400 >; // ve.9.0.0
  #local V[  40] = < 25.49510, -18.52328, -39.46800 >; // ve.9.0.1
  #local V[  41] = < 38.48078, 0.00000, -17.36482 >; // vp.0.2
  #local V[  42] = < 35.47310, 0.00000, -28.58962 >; // ve.0.1.0
  #local V[  43] = < 36.97694, 0.00000, -22.97722 >; // ve.0.1.1
  #local V[  44] = < 31.13160, 22.61844, -17.36482 >; // vp.1.2
  #local V[  45] = < 28.69834, 20.85058, -28.58962 >; // ve.1.1.0
  #local V[  46] = < 29.91498, 21.73450, -22.97722 >; // ve.1.1.1
  #local V[  47] = < 11.89122, 36.59740, -17.36482 >; // vp.2.2
  #local V[  48] = < 10.96180, 33.73692, -28.58962 >; // ve.2.1.0
  #local V[  49] = < 11.42650, 35.16716, -22.97722 >; // ve.2.1.1
  #local V[  50] = < -11.89122, 36.59740, -17.36482 >; // vp.3.2
  #local V[  51] = < -10.96180, 33.73692, -28.58962 >; // ve.3.1.0
  #local V[  52] = < -11.42650, 35.16716, -22.97722 >; // ve.3.1.1
  #local V[  53] = < -31.13160, 22.61844, -17.36482 >; // vp.4.2
  #local V[  54] = < -28.69834, 20.85058, -28.58962 >; // ve.4.1.0
  #local V[  55] = < -29.91498, 21.73450, -22.97722 >; // ve.4.1.1
  #local V[  56] = < -38.48078, 0.00000, -17.36482 >; // vp.5.2
  #local V[  57] = < -35.47310, 0.00000, -28.58962 >; // ve.5.1.0
  #local V[  58] = < -36.97694, 0.00000, -22.97722 >; // ve.5.1.1
  #local V[  59] = < -31.13160, -22.61844, -17.36482 >; // vp.6.2
  #local V[  60] = < -28.69834, -20.85058, -28.58962 >; // ve.6.1.0
  #local V[  61] = < -29.91498, -21.73450, -22.97722 >; // ve.6.1.1
  #local V[  62] = < -11.89122, -36.59740, -17.36482 >; // vp.7.2
  #local V[  63] = < -10.96180, -33.73692, -28.58962 >; // ve.7.1.0
  #local V[  64] = < -11.42650, -35.16716, -22.97722 >; // ve.7.1.1
  #local V[  65] = < 11.89122, -36.59740, -17.36482 >; // vp.8.2
  #local V[  66] = < 10.96180, -33.73692, -28.58962 >; // ve.8.1.0
  #local V[  67] = < 11.42650, -35.16716, -22.97722 >; // ve.8.1.1
  #local V[  68] = < 31.13160, -22.61844, -17.36482 >; // vp.9.2
  #local V[  69] = < 28.69834, -20.85058, -28.58962 >; // ve.9.1.0
  #local V[  70] = < 29.91498, -21.73450, -22.97722 >; // ve.9.1.1
  #local V[  71] = < 40.00000, 0.00000, 0.00000 >; // vp.0.3
  #local V[  72] = < 38.98718, 0.00000, -11.57654 >; // ve.0.2.0
  #local V[  73] = < 39.49360, 0.00000, -5.78828 >; // ve.0.2.1
  #local V[  74] = < 32.36068, 23.51142, 0.00000 >; // vp.1.3
  #local V[  75] = < 31.54130, 22.91610, -11.57654 >; // ve.1.2.0
  #local V[  76] = < 31.95098, 23.21376, -5.78828 >; // ve.1.2.1
  #local V[  77] = < 12.36068, 38.04226, 0.00000 >; // vp.2.3
  #local V[  78] = < 12.04770, 37.07902, -11.57654 >; // ve.2.2.0
  #local V[  79] = < 12.20420, 37.56064, -5.78828 >; // ve.2.2.1
  #local V[  80] = < -12.36068, 38.04226, 0.00000 >; // vp.3.3
  #local V[  81] = < -12.04770, 37.07902, -11.57654 >; // ve.3.2.0
  #local V[  82] = < -12.20420, 37.56064, -5.78828 >; // ve.3.2.1
  #local V[  83] = < -32.36068, 23.51142, 0.00000 >; // vp.4.3
  #local V[  84] = < -31.54130, 22.91610, -11.57654 >; // ve.4.2.0
  #local V[  85] = < -31.95098, 23.21376, -5.78828 >; // ve.4.2.1
  #local V[  86] = < -40.00000, 0.00000, 0.00000 >; // vp.5.3
  #local V[  87] = < -38.98718, 0.00000, -11.57654 >; // ve.5.2.0
  #local V[  88] = < -39.49360, 0.00000, -5.78828 >; // ve.5.2.1
  #local V[  89] = < -32.36068, -23.51142, 0.00000 >; // vp.6.3
  #local V[  90] = < -31.54130, -22.91610, -11.57654 >; // ve.6.2.0
  #local V[  91] = < -31.95098, -23.21376, -5.78828 >; // ve.6.2.1
  #local V[  92] = < -12.36068, -38.04226, 0.00000 >; // vp.7.3
  #local V[  93] = < -12.04770, -37.07902, -11.57654 >; // ve.7.2.0
  #local V[  94] = < -12.20420, -37.56064, -5.78828 >; // ve.7.2.1
  #local V[  95] = < 12.36068, -38.04226, 0.00000 >; // vp.8.3
  #local V[  96] = < 12.04770, -37.07902, -11.57654 >; // ve.8.2.0
  #local V[  97] = < 12.20420, -37.56064, -5.78828 >; // ve.8.2.1
  #local V[  98] = < 32.36068, -23.51142, 0.00000 >; // vp.9.3
  #local V[  99] = < 31.54130, -22.91610, -11.57654 >; // ve.9.2.0
  #local V[ 100] = < 31.95098, -23.21376, -5.78828 >; // ve.9.2.1
  #local V[ 101] = < 38.48078, 0.00000, 17.36482 >; // vp.0.4
  #local V[ 102] = < 39.49360, 0.00000, 5.78828 >; // ve.0.3.0
  #local V[ 103] = < 38.98718, 0.00000, 11.57654 >; // ve.0.3.1
  #local V[ 104] = < 31.13160, 22.61844, 17.36482 >; // vp.1.4
  #local V[ 105] = < 31.95098, 23.21376, 5.78828 >; // ve.1.3.0
  #local V[ 106] = < 31.54130, 22.91610, 11.57654 >; // ve.1.3.1
  #local V[ 107] = < 11.89122, 36.59740, 17.36482 >; // vp.2.4
  #local V[ 108] = < 12.20420, 37.56064, 5.78828 >; // ve.2.3.0
  #local V[ 109] = < 12.04770, 37.07902, 11.57654 >; // ve.2.3.1
  #local V[ 110] = < -11.89122, 36.59740, 17.36482 >; // vp.3.4
  #local V[ 111] = < -12.20420, 37.56064, 5.78828 >; // ve.3.3.0
  #local V[ 112] = < -12.04770, 37.07902, 11.57654 >; // ve.3.3.1
  #local V[ 113] = < -31.13160, 22.61844, 17.36482 >; // vp.4.4
  #local V[ 114] = < -31.95098, 23.21376, 5.78828 >; // ve.4.3.0
  #local V[ 115] = < -31.54130, 22.91610, 11.57654 >; // ve.4.3.1
  #local V[ 116] = < -38.48078, 0.00000, 17.36482 >; // vp.5.4
  #local V[ 117] = < -39.49360, 0.00000, 5.78828 >; // ve.5.3.0
  #local V[ 118] = < -38.98718, 0.00000, 11.57654 >; // ve.5.3.1
  #local V[ 119] = < -31.13160, -22.61844, 17.36482 >; // vp.6.4
  #local V[ 120] = < -31.95098, -23.21376, 5.78828 >; // ve.6.3.0
  #local V[ 121] = < -31.54130, -22.91610, 11.57654 >; // ve.6.3.1
  #local V[ 122] = < -11.89122, -36.59740, 17.36482 >; // vp.7.4
  #local V[ 123] = < -12.20420, -37.56064, 5.78828 >; // ve.7.3.0
  #local V[ 124] = < -12.04770, -37.07902, 11.57654 >; // ve.7.3.1
  #local V[ 125] = < 11.89122, -36.59740, 17.36482 >; // vp.8.4
  #local V[ 126] = < 12.20420, -37.56064, 5.78828 >; // ve.8.3.0
  #local V[ 127] = < 12.04770, -37.07902, 11.57654 >; // ve.8.3.1
  #local V[ 128] = < 31.13160, -22.61844, 17.36482 >; // vp.9.4
  #local V[ 129] = < 31.95098, -23.21376, 5.78828 >; // ve.9.3.0
  #local V[ 130] = < 31.54130, -22.91610, 11.57654 >; // ve.9.3.1
  #local V[ 131] = < 33.96926, 0.00000, 34.20202 >; // vp.0.5
  #local V[ 132] = < 36.97694, 0.00000, 22.97722 >; // ve.0.4.0
  #local V[ 133] = < 35.47310, 0.00000, 28.58962 >; // ve.0.4.1
  #local V[ 134] = < 27.48172, 19.96664, 34.20202 >; // vp.1.5
  #local V[ 135] = < 29.91498, 21.73450, 22.97722 >; // ve.1.4.0
  #local V[ 136] = < 28.69834, 20.85056, 28.58962 >; // ve.1.4.1
  #local V[ 137] = < 10.49708, 32.30668, 34.20202 >; // vp.2.5
  #local V[ 138] = < 11.42650, 35.16716, 22.97722 >; // ve.2.4.0
  #local V[ 139] = < 10.96180, 33.73692, 28.58962 >; // ve.2.4.1
  #local V[ 140] = < -10.49708, 32.30668, 34.20202 >; // vp.3.5
  #local V[ 141] = < -11.42650, 35.16716, 22.97722 >; // ve.3.4.0
  #local V[ 142] = < -10.96180, 33.73692, 28.58962 >; // ve.3.4.1
  #local V[ 143] = < -27.48172, 19.96664, 34.20202 >; // vp.4.5
  #local V[ 144] = < -29.91498, 21.73450, 22.97722 >; // ve.4.4.0
  #local V[ 145] = < -28.69834, 20.85056, 28.58962 >; // ve.4.4.1
  #local V[ 146] = < -33.96926, 0.00000, 34.20202 >; // vp.5.5
  #local V[ 147] = < -36.97694, 0.00000, 22.97722 >; // ve.5.4.0
  #local V[ 148] = < -35.47310, 0.00000, 28.58962 >; // ve.5.4.1
  #local V[ 149] = < -27.48172, -19.96664, 34.20202 >; // vp.6.5
  #local V[ 150] = < -29.91498, -21.73450, 22.97722 >; // ve.6.4.0
  #local V[ 151] = < -28.69834, -20.85056, 28.58962 >; // ve.6.4.1
  #local V[ 152] = < -10.49708, -32.30668, 34.20202 >; // vp.7.5
  #local V[ 153] = < -11.42650, -35.16716, 22.97722 >; // ve.7.4.0
  #local V[ 154] = < -10.96180, -33.73692, 28.58962 >; // ve.7.4.1
  #local V[ 155] = < 10.49708, -32.30668, 34.20202 >; // vp.8.5
  #local V[ 156] = < 11.42650, -35.16716, 22.97722 >; // ve.8.4.0
  #local V[ 157] = < 10.96180, -33.73692, 28.58962 >; // ve.8.4.1
  #local V[ 158] = < 27.48172, -19.96664, 34.20202 >; // vp.9.5
  #local V[ 159] = < 29.91498, -21.73450, 22.97722 >; // ve.9.4.0
  #local V[ 160] = < 28.69834, -20.85056, 28.58962 >; // ve.9.4.1
  #local V[ 161] = < 26.60254, 0.00000, 50.00000 >; // vp.0.6
  #local V[ 162] = < 31.51368, 0.00000, 39.46802 >; // ve.0.5.0
  #local V[ 163] = < 29.05812, 0.00000, 44.73400 >; // ve.0.5.1
  #local V[ 164] = < 21.52190, 15.63658, 50.00000 >; // vp.1.6
  #local V[ 165] = < 25.49512, 18.52328, 39.46802 >; // ve.1.5.0
  #local V[ 166] = < 23.50852, 17.07994, 44.73400 >; // ve.1.5.1
  #local V[ 167] = < 8.22064, 25.30052, 50.00000 >; // vp.2.6
  #local V[ 168] = < 9.73826, 29.97130, 39.46802 >; // ve.2.5.0
  #local V[ 169] = < 8.97946, 27.63590, 44.73400 >; // ve.2.5.1
  #local V[ 170] = < -8.22064, 25.30052, 50.00000 >; // vp.3.6
  #local V[ 171] = < -9.73826, 29.97130, 39.46802 >; // ve.3.5.0
  #local V[ 172] = < -8.97946, 27.63590, 44.73400 >; // ve.3.5.1
  #local V[ 173] = < -21.52190, 15.63658, 50.00000 >; // vp.4.6
  #local V[ 174] = < -25.49512, 18.52328, 39.46802 >; // ve.4.5.0
  #local V[ 175] = < -23.50852, 17.07994, 44.73400 >; // ve.4.5.1
  #local V[ 176] = < -26.60254, 0.00000, 50.00000 >; // vp.5.6
  #local V[ 177] = < -31.51368, 0.00000, 39.46802 >; // ve.5.5.0
  #local V[ 178] = < -29.05812, 0.00000, 44.73400 >; // ve.5.5.1
  #local V[ 179] = < -21.52190, -15.63658, 50.00000 >; // vp.6.6
  #local V[ 180] = < -25.49512, -18.52328, 39.46802 >; // ve.6.5.0
  #local V[ 181] = < -23.50852, -17.07994, 44.73400 >; // ve.6.5.1
  #local V[ 182] = < -8.22064, -25.30052, 50.00000 >; // vp.7.6
  #local V[ 183] = < -9.73826, -29.97130, 39.46802 >; // ve.7.5.0
  #local V[ 184] = < -8.97946, -27.63590, 44.73400 >; // ve.7.5.1
  #local V[ 185] = < 8.22064, -25.30052, 50.00000 >; // vp.8.6
  #local V[ 186] = < 9.73826, -29.97130, 39.46802 >; // ve.8.5.0
  #local V[ 187] = < 8.97946, -27.63590, 44.73400 >; // ve.8.5.1
  #local V[ 188] = < 21.52190, -15.63658, 50.00000 >; // vp.9.6
  #local V[ 189] = < 25.49512, -18.52328, 39.46802 >; // ve.9.5.0
  #local V[ 190] = < 23.50852, -17.07994, 44.73400 >; // ve.9.5.1
  #local V[ 191] = < 0.00000, 0.00000, -50.00000 >; // vc.0
  #local V[ 192] = < 0.00000, 0.00000, 50.00000 >; // vc.1
  V
#end


#macro slicing_edges()
  #local Ne = 270;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   0 original object edge.
  //   1 refinement (triangulation, monotonization, etc) edge.
  //   2 ghost edge.
  // 
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 2, 0 >; // vp.0.0--vp.1.0:fv.0.0;
  #local E[   2] = < 2, 15, 0 >; // vp.1.0--ve.1.0.0:fv.0.0;
  #local E[   3] = < 15, 16, 0 >; // ve.1.0.0--ve.1.0.1:fv.0.0;
  #local E[   4] = < 11, 13, 0 >; // vp.0.1--ve.0.0.1:fv.0.0;
  #local E[   5] = < 11, 14, 0 >; // vp.0.1--vp.1.1:fv.0.1;
  #local E[   6] = < 14, 45, 0 >; // vp.1.1--ve.1.1.0:fv.0.1;
  #local E[   7] = < 45, 46, 0 >; // ve.1.1.0--ve.1.1.1:fv.0.1;
  #local E[   8] = < 41, 43, 0 >; // vp.0.2--ve.0.1.1:fv.0.1;
  #local E[   9] = < 41, 44, 0 >; // vp.0.2--vp.1.2:fv.0.2;
  #local E[  10] = < 44, 75, 0 >; // vp.1.2--ve.1.2.0:fv.0.2;
  #local E[  11] = < 75, 76, 0 >; // ve.1.2.0--ve.1.2.1:fv.0.2;
  #local E[  12] = < 71, 73, 0 >; // vp.0.3--ve.0.2.1:fv.0.2;
  #local E[  13] = < 71, 74, 0 >; // vp.0.3--vp.1.3:fv.0.3;
  #local E[  14] = < 74, 105, 0 >; // vp.1.3--ve.1.3.0:fv.0.3;
  #local E[  15] = < 105, 106, 0 >; // ve.1.3.0--ve.1.3.1:fv.0.3;
  #local E[  16] = < 101, 103, 0 >; // vp.0.4--ve.0.3.1:fv.0.3;
  #local E[  17] = < 101, 104, 0 >; // vp.0.4--vp.1.4:fv.0.4;
  #local E[  18] = < 104, 135, 0 >; // vp.1.4--ve.1.4.0:fv.0.4;
  #local E[  19] = < 135, 136, 0 >; // ve.1.4.0--ve.1.4.1:fv.0.4;
  #local E[  20] = < 131, 133, 0 >; // vp.0.5--ve.0.4.1:fv.0.4;
  #local E[  21] = < 131, 134, 0 >; // vp.0.5--vp.1.5:fv.0.5;
  #local E[  22] = < 134, 165, 0 >; // vp.1.5--ve.1.5.0:fv.0.5;
  #local E[  23] = < 165, 166, 0 >; // ve.1.5.0--ve.1.5.1:fv.0.5;
  #local E[  24] = < 161, 163, 0 >; // vp.0.6--ve.0.5.1:fv.0.5;
  #local E[  25] = < 1, 191, 0 >; // vp.0.0--vc.0:fh.0.0;
  #local E[  26] = < 161, 164, 0 >; // vp.0.6--vp.1.6:fh.0.1;
  #local E[  27] = < 164, 192, 0 >; // vp.1.6--vc.1:fh.0.1;
  #local E[  28] = < 2, 3, 0 >; // vp.1.0--vp.2.0:fv.1.0;
  #local E[  29] = < 3, 18, 0 >; // vp.2.0--ve.2.0.0:fv.1.0;
  #local E[  30] = < 18, 19, 0 >; // ve.2.0.0--ve.2.0.1:fv.1.0;
  #local E[  31] = < 14, 16, 0 >; // vp.1.1--ve.1.0.1:fv.1.0;
  #local E[  32] = < 14, 17, 0 >; // vp.1.1--vp.2.1:fv.1.1;
  #local E[  33] = < 17, 48, 0 >; // vp.2.1--ve.2.1.0:fv.1.1;
  #local E[  34] = < 48, 49, 0 >; // ve.2.1.0--ve.2.1.1:fv.1.1;
  #local E[  35] = < 44, 46, 0 >; // vp.1.2--ve.1.1.1:fv.1.1;
  #local E[  36] = < 44, 47, 0 >; // vp.1.2--vp.2.2:fv.1.2;
  #local E[  37] = < 47, 78, 0 >; // vp.2.2--ve.2.2.0:fv.1.2;
  #local E[  38] = < 78, 79, 0 >; // ve.2.2.0--ve.2.2.1:fv.1.2;
  #local E[  39] = < 74, 76, 0 >; // vp.1.3--ve.1.2.1:fv.1.2;
  #local E[  40] = < 74, 77, 0 >; // vp.1.3--vp.2.3:fv.1.3;
  #local E[  41] = < 77, 108, 0 >; // vp.2.3--ve.2.3.0:fv.1.3;
  #local E[  42] = < 108, 109, 0 >; // ve.2.3.0--ve.2.3.1:fv.1.3;
  #local E[  43] = < 104, 106, 0 >; // vp.1.4--ve.1.3.1:fv.1.3;
  #local E[  44] = < 104, 107, 0 >; // vp.1.4--vp.2.4:fv.1.4;
  #local E[  45] = < 107, 138, 0 >; // vp.2.4--ve.2.4.0:fv.1.4;
  #local E[  46] = < 138, 139, 0 >; // ve.2.4.0--ve.2.4.1:fv.1.4;
  #local E[  47] = < 134, 136, 0 >; // vp.1.5--ve.1.4.1:fv.1.4;
  #local E[  48] = < 134, 137, 0 >; // vp.1.5--vp.2.5:fv.1.5;
  #local E[  49] = < 137, 168, 0 >; // vp.2.5--ve.2.5.0:fv.1.5;
  #local E[  50] = < 168, 169, 0 >; // ve.2.5.0--ve.2.5.1:fv.1.5;
  #local E[  51] = < 164, 166, 0 >; // vp.1.6--ve.1.5.1:fv.1.5;
  #local E[  52] = < 2, 191, 0 >; // vp.1.0--vc.0:fh.1.0;
  #local E[  53] = < 164, 167, 0 >; // vp.1.6--vp.2.6:fh.1.1;
  #local E[  54] = < 167, 192, 0 >; // vp.2.6--vc.1:fh.1.1;
  #local E[  55] = < 3, 4, 0 >; // vp.2.0--vp.3.0:fv.2.0;
  #local E[  56] = < 4, 21, 0 >; // vp.3.0--ve.3.0.0:fv.2.0;
  #local E[  57] = < 21, 22, 0 >; // ve.3.0.0--ve.3.0.1:fv.2.0;
  #local E[  58] = < 17, 19, 0 >; // vp.2.1--ve.2.0.1:fv.2.0;
  #local E[  59] = < 17, 20, 0 >; // vp.2.1--vp.3.1:fv.2.1;
  #local E[  60] = < 20, 51, 0 >; // vp.3.1--ve.3.1.0:fv.2.1;
  #local E[  61] = < 51, 52, 0 >; // ve.3.1.0--ve.3.1.1:fv.2.1;
  #local E[  62] = < 47, 49, 0 >; // vp.2.2--ve.2.1.1:fv.2.1;
  #local E[  63] = < 47, 50, 0 >; // vp.2.2--vp.3.2:fv.2.2;
  #local E[  64] = < 50, 81, 0 >; // vp.3.2--ve.3.2.0:fv.2.2;
  #local E[  65] = < 81, 82, 0 >; // ve.3.2.0--ve.3.2.1:fv.2.2;
  #local E[  66] = < 77, 79, 0 >; // vp.2.3--ve.2.2.1:fv.2.2;
  #local E[  67] = < 77, 80, 0 >; // vp.2.3--vp.3.3:fv.2.3;
  #local E[  68] = < 80, 111, 0 >; // vp.3.3--ve.3.3.0:fv.2.3;
  #local E[  69] = < 111, 112, 0 >; // ve.3.3.0--ve.3.3.1:fv.2.3;
  #local E[  70] = < 107, 109, 0 >; // vp.2.4--ve.2.3.1:fv.2.3;
  #local E[  71] = < 107, 110, 0 >; // vp.2.4--vp.3.4:fv.2.4;
  #local E[  72] = < 110, 141, 0 >; // vp.3.4--ve.3.4.0:fv.2.4;
  #local E[  73] = < 141, 142, 0 >; // ve.3.4.0--ve.3.4.1:fv.2.4;
  #local E[  74] = < 137, 139, 0 >; // vp.2.5--ve.2.4.1:fv.2.4;
  #local E[  75] = < 137, 140, 0 >; // vp.2.5--vp.3.5:fv.2.5;
  #local E[  76] = < 140, 171, 0 >; // vp.3.5--ve.3.5.0:fv.2.5;
  #local E[  77] = < 171, 172, 0 >; // ve.3.5.0--ve.3.5.1:fv.2.5;
  #local E[  78] = < 167, 169, 0 >; // vp.2.6--ve.2.5.1:fv.2.5;
  #local E[  79] = < 3, 191, 0 >; // vp.2.0--vc.0:fh.2.0;
  #local E[  80] = < 167, 170, 0 >; // vp.2.6--vp.3.6:fh.2.1;
  #local E[  81] = < 170, 192, 0 >; // vp.3.6--vc.1:fh.2.1;
  #local E[  82] = < 4, 5, 0 >; // vp.3.0--vp.4.0:fv.3.0;
  #local E[  83] = < 5, 24, 0 >; // vp.4.0--ve.4.0.0:fv.3.0;
  #local E[  84] = < 24, 25, 0 >; // ve.4.0.0--ve.4.0.1:fv.3.0;
  #local E[  85] = < 20, 22, 0 >; // vp.3.1--ve.3.0.1:fv.3.0;
  #local E[  86] = < 20, 23, 0 >; // vp.3.1--vp.4.1:fv.3.1;
  #local E[  87] = < 23, 54, 0 >; // vp.4.1--ve.4.1.0:fv.3.1;
  #local E[  88] = < 54, 55, 0 >; // ve.4.1.0--ve.4.1.1:fv.3.1;
  #local E[  89] = < 50, 52, 0 >; // vp.3.2--ve.3.1.1:fv.3.1;
  #local E[  90] = < 50, 53, 0 >; // vp.3.2--vp.4.2:fv.3.2;
  #local E[  91] = < 53, 84, 0 >; // vp.4.2--ve.4.2.0:fv.3.2;
  #local E[  92] = < 84, 85, 0 >; // ve.4.2.0--ve.4.2.1:fv.3.2;
  #local E[  93] = < 80, 82, 0 >; // vp.3.3--ve.3.2.1:fv.3.2;
  #local E[  94] = < 80, 83, 0 >; // vp.3.3--vp.4.3:fv.3.3;
  #local E[  95] = < 83, 114, 0 >; // vp.4.3--ve.4.3.0:fv.3.3;
  #local E[  96] = < 114, 115, 0 >; // ve.4.3.0--ve.4.3.1:fv.3.3;
  #local E[  97] = < 110, 112, 0 >; // vp.3.4--ve.3.3.1:fv.3.3;
  #local E[  98] = < 110, 113, 0 >; // vp.3.4--vp.4.4:fv.3.4;
  #local E[  99] = < 113, 144, 0 >; // vp.4.4--ve.4.4.0:fv.3.4;
  #local E[ 100] = < 144, 145, 0 >; // ve.4.4.0--ve.4.4.1:fv.3.4;
  #local E[ 101] = < 140, 142, 0 >; // vp.3.5--ve.3.4.1:fv.3.4;
  #local E[ 102] = < 140, 143, 0 >; // vp.3.5--vp.4.5:fv.3.5;
  #local E[ 103] = < 143, 174, 0 >; // vp.4.5--ve.4.5.0:fv.3.5;
  #local E[ 104] = < 174, 175, 0 >; // ve.4.5.0--ve.4.5.1:fv.3.5;
  #local E[ 105] = < 170, 172, 0 >; // vp.3.6--ve.3.5.1:fv.3.5;
  #local E[ 106] = < 4, 191, 0 >; // vp.3.0--vc.0:fh.3.0;
  #local E[ 107] = < 170, 173, 0 >; // vp.3.6--vp.4.6:fh.3.1;
  #local E[ 108] = < 173, 192, 0 >; // vp.4.6--vc.1:fh.3.1;
  #local E[ 109] = < 5, 6, 0 >; // vp.4.0--vp.5.0:fv.4.0;
  #local E[ 110] = < 6, 27, 0 >; // vp.5.0--ve.5.0.0:fv.4.0;
  #local E[ 111] = < 27, 28, 0 >; // ve.5.0.0--ve.5.0.1:fv.4.0;
  #local E[ 112] = < 23, 25, 0 >; // vp.4.1--ve.4.0.1:fv.4.0;
  #local E[ 113] = < 23, 26, 0 >; // vp.4.1--vp.5.1:fv.4.1;
  #local E[ 114] = < 26, 57, 0 >; // vp.5.1--ve.5.1.0:fv.4.1;
  #local E[ 115] = < 57, 58, 0 >; // ve.5.1.0--ve.5.1.1:fv.4.1;
  #local E[ 116] = < 53, 55, 0 >; // vp.4.2--ve.4.1.1:fv.4.1;
  #local E[ 117] = < 53, 56, 0 >; // vp.4.2--vp.5.2:fv.4.2;
  #local E[ 118] = < 56, 87, 0 >; // vp.5.2--ve.5.2.0:fv.4.2;
  #local E[ 119] = < 87, 88, 0 >; // ve.5.2.0--ve.5.2.1:fv.4.2;
  #local E[ 120] = < 83, 85, 0 >; // vp.4.3--ve.4.2.1:fv.4.2;
  #local E[ 121] = < 83, 86, 0 >; // vp.4.3--vp.5.3:fv.4.3;
  #local E[ 122] = < 86, 117, 0 >; // vp.5.3--ve.5.3.0:fv.4.3;
  #local E[ 123] = < 117, 118, 0 >; // ve.5.3.0--ve.5.3.1:fv.4.3;
  #local E[ 124] = < 113, 115, 0 >; // vp.4.4--ve.4.3.1:fv.4.3;
  #local E[ 125] = < 113, 116, 0 >; // vp.4.4--vp.5.4:fv.4.4;
  #local E[ 126] = < 116, 147, 0 >; // vp.5.4--ve.5.4.0:fv.4.4;
  #local E[ 127] = < 147, 148, 0 >; // ve.5.4.0--ve.5.4.1:fv.4.4;
  #local E[ 128] = < 143, 145, 0 >; // vp.4.5--ve.4.4.1:fv.4.4;
  #local E[ 129] = < 143, 146, 0 >; // vp.4.5--vp.5.5:fv.4.5;
  #local E[ 130] = < 146, 177, 0 >; // vp.5.5--ve.5.5.0:fv.4.5;
  #local E[ 131] = < 177, 178, 0 >; // ve.5.5.0--ve.5.5.1:fv.4.5;
  #local E[ 132] = < 173, 175, 0 >; // vp.4.6--ve.4.5.1:fv.4.5;
  #local E[ 133] = < 5, 191, 0 >; // vp.4.0--vc.0:fh.4.0;
  #local E[ 134] = < 173, 176, 0 >; // vp.4.6--vp.5.6:fh.4.1;
  #local E[ 135] = < 176, 192, 0 >; // vp.5.6--vc.1:fh.4.1;
  #local E[ 136] = < 6, 7, 0 >; // vp.5.0--vp.6.0:fv.5.0;
  #local E[ 137] = < 7, 30, 0 >; // vp.6.0--ve.6.0.0:fv.5.0;
  #local E[ 138] = < 30, 31, 0 >; // ve.6.0.0--ve.6.0.1:fv.5.0;
  #local E[ 139] = < 26, 28, 0 >; // vp.5.1--ve.5.0.1:fv.5.0;
  #local E[ 140] = < 26, 29, 0 >; // vp.5.1--vp.6.1:fv.5.1;
  #local E[ 141] = < 29, 60, 0 >; // vp.6.1--ve.6.1.0:fv.5.1;
  #local E[ 142] = < 60, 61, 0 >; // ve.6.1.0--ve.6.1.1:fv.5.1;
  #local E[ 143] = < 56, 58, 0 >; // vp.5.2--ve.5.1.1:fv.5.1;
  #local E[ 144] = < 56, 59, 0 >; // vp.5.2--vp.6.2:fv.5.2;
  #local E[ 145] = < 59, 90, 0 >; // vp.6.2--ve.6.2.0:fv.5.2;
  #local E[ 146] = < 90, 91, 0 >; // ve.6.2.0--ve.6.2.1:fv.5.2;
  #local E[ 147] = < 86, 88, 0 >; // vp.5.3--ve.5.2.1:fv.5.2;
  #local E[ 148] = < 86, 89, 0 >; // vp.5.3--vp.6.3:fv.5.3;
  #local E[ 149] = < 89, 120, 0 >; // vp.6.3--ve.6.3.0:fv.5.3;
  #local E[ 150] = < 120, 121, 0 >; // ve.6.3.0--ve.6.3.1:fv.5.3;
  #local E[ 151] = < 116, 118, 0 >; // vp.5.4--ve.5.3.1:fv.5.3;
  #local E[ 152] = < 116, 119, 0 >; // vp.5.4--vp.6.4:fv.5.4;
  #local E[ 153] = < 119, 150, 0 >; // vp.6.4--ve.6.4.0:fv.5.4;
  #local E[ 154] = < 150, 151, 0 >; // ve.6.4.0--ve.6.4.1:fv.5.4;
  #local E[ 155] = < 146, 148, 0 >; // vp.5.5--ve.5.4.1:fv.5.4;
  #local E[ 156] = < 146, 149, 0 >; // vp.5.5--vp.6.5:fv.5.5;
  #local E[ 157] = < 149, 180, 0 >; // vp.6.5--ve.6.5.0:fv.5.5;
  #local E[ 158] = < 180, 181, 0 >; // ve.6.5.0--ve.6.5.1:fv.5.5;
  #local E[ 159] = < 176, 178, 0 >; // vp.5.6--ve.5.5.1:fv.5.5;
  #local E[ 160] = < 6, 191, 0 >; // vp.5.0--vc.0:fh.5.0;
  #local E[ 161] = < 176, 179, 0 >; // vp.5.6--vp.6.6:fh.5.1;
  #local E[ 162] = < 179, 192, 0 >; // vp.6.6--vc.1:fh.5.1;
  #local E[ 163] = < 7, 8, 0 >; // vp.6.0--vp.7.0:fv.6.0;
  #local E[ 164] = < 8, 33, 0 >; // vp.7.0--ve.7.0.0:fv.6.0;
  #local E[ 165] = < 33, 34, 0 >; // ve.7.0.0--ve.7.0.1:fv.6.0;
  #local E[ 166] = < 29, 31, 0 >; // vp.6.1--ve.6.0.1:fv.6.0;
  #local E[ 167] = < 29, 32, 0 >; // vp.6.1--vp.7.1:fv.6.1;
  #local E[ 168] = < 32, 63, 0 >; // vp.7.1--ve.7.1.0:fv.6.1;
  #local E[ 169] = < 63, 64, 0 >; // ve.7.1.0--ve.7.1.1:fv.6.1;
  #local E[ 170] = < 59, 61, 0 >; // vp.6.2--ve.6.1.1:fv.6.1;
  #local E[ 171] = < 59, 62, 0 >; // vp.6.2--vp.7.2:fv.6.2;
  #local E[ 172] = < 62, 93, 0 >; // vp.7.2--ve.7.2.0:fv.6.2;
  #local E[ 173] = < 93, 94, 0 >; // ve.7.2.0--ve.7.2.1:fv.6.2;
  #local E[ 174] = < 89, 91, 0 >; // vp.6.3--ve.6.2.1:fv.6.2;
  #local E[ 175] = < 89, 92, 0 >; // vp.6.3--vp.7.3:fv.6.3;
  #local E[ 176] = < 92, 123, 0 >; // vp.7.3--ve.7.3.0:fv.6.3;
  #local E[ 177] = < 123, 124, 0 >; // ve.7.3.0--ve.7.3.1:fv.6.3;
  #local E[ 178] = < 119, 121, 0 >; // vp.6.4--ve.6.3.1:fv.6.3;
  #local E[ 179] = < 119, 122, 0 >; // vp.6.4--vp.7.4:fv.6.4;
  #local E[ 180] = < 122, 153, 0 >; // vp.7.4--ve.7.4.0:fv.6.4;
  #local E[ 181] = < 153, 154, 0 >; // ve.7.4.0--ve.7.4.1:fv.6.4;
  #local E[ 182] = < 149, 151, 0 >; // vp.6.5--ve.6.4.1:fv.6.4;
  #local E[ 183] = < 149, 152, 0 >; // vp.6.5--vp.7.5:fv.6.5;
  #local E[ 184] = < 152, 183, 0 >; // vp.7.5--ve.7.5.0:fv.6.5;
  #local E[ 185] = < 183, 184, 0 >; // ve.7.5.0--ve.7.5.1:fv.6.5;
  #local E[ 186] = < 179, 181, 0 >; // vp.6.6--ve.6.5.1:fv.6.5;
  #local E[ 187] = < 7, 191, 0 >; // vp.6.0--vc.0:fh.6.0;
  #local E[ 188] = < 179, 182, 0 >; // vp.6.6--vp.7.6:fh.6.1;
  #local E[ 189] = < 182, 192, 0 >; // vp.7.6--vc.1:fh.6.1;
  #local E[ 190] = < 8, 9, 0 >; // vp.7.0--vp.8.0:fv.7.0;
  #local E[ 191] = < 9, 36, 0 >; // vp.8.0--ve.8.0.0:fv.7.0;
  #local E[ 192] = < 36, 37, 0 >; // ve.8.0.0--ve.8.0.1:fv.7.0;
  #local E[ 193] = < 32, 34, 0 >; // vp.7.1--ve.7.0.1:fv.7.0;
  #local E[ 194] = < 32, 35, 0 >; // vp.7.1--vp.8.1:fv.7.1;
  #local E[ 195] = < 35, 66, 0 >; // vp.8.1--ve.8.1.0:fv.7.1;
  #local E[ 196] = < 66, 67, 0 >; // ve.8.1.0--ve.8.1.1:fv.7.1;
  #local E[ 197] = < 62, 64, 0 >; // vp.7.2--ve.7.1.1:fv.7.1;
  #local E[ 198] = < 62, 65, 0 >; // vp.7.2--vp.8.2:fv.7.2;
  #local E[ 199] = < 65, 96, 0 >; // vp.8.2--ve.8.2.0:fv.7.2;
  #local E[ 200] = < 96, 97, 0 >; // ve.8.2.0--ve.8.2.1:fv.7.2;
  #local E[ 201] = < 92, 94, 0 >; // vp.7.3--ve.7.2.1:fv.7.2;
  #local E[ 202] = < 92, 95, 0 >; // vp.7.3--vp.8.3:fv.7.3;
  #local E[ 203] = < 95, 126, 0 >; // vp.8.3--ve.8.3.0:fv.7.3;
  #local E[ 204] = < 126, 127, 0 >; // ve.8.3.0--ve.8.3.1:fv.7.3;
  #local E[ 205] = < 122, 124, 0 >; // vp.7.4--ve.7.3.1:fv.7.3;
  #local E[ 206] = < 122, 125, 0 >; // vp.7.4--vp.8.4:fv.7.4;
  #local E[ 207] = < 125, 156, 0 >; // vp.8.4--ve.8.4.0:fv.7.4;
  #local E[ 208] = < 156, 157, 0 >; // ve.8.4.0--ve.8.4.1:fv.7.4;
  #local E[ 209] = < 152, 154, 0 >; // vp.7.5--ve.7.4.1:fv.7.4;
  #local E[ 210] = < 152, 155, 0 >; // vp.7.5--vp.8.5:fv.7.5;
  #local E[ 211] = < 155, 186, 0 >; // vp.8.5--ve.8.5.0:fv.7.5;
  #local E[ 212] = < 186, 187, 0 >; // ve.8.5.0--ve.8.5.1:fv.7.5;
  #local E[ 213] = < 182, 184, 0 >; // vp.7.6--ve.7.5.1:fv.7.5;
  #local E[ 214] = < 8, 191, 0 >; // vp.7.0--vc.0:fh.7.0;
  #local E[ 215] = < 182, 185, 0 >; // vp.7.6--vp.8.6:fh.7.1;
  #local E[ 216] = < 185, 192, 0 >; // vp.8.6--vc.1:fh.7.1;
  #local E[ 217] = < 9, 10, 0 >; // vp.8.0--vp.9.0:fv.8.0;
  #local E[ 218] = < 10, 39, 0 >; // vp.9.0--ve.9.0.0:fv.8.0;
  #local E[ 219] = < 39, 40, 0 >; // ve.9.0.0--ve.9.0.1:fv.8.0;
  #local E[ 220] = < 35, 37, 0 >; // vp.8.1--ve.8.0.1:fv.8.0;
  #local E[ 221] = < 35, 38, 0 >; // vp.8.1--vp.9.1:fv.8.1;
  #local E[ 222] = < 38, 69, 0 >; // vp.9.1--ve.9.1.0:fv.8.1;
  #local E[ 223] = < 69, 70, 0 >; // ve.9.1.0--ve.9.1.1:fv.8.1;
  #local E[ 224] = < 65, 67, 0 >; // vp.8.2--ve.8.1.1:fv.8.1;
  #local E[ 225] = < 65, 68, 0 >; // vp.8.2--vp.9.2:fv.8.2;
  #local E[ 226] = < 68, 99, 0 >; // vp.9.2--ve.9.2.0:fv.8.2;
  #local E[ 227] = < 99, 100, 0 >; // ve.9.2.0--ve.9.2.1:fv.8.2;
  #local E[ 228] = < 95, 97, 0 >; // vp.8.3--ve.8.2.1:fv.8.2;
  #local E[ 229] = < 95, 98, 0 >; // vp.8.3--vp.9.3:fv.8.3;
  #local E[ 230] = < 98, 129, 0 >; // vp.9.3--ve.9.3.0:fv.8.3;
  #local E[ 231] = < 129, 130, 0 >; // ve.9.3.0--ve.9.3.1:fv.8.3;
  #local E[ 232] = < 125, 127, 0 >; // vp.8.4--ve.8.3.1:fv.8.3;
  #local E[ 233] = < 125, 128, 0 >; // vp.8.4--vp.9.4:fv.8.4;
  #local E[ 234] = < 128, 159, 0 >; // vp.9.4--ve.9.4.0:fv.8.4;
  #local E[ 235] = < 159, 160, 0 >; // ve.9.4.0--ve.9.4.1:fv.8.4;
  #local E[ 236] = < 155, 157, 0 >; // vp.8.5--ve.8.4.1:fv.8.4;
  #local E[ 237] = < 155, 158, 0 >; // vp.8.5--vp.9.5:fv.8.5;
  #local E[ 238] = < 158, 189, 0 >; // vp.9.5--ve.9.5.0:fv.8.5;
  #local E[ 239] = < 189, 190, 0 >; // ve.9.5.0--ve.9.5.1:fv.8.5;
  #local E[ 240] = < 185, 187, 0 >; // vp.8.6--ve.8.5.1:fv.8.5;
  #local E[ 241] = < 9, 191, 0 >; // vp.8.0--vc.0:fh.8.0;
  #local E[ 242] = < 185, 188, 0 >; // vp.8.6--vp.9.6:fh.8.1;
  #local E[ 243] = < 188, 192, 0 >; // vp.9.6--vc.1:fh.8.1;
  #local E[ 244] = < 1, 12, 0 >; // vp.0.0--ve.0.0.0:fv.9.0;
  #local E[ 245] = < 12, 13, 0 >; // ve.0.0.0--ve.0.0.1:fv.9.0;
  #local E[ 246] = < 11, 38, 0 >; // vp.0.1--vp.9.1:fv.9.0;
  #local E[ 247] = < 38, 40, 0 >; // vp.9.1--ve.9.0.1:fv.9.0;
  #local E[ 248] = < 11, 42, 0 >; // vp.0.1--ve.0.1.0:fv.9.1;
  #local E[ 249] = < 42, 43, 0 >; // ve.0.1.0--ve.0.1.1:fv.9.1;
  #local E[ 250] = < 41, 68, 0 >; // vp.0.2--vp.9.2:fv.9.1;
  #local E[ 251] = < 68, 70, 0 >; // vp.9.2--ve.9.1.1:fv.9.1;
  #local E[ 252] = < 41, 72, 0 >; // vp.0.2--ve.0.2.0:fv.9.2;
  #local E[ 253] = < 72, 73, 0 >; // ve.0.2.0--ve.0.2.1:fv.9.2;
  #local E[ 254] = < 71, 98, 0 >; // vp.0.3--vp.9.3:fv.9.2;
  #local E[ 255] = < 98, 100, 0 >; // vp.9.3--ve.9.2.1:fv.9.2;
  #local E[ 256] = < 71, 102, 0 >; // vp.0.3--ve.0.3.0:fv.9.3;
  #local E[ 257] = < 102, 103, 0 >; // ve.0.3.0--ve.0.3.1:fv.9.3;
  #local E[ 258] = < 101, 128, 0 >; // vp.0.4--vp.9.4:fv.9.3;
  #local E[ 259] = < 128, 130, 0 >; // vp.9.4--ve.9.3.1:fv.9.3;
  #local E[ 260] = < 101, 132, 0 >; // vp.0.4--ve.0.4.0:fv.9.4;
  #local E[ 261] = < 132, 133, 0 >; // ve.0.4.0--ve.0.4.1:fv.9.4;
  #local E[ 262] = < 131, 158, 0 >; // vp.0.5--vp.9.5:fv.9.4;
  #local E[ 263] = < 158, 160, 0 >; // vp.9.5--ve.9.4.1:fv.9.4;
  #local E[ 264] = < 131, 162, 0 >; // vp.0.5--ve.0.5.0:fv.9.5;
  #local E[ 265] = < 162, 163, 0 >; // ve.0.5.0--ve.0.5.1:fv.9.5;
  #local E[ 266] = < 161, 188, 0 >; // vp.0.6--vp.9.6:fv.9.5;
  #local E[ 267] = < 188, 190, 0 >; // vp.9.6--ve.9.5.1:fv.9.5;
  #local E[ 268] = < 1, 10, 0 >; // vp.0.0--vp.9.0:fh.9.0;
  #local E[ 269] = < 10, 191, 0 >; // vp.9.0--vc.0:fh.9.0;
  #local E[ 270] = < 161, 192, 0 >; // vp.0.6--vc.1:fh.9.1;
  E
#end


#macro slicing_faces(explode)
  #local Nf = 80;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'prism' POV-ray primitive, for {kf} in {1..Nf}.
  // The {explode} parameter is a displacement to be
  // applied to each face in the normal direction of its normal.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = prism{ // fv.0.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +17.200098, -5.760626 >,
    < +17.958902, -11.521249 >,
    < +18.717719, -17.281865 >,
    < -2.276445, -17.281856 >,
    < -1.517628, -11.521247 >,
    < -0.758817, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, +0.95105639, +0.00000000,
      +0.86939544, +0.28248385, -0.40540651,
      -0.38556445, -0.12527766, -0.91413651,
      +26.60254000, +0.00000000, -50.00000000
    >
  }
  #local F[   2] = prism{ // fv.0.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +21.458885, -5.791768 >,
    < +21.923581, -11.583540 >,
    < +22.388303, -17.375309 >,
    < -1.394134, -17.375313 >,
    < -0.929422, -11.583542 >,
    < -0.464711, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, +0.95105672, +0.00000000,
      +0.92160251, +0.29944656, -0.24694246,
      -0.23485628, -0.07630926, -0.96903015,
      +33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[   3] = prism{ // fv.0.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808283 >,
    < +24.095417, -11.616545 >,
    < +24.251904, -17.424828 >,
    < -0.469465, -17.424827 >,
    < -0.312979, -11.616545 >,
    < -0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      +0.94778127, +0.30795280, -0.08292003,
      -0.07886164, -0.02562371, -0.99655620,
      +38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[   4] = prism{ // fv.0.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564882, -5.808283 >,
    < +24.408388, -11.616545 >,
    < +24.251901, -17.424828 >,
    < +0.469465, -17.424827 >,
    < +0.312978, -11.616545 >,
    < +0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901687, +0.95105656, +0.00000000,
      +0.94778127, +0.30795280, +0.08292003,
      +0.07886164, +0.02562369, -0.99655620,
      +40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[   5] = prism{ // fv.0.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317716, -5.791769 >,
    < +22.853002, -11.583542 >,
    < +22.388300, -17.375309 >,
    < +1.394137, -17.375313 >,
    < +0.929425, -11.583542 >,
    < +0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, +0.95105647, +0.00000000,
      +0.92160248, +0.29944665, +0.24694246,
      +0.23485623, +0.07630945, -0.96903014,
      +38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[   6] = prism{ // fv.0.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +20.235338, -5.760626 >,
    < +19.476532, -11.521230 >,
    < +18.717712, -17.281864 >,
    < +2.276437, -17.281857 >,
    < +1.517623, -11.521229 >,
    < +0.758814, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, +0.95105672, +0.00000000,
      +0.86939568, +0.28248327, +0.40540640,
      +0.38556448, +0.12527721, -0.91413656,
      +33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[   7] = prism{ // fh.0.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521905, -15.636584 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901692, +0.58778536, -0.00000000,
      -0.00000000, -0.00000000, -1.00000000,
      -0.58778536, +0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[   8] = prism{ // fh.0.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +8.220647, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, +0.95105639, +0.00000000,
      -0.00000000, -0.00000000, +1.00000000,
      +0.95105639, +0.30901739, +0.00000000,
      +26.60254000, +0.00000000, +50.00000000
    >
  }
  #local F[   9] = prism{ // fv.1.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441267, -0.000000 >,
    < +17.200071, -5.760623 >,
    < +17.958904, -11.521248 >,
    < +18.717709, -17.281853 >,
    < -2.276447, -17.281864 >,
    < -1.517625, -11.521250 >,
    < -0.758806, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, +0.58778561, +0.00000000,
      +0.53731594, +0.73955210, -0.40540630,
      -0.23829199, -0.32798048, -0.91413660,
      +21.52190000, +15.63658000, -50.00000000
    >
  }
  #local F[  10] = prism{ // fv.1.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, -0.000000 >,
    < +21.458862, -5.791773 >,
    < +21.923585, -11.583543 >,
    < +22.388291, -17.375316 >,
    < -1.394130, -17.375309 >,
    < -0.929429, -11.583539 >,
    < -0.464701, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      +0.56958133, +0.78396196, -0.24694282,
      -0.14514917, -0.19978107, -0.96903005,
      +27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[  11] = prism{ // fv.1.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.938915, -5.808282 >,
    < +24.095393, -11.616545 >,
    < +24.251887, -17.424827 >,
    < -0.469466, -17.424828 >,
    < -0.312972, -11.616545 >,
    < -0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, +0.58778541, +0.00000000,
      +0.58576098, +0.80623096, -0.08291988,
      -0.04873909, -0.06708358, -0.99655622,
      +31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[  12] = prism{ // fv.1.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721353, -0.000000 >,
    < +24.564859, -5.808282 >,
    < +24.408382, -11.616545 >,
    < +24.251888, -17.424827 >,
    < +0.469467, -17.424828 >,
    < +0.312972, -11.616545 >,
    < +0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, +0.58778497, +0.00000000,
      +0.58576098, +0.80623096, +0.08291988,
      +0.04873906, +0.06708361, -0.99655622,
      +32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[  13] = prism{ // fv.1.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317713, -5.791773 >,
    < +22.852989, -11.583543 >,
    < +22.388281, -17.375315 >,
    < +1.394125, -17.375310 >,
    < +0.929414, -11.583543 >,
    < +0.464699, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, +0.58778541, +0.00000000,
      +0.56958151, +0.78396182, +0.24694284,
      +0.14514940, +0.19978092, -0.96903005,
      +31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[  14] = prism{ // fv.1.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235354, -5.760624 >,
    < +19.476525, -11.521231 >,
    < +18.717723, -17.281854 >,
    < +2.276457, -17.281863 >,
    < +1.517631, -11.521231 >,
    < +0.758810, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, +0.58778453, +0.00000000,
      +0.53731565, +0.73955236, +0.40540622,
      +0.23829150, +0.32798074, -0.91413664,
      +27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[  15] = prism{ // fh.1.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521906, -15.636572 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, +0.95105649, -0.00000000,
      -0.00000000, -0.00000000, -1.00000000,
      -0.95105649, +0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  16] = prism{ // fh.1.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220621, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, +0.58778561, +0.00000000,
      -0.00000000, -0.00000000, +1.00000000,
      +0.58778561, +0.80901674, +0.00000000,
      +21.52190000, +15.63658000, +50.00000000
    >
  }
  #local F[  17] = prism{ // fv.2.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +17.200100, -5.760621 >,
    < +17.958900, -11.521250 >,
    < +18.717720, -17.281853 >,
    < -2.276440, -17.281853 >,
    < -1.517620, -11.521250 >,
    < -0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413690, -0.40540563,
      -0.00000000, -0.40540563, -0.91413690,
      +8.22064000, +25.30052000, -50.00000000
    >
  }
  #local F[  18] = prism{ // fv.2.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +21.458880, -5.791772 >,
    < +21.923580, -11.583544 >,
    < +22.388300, -17.375315 >,
    < -1.394140, -17.375315 >,
    < -0.929420, -11.583544 >,
    < -0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, -0.24694343,
      -0.00000000, -0.24694343, -0.96902990,
      +10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[  19] = prism{ // fv.2.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.938920, -5.808282 >,
    < +24.095420, -11.616545 >,
    < +24.251900, -17.424827 >,
    < -0.469460, -17.424827 >,
    < -0.312980, -11.616545 >,
    < -0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655624, -0.08291962,
      -0.00000000, -0.08291962, -0.99655624,
      +11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[  20] = prism{ // fv.2.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721360, +0.000000 >,
    < +24.564880, -5.808282 >,
    < +24.408380, -11.616545 >,
    < +24.251900, -17.424827 >,
    < +0.469460, -17.424827 >,
    < +0.312980, -11.616545 >,
    < +0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.99655624, +0.08291962,
      +0.00000000, +0.08291962, -0.99655624,
      +12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[  21] = prism{ // fv.2.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.317720, -5.791772 >,
    < +22.853020, -11.583544 >,
    < +22.388300, -17.375315 >,
    < +1.394140, -17.375315 >,
    < +0.929420, -11.583544 >,
    < +0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.96902990, +0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      +11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[  22] = prism{ // fv.2.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +20.235340, -5.760621 >,
    < +19.476540, -11.521232 >,
    < +18.717720, -17.281853 >,
    < +2.276440, -17.281853 >,
    < +1.517620, -11.521232 >,
    < +0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.91413692, +0.40540560,
      +0.00000000, +0.40540560, -0.91413692,
      +10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[  23] = prism{ // fh.2.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521905, -15.636586 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, +0.95105649, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.95105649, -0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  24] = prism{ // fh.2.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +8.220640, -25.300520 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      +0.00000000, +1.00000000, +0.00000000,
      +8.22064000, +25.30052000, +50.00000000
    >
  }
  #local F[  25] = prism{ // fv.3.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200073, -5.760628 >,
    < +17.958891, -11.521250 >,
    < +18.717714, -17.281864 >,
    < -2.276442, -17.281853 >,
    < -1.517637, -11.521248 >,
    < -0.758805, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, -0.58778561, +0.00000000,
      -0.53731594, +0.73955210, -0.40540630,
      +0.23829199, -0.32798048, -0.91413660,
      -8.22064000, +25.30052000, -50.00000000
    >
  }
  #local F[  26] = prism{ // fv.3.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458857, -5.791770 >,
    < +21.923585, -11.583539 >,
    < +22.388286, -17.375309 >,
    < -1.394135, -17.375316 >,
    < -0.929429, -11.583543 >,
    < -0.464706, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      -0.56958133, +0.78396196, -0.24694282,
      +0.14514917, -0.19978107, -0.96903005,
      -10.49708000, +32.30668000, -34.20202000
    >
  }
  #local F[  27] = prism{ // fv.3.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.938915, -5.808283 >,
    < +24.095393, -11.616545 >,
    < +24.251887, -17.424828 >,
    < -0.469467, -17.424827 >,
    < -0.312972, -11.616545 >,
    < -0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, -0.58778541, +0.00000000,
      -0.58576098, +0.80623096, -0.08291988,
      +0.04873909, -0.06708358, -0.99655622,
      -11.89122000, +36.59740000, -17.36482000
    >
  }
  #local F[  28] = prism{ // fv.3.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721353, +0.000000 >,
    < +24.564859, -5.808283 >,
    < +24.408381, -11.616545 >,
    < +24.251887, -17.424828 >,
    < +0.469466, -17.424827 >,
    < +0.312972, -11.616545 >,
    < +0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901720, -0.58778497, +0.00000000,
      -0.58576098, +0.80623096, +0.08291988,
      -0.04873906, +0.06708361, -0.99655622,
      -12.36068000, +38.04226000, +0.00000000
    >
  }
  #local F[  29] = prism{ // fv.3.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.317722, -5.791770 >,
    < +22.853007, -11.583543 >,
    < +22.388296, -17.375310 >,
    < +1.394140, -17.375315 >,
    < +0.929432, -11.583543 >,
    < +0.464708, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901688, -0.58778541, +0.00000000,
      -0.56958151, +0.78396182, +0.24694284,
      -0.14514940, +0.19978092, -0.96903005,
      -11.89122000, +36.59740000, +17.36482000
    >
  }
  #local F[  30] = prism{ // fv.3.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235346, -5.760628 >,
    < +19.476525, -11.521231 >,
    < +18.717699, -17.281863 >,
    < +2.276433, -17.281854 >,
    < +1.517631, -11.521231 >,
    < +0.758802, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901752, -0.58778453, +0.00000000,
      -0.53731565, +0.73955236, +0.40540622,
      -0.23829150, +0.32798074, -0.91413664,
      -10.49708000, +32.30668000, +34.20202000
    >
  }
  #local F[  31] = prism{ // fh.3.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521912, -15.636577 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901692, +0.58778536, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.58778536, -0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  32] = prism{ // fh.3.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220646, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901674, -0.58778561, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      -0.58778561, +0.80901674, +0.00000000,
      -8.22064000, +25.30052000, +50.00000000
    >
  }
  #local F[  33] = prism{ // fv.4.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +17.200092, -5.760627 >,
    < +17.958903, -11.521247 >,
    < +18.717720, -17.281856 >,
    < -2.276443, -17.281865 >,
    < -1.517627, -11.521249 >,
    < -0.758823, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, -0.95105639, +0.00000000,
      -0.86939544, +0.28248385, -0.40540651,
      +0.38556445, -0.12527766, -0.91413651,
      -21.52190000, +15.63658000, -50.00000000
    >
  }
  #local F[  34] = prism{ // fv.4.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +21.458874, -5.791771 >,
    < +21.923586, -11.583542 >,
    < +22.388297, -17.375313 >,
    < -1.394140, -17.375309 >,
    < -0.929418, -11.583540 >,
    < -0.464722, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, -0.95105672, +0.00000000,
      -0.92160251, +0.29944656, -0.24694246,
      +0.23485628, -0.07630926, -0.96903015,
      -27.48172000, +19.96664000, -34.20202000
    >
  }
  #local F[  35] = prism{ // fv.4.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, -0.000000 >,
    < +23.938923, -5.808282 >,
    < +24.095415, -11.616545 >,
    < +24.251901, -17.424827 >,
    < -0.469468, -17.424828 >,
    < -0.312980, -11.616545 >,
    < -0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      -0.94778127, +0.30795280, -0.08292003,
      +0.07886164, -0.02562371, -0.99655620,
      -31.13160000, +22.61844000, -17.36482000
    >
  }
  #local F[  36] = prism{ // fv.4.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564883, -5.808282 >,
    < +24.408390, -11.616545 >,
    < +24.251904, -17.424827 >,
    < +0.469468, -17.424828 >,
    < +0.312981, -11.616545 >,
    < +0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901687, -0.95105656, +0.00000000,
      -0.94778127, +0.30795280, +0.08292003,
      -0.07886164, +0.02562369, -0.99655620,
      -32.36068000, +23.51142000, +0.00000000
    >
  }
  #local F[  37] = prism{ // fv.4.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317724, -5.791771 >,
    < +22.853012, -11.583542 >,
    < +22.388299, -17.375313 >,
    < +1.394136, -17.375309 >,
    < +0.929435, -11.583542 >,
    < +0.464720, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901712, -0.95105647, +0.00000000,
      -0.92160248, +0.29944665, +0.24694246,
      -0.23485623, +0.07630945, -0.96903014,
      -31.13160000, +22.61844000, +17.36482000
    >
  }
  #local F[  38] = prism{ // fv.4.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +20.235349, -5.760628 >,
    < +19.476541, -11.521229 >,
    < +18.717726, -17.281857 >,
    < +2.276451, -17.281864 >,
    < +1.517632, -11.521230 >,
    < +0.758825, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901637, -0.95105672, +0.00000000,
      -0.86939568, +0.28248327, +0.40540640,
      -0.38556448, +0.12527721, -0.91413656,
      -27.48172000, +19.96664000, +34.20202000
    >
  }
  #local F[  39] = prism{ // fh.4.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602540, +0.000000 >,
    < +21.521900, -15.636580 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -1.00000000, +0.00000000, -0.00000000,
      +0.00000000, -0.00000000, -1.00000000,
      -0.00000000, -1.00000000, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  40] = prism{ // fh.4.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +8.220628, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901739, -0.95105639, +0.00000000,
      +0.00000000, -0.00000000, +1.00000000,
      -0.95105639, +0.30901739, +0.00000000,
      -21.52190000, +15.63658000, +50.00000000
    >
  }
  #local F[  41] = prism{ // fv.5.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +17.200098, -5.760626 >,
    < +17.958902, -11.521249 >,
    < +18.717719, -17.281865 >,
    < -2.276445, -17.281856 >,
    < -1.517628, -11.521247 >,
    < -0.758817, -5.760627 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, -0.95105639, +0.00000000,
      -0.86939544, -0.28248385, -0.40540651,
      +0.38556445, +0.12527766, -0.91413651,
      -26.60254000, +0.00000000, -50.00000000
    >
  }
  #local F[  42] = prism{ // fv.5.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +21.458885, -5.791768 >,
    < +21.923581, -11.583540 >,
    < +22.388303, -17.375309 >,
    < -1.394134, -17.375313 >,
    < -0.929422, -11.583542 >,
    < -0.464711, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      -0.92160251, -0.29944656, -0.24694246,
      +0.23485628, +0.07630926, -0.96903015,
      -33.96926000, +0.00000000, -34.20202000
    >
  }
  #local F[  43] = prism{ // fv.5.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.938923, -5.808283 >,
    < +24.095417, -11.616545 >,
    < +24.251904, -17.424828 >,
    < -0.469465, -17.424827 >,
    < -0.312979, -11.616545 >,
    < -0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, -0.95105647, +0.00000000,
      -0.94778127, -0.30795280, -0.08292003,
      +0.07886164, +0.02562371, -0.99655620,
      -38.48078000, +0.00000000, -17.36482000
    >
  }
  #local F[  44] = prism{ // fv.5.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564882, -5.808283 >,
    < +24.408388, -11.616545 >,
    < +24.251901, -17.424828 >,
    < +0.469465, -17.424827 >,
    < +0.312978, -11.616545 >,
    < +0.156486, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, -0.95105656, +0.00000000,
      -0.94778127, -0.30795280, +0.08292003,
      -0.07886164, -0.02562369, -0.99655620,
      -40.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[  45] = prism{ // fv.5.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317716, -5.791769 >,
    < +22.853002, -11.583542 >,
    < +22.388300, -17.375309 >,
    < +1.394137, -17.375313 >,
    < +0.929425, -11.583542 >,
    < +0.464712, -5.791771 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, -0.95105647, +0.00000000,
      -0.92160248, -0.29944665, +0.24694246,
      -0.23485623, -0.07630945, -0.96903014,
      -38.48078000, +0.00000000, +17.36482000
    >
  }
  #local F[  46] = prism{ // fv.5.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +20.235338, -5.760626 >,
    < +19.476532, -11.521230 >,
    < +18.717712, -17.281864 >,
    < +2.276437, -17.281857 >,
    < +1.517623, -11.521229 >,
    < +0.758814, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, -0.95105672, +0.00000000,
      -0.86939568, -0.28248327, +0.40540640,
      -0.38556448, -0.12527721, -0.91413656,
      -33.96926000, +0.00000000, +34.20202000
    >
  }
  #local F[  47] = prism{ // fh.5.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521905, -15.636584 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.80901692, -0.58778536, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.58778536, -0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  48] = prism{ // fh.5.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +8.220647, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, -0.95105639, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      -0.95105639, -0.30901739, +0.00000000,
      -26.60254000, +0.00000000, +50.00000000
    >
  }
  #local F[  49] = prism{ // fv.6.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441267, -0.000000 >,
    < +17.200071, -5.760623 >,
    < +17.958904, -11.521248 >,
    < +18.717709, -17.281853 >,
    < -2.276447, -17.281864 >,
    < -1.517625, -11.521250 >,
    < -0.758806, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, -0.58778561, +0.00000000,
      -0.53731594, -0.73955210, -0.40540630,
      +0.23829199, +0.32798048, -0.91413660,
      -21.52190000, -15.63658000, -50.00000000
    >
  }
  #local F[  50] = prism{ // fv.6.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, -0.000000 >,
    < +21.458862, -5.791773 >,
    < +21.923585, -11.583543 >,
    < +22.388291, -17.375316 >,
    < -1.394130, -17.375309 >,
    < -0.929429, -11.583539 >,
    < -0.464701, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778453, +0.00000000,
      -0.56958133, -0.78396196, -0.24694282,
      +0.14514917, +0.19978107, -0.96903005,
      -27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[  51] = prism{ // fv.6.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.938915, -5.808282 >,
    < +24.095393, -11.616545 >,
    < +24.251887, -17.424827 >,
    < -0.469466, -17.424828 >,
    < -0.312972, -11.616545 >,
    < -0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      -0.58576098, -0.80623096, -0.08291988,
      +0.04873909, +0.06708358, -0.99655622,
      -31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[  52] = prism{ // fv.6.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721353, -0.000000 >,
    < +24.564859, -5.808282 >,
    < +24.408382, -11.616545 >,
    < +24.251888, -17.424827 >,
    < +0.469467, -17.424828 >,
    < +0.312972, -11.616545 >,
    < +0.156494, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901720, -0.58778497, +0.00000000,
      -0.58576098, -0.80623096, +0.08291988,
      -0.04873906, -0.06708361, -0.99655622,
      -32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[  53] = prism{ // fv.6.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.317713, -5.791773 >,
    < +22.852989, -11.583543 >,
    < +22.388281, -17.375315 >,
    < +1.394125, -17.375310 >,
    < +0.929414, -11.583543 >,
    < +0.464699, -5.791770 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, -0.58778541, +0.00000000,
      -0.56958151, -0.78396182, +0.24694284,
      -0.14514940, -0.19978092, -0.96903005,
      -31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[  54] = prism{ // fv.6.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235354, -5.760624 >,
    < +19.476525, -11.521231 >,
    < +18.717723, -17.281854 >,
    < +2.276457, -17.281863 >,
    < +1.517631, -11.521231 >,
    < +0.758810, -5.760628 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, -0.58778453, +0.00000000,
      -0.53731565, -0.73955236, +0.40540622,
      -0.23829150, -0.32798074, -0.91413664,
      -27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[  55] = prism{ // fh.6.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521906, -15.636572 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      -0.30901709, -0.95105649, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.95105649, -0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  56] = prism{ // fh.6.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220621, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, -0.58778561, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      -0.58778561, -0.80901674, +0.00000000,
      -21.52190000, -15.63658000, +50.00000000
    >
  }
  #local F[  57] = prism{ // fv.7.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +17.200100, -5.760621 >,
    < +17.958900, -11.521250 >,
    < +18.717720, -17.281853 >,
    < -2.276440, -17.281853 >,
    < -1.517620, -11.521250 >,
    < -0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413690, -0.40540563,
      +0.00000000, +0.40540563, -0.91413690,
      -8.22064000, -25.30052000, -50.00000000
    >
  }
  #local F[  58] = prism{ // fv.7.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +21.458880, -5.791772 >,
    < +21.923580, -11.583544 >,
    < +22.388300, -17.375315 >,
    < -1.394140, -17.375315 >,
    < -0.929420, -11.583544 >,
    < -0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, -0.24694343,
      +0.00000000, +0.24694343, -0.96902990,
      -10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[  59] = prism{ // fv.7.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.938920, -5.808282 >,
    < +24.095420, -11.616545 >,
    < +24.251900, -17.424827 >,
    < -0.469460, -17.424827 >,
    < -0.312980, -11.616545 >,
    < -0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655624, -0.08291962,
      +0.00000000, +0.08291962, -0.99655624,
      -11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[  60] = prism{ // fv.7.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721360, +0.000000 >,
    < +24.564880, -5.808282 >,
    < +24.408380, -11.616545 >,
    < +24.251900, -17.424827 >,
    < +0.469460, -17.424827 >,
    < +0.312980, -11.616545 >,
    < +0.156480, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.99655624, +0.08291962,
      +0.00000000, -0.08291962, -0.99655624,
      -12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[  61] = prism{ // fv.7.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782440, +0.000000 >,
    < +23.317720, -5.791772 >,
    < +22.853020, -11.583544 >,
    < +22.388300, -17.375315 >,
    < +1.394140, -17.375315 >,
    < +0.929420, -11.583544 >,
    < +0.464720, -5.791772 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.96902990, +0.24694343,
      +0.00000000, -0.24694343, -0.96902990,
      -11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[  62] = prism{ // fv.7.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994160, +0.000000 >,
    < +20.235340, -5.760621 >,
    < +19.476540, -11.521232 >,
    < +18.717720, -17.281853 >,
    < +2.276440, -17.281853 >,
    < +1.517620, -11.521232 >,
    < +0.758820, -5.760621 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.91413692, +0.40540560,
      +0.00000000, -0.40540560, -0.91413692,
      -10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[  63] = prism{ // fh.7.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602542, -0.000000 >,
    < +21.521905, -15.636586 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901709, -0.95105649, -0.00000000,
      +0.00000000, +0.00000000, -1.00000000,
      +0.95105649, +0.30901709, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  64] = prism{ // fh.7.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441280, +0.000000 >,
    < +8.220640, -25.300520 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.00000000, +1.00000000,
      +0.00000000, -1.00000000, +0.00000000,
      -8.22064000, -25.30052000, +50.00000000
    >
  }
  #local F[  65] = prism{ // fv.8.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +17.200073, -5.760628 >,
    < +17.958891, -11.521250 >,
    < +18.717714, -17.281864 >,
    < -2.276442, -17.281853 >,
    < -1.517637, -11.521248 >,
    < -0.758805, -5.760623 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, +0.58778561, +0.00000000,
      +0.53731594, -0.73955210, -0.40540630,
      -0.23829199, +0.32798048, -0.91413660,
      +8.22064000, -25.30052000, -50.00000000
    >
  }
  #local F[  66] = prism{ // fv.8.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +21.458857, -5.791770 >,
    < +21.923585, -11.583539 >,
    < +22.388286, -17.375309 >,
    < -1.394135, -17.375316 >,
    < -0.929429, -11.583543 >,
    < -0.464706, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778453, +0.00000000,
      +0.56958133, -0.78396196, -0.24694282,
      -0.14514917, +0.19978107, -0.96903005,
      +10.49708000, -32.30668000, -34.20202000
    >
  }
  #local F[  67] = prism{ // fv.8.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, +0.000000 >,
    < +23.938915, -5.808283 >,
    < +24.095393, -11.616545 >,
    < +24.251887, -17.424828 >,
    < -0.469467, -17.424827 >,
    < -0.312972, -11.616545 >,
    < -0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      +0.58576098, -0.80623096, -0.08291988,
      -0.04873909, +0.06708358, -0.99655622,
      +11.89122000, -36.59740000, -17.36482000
    >
  }
  #local F[  68] = prism{ // fv.8.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721353, +0.000000 >,
    < +24.564859, -5.808283 >,
    < +24.408381, -11.616545 >,
    < +24.251887, -17.424828 >,
    < +0.469466, -17.424827 >,
    < +0.312972, -11.616545 >,
    < +0.156494, -5.808282 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901720, +0.58778497, +0.00000000,
      +0.58576098, -0.80623096, +0.08291988,
      +0.04873906, -0.06708361, -0.99655622,
      +12.36068000, -38.04226000, +0.00000000
    >
  }
  #local F[  69] = prism{ // fv.8.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782421, -0.000000 >,
    < +23.317722, -5.791770 >,
    < +22.853007, -11.583543 >,
    < +22.388296, -17.375310 >,
    < +1.394140, -17.375315 >,
    < +0.929432, -11.583543 >,
    < +0.464708, -5.791773 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901688, +0.58778541, +0.00000000,
      +0.56958151, -0.78396182, +0.24694284,
      +0.14514940, -0.19978092, -0.96903005,
      +11.89122000, -36.59740000, +17.36482000
    >
  }
  #local F[  70] = prism{ // fv.8.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994156, +0.000000 >,
    < +20.235346, -5.760628 >,
    < +19.476525, -11.521231 >,
    < +18.717699, -17.281863 >,
    < +2.276433, -17.281854 >,
    < +1.517631, -11.521231 >,
    < +0.758802, -5.760624 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901752, +0.58778453, +0.00000000,
      +0.53731565, -0.73955236, +0.40540622,
      +0.23829150, -0.32798074, -0.91413664,
      +10.49708000, -32.30668000, +34.20202000
    >
  }
  #local F[  71] = prism{ // fh.8.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602534, -0.000000 >,
    < +21.521912, -15.636577 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901692, -0.58778536, -0.00000000,
      -0.00000000, +0.00000000, -1.00000000,
      +0.58778536, +0.80901692, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  72] = prism{ // fh.8.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441267, +0.000000 >,
    < +8.220646, -25.300518 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.80901674, +0.58778561, +0.00000000,
      -0.00000000, +0.00000000, +1.00000000,
      +0.58778561, -0.80901674, +0.00000000,
      +8.22064000, -25.30052000, +50.00000000
    >
  }
  #local F[  73] = prism{ // fv.9.0
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +16.441275, -0.000000 >,
    < +17.200092, -5.760627 >,
    < +17.958903, -11.521247 >,
    < +18.717720, -17.281856 >,
    < -2.276443, -17.281865 >,
    < -1.517627, -11.521249 >,
    < -0.758823, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, +0.95105639, +0.00000000,
      +0.86939544, -0.28248385, -0.40540651,
      -0.38556445, +0.12527766, -0.91413651,
      +21.52190000, -15.63658000, -50.00000000
    >
  }
  #local F[  74] = prism{ // fv.9.1
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, +0.000000 >,
    < +21.458874, -5.791771 >,
    < +21.923586, -11.583542 >,
    < +22.388297, -17.375313 >,
    < -1.394140, -17.375309 >,
    < -0.929418, -11.583540 >,
    < -0.464722, -5.791768 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      +0.92160251, -0.29944656, -0.24694246,
      -0.23485628, +0.07630926, -0.96903015,
      +27.48172000, -19.96664000, -34.20202000
    >
  }
  #local F[  75] = prism{ // fv.9.2
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, -0.000000 >,
    < +23.938923, -5.808282 >,
    < +24.095415, -11.616545 >,
    < +24.251901, -17.424827 >,
    < -0.469468, -17.424828 >,
    < -0.312980, -11.616545 >,
    < -0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, +0.95105647, +0.00000000,
      +0.94778127, -0.30795280, -0.08292003,
      -0.07886164, +0.02562371, -0.99655620,
      +31.13160000, -22.61844000, -17.36482000
    >
  }
  #local F[  76] = prism{ // fv.9.3
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +24.721369, +0.000000 >,
    < +24.564883, -5.808282 >,
    < +24.408390, -11.616545 >,
    < +24.251904, -17.424827 >,
    < +0.469468, -17.424828 >,
    < +0.312981, -11.616545 >,
    < +0.156487, -5.808283 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901687, +0.95105656, +0.00000000,
      +0.94778127, -0.30795280, +0.08292003,
      +0.07886164, -0.02562369, -0.99655620,
      +32.36068000, -23.51142000, +0.00000000
    >
  }
  #local F[  77] = prism{ // fv.9.4
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +23.782436, +0.000000 >,
    < +23.317724, -5.791771 >,
    < +22.853012, -11.583542 >,
    < +22.388299, -17.375313 >,
    < +1.394136, -17.375309 >,
    < +0.929435, -11.583542 >,
    < +0.464720, -5.791769 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901712, +0.95105647, +0.00000000,
      +0.92160248, -0.29944665, +0.24694246,
      +0.23485623, -0.07630945, -0.96903014,
      +31.13160000, -22.61844000, +17.36482000
    >
  }
  #local F[  78] = prism{ // fv.9.5
    +0.000010, -0.000010, 9,
    < +0.000000, +0.000000 >,
    < +20.994163, -0.000000 >,
    < +20.235349, -5.760628 >,
    < +19.476541, -11.521229 >,
    < +18.717726, -17.281857 >,
    < +2.276451, -17.281864 >,
    < +1.517632, -11.521230 >,
    < +0.758825, -5.760626 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901637, +0.95105672, +0.00000000,
      +0.86939568, -0.28248327, +0.40540640,
      +0.38556448, -0.12527721, -0.91413656,
      +27.48172000, -19.96664000, +34.20202000
    >
  }
  #local F[  79] = prism{ // fh.9.0
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +26.602540, +0.000000 >,
    < +21.521900, -15.636580 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, -0.00000000,
      -0.00000000, +0.00000000, -1.00000000,
      +0.00000000, +1.00000000, +0.00000000,
      +0.00000000, +0.00000000, -50.00000000
    >
  }
  #local F[  80] = prism{ // fh.9.1
    +0.000010, -0.000010, 4,
    < +0.000000, +0.000000 >,
    < +16.441275, +0.000000 >,
    < +8.220628, -25.300516 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.30901739, +0.95105639, +0.00000000,
      -0.00000000, +0.00000000, +1.00000000,
      +0.95105639, -0.30901739, +0.00000000,
      +21.52190000, -15.63658000, +50.00000000
    >
  }
  F
#end

