#include "eixos.inc"

#macro slicing_view(thing, show_axes, show_ground, view)
  // Declares the {slicing_camlight} parameters for the specific {view} of object {thing}
  // Assumes {+X} is front, {+Y} is right.
  // 
  // Specifically, declares the following variables globally:
  //
  //   {scene_center}
  //   {scene_radius}
  //   {dir_camera}
  //   {dist_camera}
  
  #local thmin = min_extent(thing);
  #debug concat("\n!! thmin = ", vstr(3, thmin, " ", 0,1), "\n")
  
  #local thmax = max_extent(thing);
  #debug concat("\n!! thmax = ", vstr(3, thmax, " ", 0,1), "\n")
  
  #local thdim = thmax - thmin;
  #debug concat("\n!! thdim = ", vstr(3, thdim, " ", 0,1), "\n")
  
  #local thrad = vlength(thdim)/2;
  #local thctr = (thmin + thmax)/2;
  
  #local scene = 
    union{
      object{ thing }
      
      #if (show_axes)
        object{ eixos(1.3*thrad, 0.005*thrad) }
      #end
      
      #if (show_ground)

        #declare tx_ground =
          texture{
            pigment{ checker color rgb < 0.600, 0.650, 0.750 >, color rgb < 0.800, 0.850, 0.900 > }
            finish{ diffuse 0.900 ambient 0.100 }
            scale 300.0
          }
        #local ground = box{ <-2000,-2000,-10>, <+2000,+2000,-0.1> texture{ tx_ground } }
        object{ ground 
          #if (thmin.z < 0)
            translate thmin.z*z
          #end
        }
      #end
      object{ nothing(1.23) }
      object{ nothing(1.33) }
    }
    
  object{ scene }

  #local scene_center_normal = thctr;
  #local scene_radius_normal = 1.25*thrad;
  #local dist_camera_normal = 9*scene_radius_normal;
  #local camera_dir_Z_normal = 6.5;
  
  // sphere{ scene_center_normal,10 texture{ slicing_tx_debug } }

  #if (view = 0)
    // Full view of object from right front:
    #declare scene_center = scene_center_normal;
    #declare scene_radius = 0.85*scene_radius_normal;
    #declare dir_camera = < 14.00,  6.00, camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 1)
    // Full view of object from right front, slightlu farther away:
    #declare scene_center = scene_center_normal + (0.1*thdim.z)*z;
    #declare scene_radius = 0.90*scene_radius_normal;
    #declare dir_camera = < 14.00,  12.00, 0.80*camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 2)
    // Full view from front left:
    #declare scene_center = scene_center_normal;
    #declare scene_radius = scene_radius_normal;
    #declare dir_camera = < 14.00, -12.00, camera_dir_Z_normal >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 3)
    // Full view from near top:
    #declare scene_center = scene_center_normal;
    #declare scene_radius = scene_radius_normal;
    #declare dir_camera = < 2.00, 3.00, 12.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 4)
    // Full orthogonal view from X axis:
    #declare scene_center = scene_center_normal;
    #declare scene_radius = scene_radius_normal;
    #declare dir_camera = < 1, 0, 0 >;
    #declare dist_camera = 1000*scene_radius;
  #elseif (view = 5)
    // Top front right corner larger detail:
    #declare scene_center = scene_center_normal + thdim/2;
    #declare scene_radius = 250;
    #declare dir_camera = < 14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 6)
    // Top front right corner larger detail from back:
    #declare scene_center = thctr + thdim/2;
    #declare scene_radius = 250;
    #declare dir_camera = < -14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 7)
    // Center front detail:
    #declare scene_center = thctr + thdim.x/2*x;
    #declare scene_radius = 100;
    #declare dir_camera = < 14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 8)
    // Top right edge middle larger detail from back:
    #declare scene_center = thctr + < 0, thdim.y/2, thdim.z/2 >;
    #declare scene_radius = 250;
    #declare dir_camera = < -14.00, 12.00, 4.00 >;
    #declare dist_camera = dist_camera_normal;
  #elseif (view = 9)
    // Left edge middle frontal full height:
    #declare scene_center = thctr + < 0, thdim.z/2 - thdim.y/2, 0 >;
    #declare scene_radius = 0.90*thdim.z;
    #declare dir_camera = < +14.00, 0.00, 0.00 >;
    #declare dist_camera = dist_camera_normal;
  #end
#end
