#declare slicing_num_faces = 10;
#declare slicing_num_edges = 24;
#declare slicing_num_vertices = 16;

#declare slicing_num_planes = 5;
#declare slicing_planes_Z_min = 24.4017;
#declare slicing_planes_Z_max = 61.0042;
#declare slicing_edge_radius = 0.397995;
#declare slicing_vertex_radius = 0.397995;

#macro slicing_vertices()
  #local Nv = 16;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < -5.0000, -50.0000, 86.6026 >; // vu.0.0
  #local V[   2] = < -5.0000, -34.2020, 79.2358 >; // vu.0.1
  #local V[   3] = < -5.0000, -17.3648, 74.7244 >; // vu.0.2
  #local V[   4] = < -5.0000, 0.0000, 73.2050 >; // vu.0.3
  #local V[   5] = < -5.0000, 17.3648, 74.7244 >; // vu.0.4
  #local V[   6] = < -5.0000, 34.2020, 79.2358 >; // vu.0.5
  #local V[   7] = < -5.0000, 50.0000, 86.6026 >; // vu.0.6
  #local V[   8] = < -5.0000, 0.0000, 0.0000 >; // vc.0
  #local V[   9] = < 5.0000, -50.0000, 86.6026 >; // vu.1.0
  #local V[  10] = < 5.0000, -34.2020, 79.2358 >; // vu.1.1
  #local V[  11] = < 5.0000, -17.3648, 74.7244 >; // vu.1.2
  #local V[  12] = < 5.0000, 0.0000, 73.2050 >; // vu.1.3
  #local V[  13] = < 5.0000, 17.3648, 74.7244 >; // vu.1.4
  #local V[  14] = < 5.0000, 34.2020, 79.2358 >; // vu.1.5
  #local V[  15] = < 5.0000, 50.0000, 86.6026 >; // vu.1.6
  #local V[  16] = < 5.0000, 0.0000, 0.0000 >; // vc.1
  V
#end


#macro slicing_edges()
  #local Ne = 24;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   0 original object edge.
  //   1 refinement (triangulation, monotonization, etc) edge.
  //   2 ghost edge.
  // 
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 9, 0 >; // vu.0.0--vu.1.0:fu.0;
  #local E[   2] = < 9, 10, 0 >; // vu.1.0--vu.1.1:fu.0;
  #local E[   3] = < 2, 10, 0 >; // vu.0.1--vu.1.1:fu.1;
  #local E[   4] = < 10, 11, 0 >; // vu.1.1--vu.1.2:fu.1;
  #local E[   5] = < 3, 11, 0 >; // vu.0.2--vu.1.2:fu.2;
  #local E[   6] = < 11, 12, 0 >; // vu.1.2--vu.1.3:fu.2;
  #local E[   7] = < 4, 12, 0 >; // vu.0.3--vu.1.3:fu.3;
  #local E[   8] = < 12, 13, 0 >; // vu.1.3--vu.1.4:fu.3;
  #local E[   9] = < 5, 13, 0 >; // vu.0.4--vu.1.4:fu.4;
  #local E[  10] = < 13, 14, 0 >; // vu.1.4--vu.1.5:fu.4;
  #local E[  11] = < 6, 14, 0 >; // vu.0.5--vu.1.5:fu.5;
  #local E[  12] = < 14, 15, 0 >; // vu.1.5--vu.1.6:fu.5;
  #local E[  13] = < 8, 16, 0 >; // vc.0--vc.1:fs.0;
  #local E[  14] = < 1, 8, 0 >; // vu.0.0--vc.0:fs.0;
  #local E[  15] = < 7, 15, 0 >; // vu.0.6--vu.1.6:fs.1;
  #local E[  16] = < 15, 16, 0 >; // vu.1.6--vc.1:fs.1;
  #local E[  17] = < 1, 2, 0 >; // vu.0.0--vu.0.1:fp.0;
  #local E[  18] = < 2, 3, 0 >; // vu.0.1--vu.0.2:fp.0;
  #local E[  19] = < 3, 4, 0 >; // vu.0.2--vu.0.3:fp.0;
  #local E[  20] = < 4, 5, 0 >; // vu.0.3--vu.0.4:fp.0;
  #local E[  21] = < 5, 6, 0 >; // vu.0.4--vu.0.5:fp.0;
  #local E[  22] = < 6, 7, 0 >; // vu.0.5--vu.0.6:fp.0;
  #local E[  23] = < 7, 8, 0 >; // vu.0.6--vc.0:fp.0;
  #local E[  24] = < 9, 16, 0 >; // vu.1.0--vc.1:fp.1;
  E
#end


#macro slicing_faces(explode)
  #local Nf = 10;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'prism' POV-ray primitive, for {kf} in {1..Nf}.
  // The {explode} parameter is a displacement to be
  // applied to each face in the normal direction of its normal.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = prism{ // fu.0
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43119 >,
    < +0.00000, -17.43119 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.42262164, +0.90630621,
      +0.00000000, -0.90630621, +0.42262164,
      -5.00000000, -50.00000000, +86.60260000
    >
  }
  #local F[   2] = prism{ // fu.1
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43112 >,
    < +0.00000, -17.43112 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.25881294, +0.96592746,
      +0.00000000, -0.96592746, +0.25881294,
      -5.00000000, -34.20200000, +79.23580000
    >
  }
  #local F[   3] = prism{ // fu.2
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43115 >,
    < +0.00000, -17.43115 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.08716581, +0.99619382,
      +0.00000000, -0.99619382, +0.08716581,
      -5.00000000, -17.36480000, +74.72440000
    >
  }
  #local F[   4] = prism{ // fu.3
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43115 >,
    < +0.00000, -17.43115 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.08716581, +0.99619382,
      +0.00000000, -0.99619382, -0.08716581,
      -5.00000000, +0.00000000, +73.20500000
    >
  }
  #local F[   5] = prism{ // fu.4
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43112 >,
    < +0.00000, -17.43112 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.25881294, +0.96592746,
      +0.00000000, -0.96592746, -0.25881294,
      -5.00000000, +17.36480000, +74.72440000
    >
  }
  #local F[   6] = prism{ // fu.5
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -17.43119 >,
    < +0.00000, -17.43119 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.42262164, +0.90630621,
      +0.00000000, -0.90630621, -0.42262164,
      -5.00000000, +34.20200000, +79.23580000
    >
  }
  #local F[   7] = prism{ // fs.0
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -100.00005 >,
    < +0.00000, -100.00005 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, -0.86602555, -0.49999974,
      +0.00000000, +0.49999974, -0.86602555,
      -5.00000000, +0.00000000, +0.00000000
    >
  }
  #local F[   8] = prism{ // fs.1
    +0.00010, -0.00010, 5,
    < +0.00000, +0.00000 >,
    < +10.00000, +0.00000 >,
    < +10.00000, -100.00005 >,
    < +0.00000, -100.00005 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.86602555, -0.49999974,
      -0.00000000, +0.49999974, +0.86602555,
      -5.00000000, +50.00000000, +86.60260000
    >
  }
  #local F[   9] = prism{ // fp.0
    +0.00010, -0.00010, 9,
    < +0.00000, +0.00000 >,
    < +17.43119, +0.00000 >,
    < +34.59747, +3.02706 >,
    < +50.97743, +8.98875 >,
    < +66.07312, +17.70454 >,
    < +79.42616, +28.90901 >,
    < +90.63062, +42.26216 >,
    < +81.91544, -57.35739 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.00000000, +0.90630621, -0.42262164,
      -1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.42262164, +0.90630621,
      -5.00000000, -50.00000000, +86.60260000
    >
  }
  #local F[  10] = prism{ // fp.1
    +0.00010, -0.00010, 9,
    < +0.00000, +0.00000 >,
    < +100.00005, +0.00000 >,
    < +85.72122, -9.99807 >,
    < +73.39564, -22.32382 >,
    < +63.39740, -36.60248 >,
    < +56.03084, -52.40054 >,
    < +51.51924, -69.23769 >,
    < +50.00008, -86.60256 >,
    <0,0>
    texture{ slicing_tx_face }
    translate explode*y
    matrix<
      +0.00000000, +0.49999974, +0.86602555,
      +1.00000000, +0.00000000, +0.00000000,
      +0.00000000, +0.86602555, -0.49999974,
      +5.00000000, +0.00000000, +0.00000000
    >
  }
  F
#end

