#! /bin/bash 

TAG="$1"; shift
NI="$1"; shift
SUBD="$1"; shift
SHOW="$1"; shift # YES or NO

QUICK=0
if [[ ${QUICK} -ne 0 ]]; then
  WIDTH=400
  HEIGHT=400
  NRAYS=1
else
  WIDTH=800
  HEIGHT=800
  NRAYS=2
fi

NI8="`printf '%08d' ${NI}`"

OBJ_PREF="${TAG}_${NI8}_${SUBD}"

INC_FILE="out/${OBJ_PREF}.inc"
IMG_FILE="out/${OBJ_PREF}.png"

printf "slicing_naf_run_povray.sh:\n" 1>&2
printf "  TAG=${TAG}\n" 1>&2
printf "  NI=${NI}\n" 1>&2
printf "  SUBD=${SUBD}\n" 1>&2
printf "  QUICK=${QUICK}\n" 1>&2
printf "  WIDTH=${WIDTH}\n" 1>&2
printf "  HEIGHT=${HEIGHT}\n" 1>&2
printf "  NRAYS=${NRAYS}\n" 1>&2
printf "  INC_FILE = ${INC_FILE}\n" 1>&2
printf "  IMG_FILE = ${IMG_FILE}\n" 1>&2

# Should filter error messages (0 or 1):
FILTER=1

# Directories where POV-Ray is installed:
POVRAY=/usr/bin/povray
POVINC=( +L.. )

# Main input files:
POV_FILE=slicing_naf_main.pov

# Output image file:

# Command to display resultin image:
IMVIEW=( display -title '%d/%f' )

rm -f ${IMG_FILE} params.inc
echo "#declare inc_file = \"${INC_FILE}\"" >> params.inc
${POVRAY} \
    +K0.5000 \
    +FN +Q9 \
    +W${WIDTH} +H${HEIGHT} \
    +AM1 +A0.0 +R${NRAYS} \
    +D \
    ${POV_INC[@]} \
    +I${POV_FILE} \
    +O${IMG_FILE} \
  2>&1 \
  | povray-output-filter.gawk -v do_filter=${FILTER}

if [[ "/${SHOW}" == "/YES" ]]; then
  if [[ -s ${IMG_FILE} ]]; then
    ${IMVIEW[@]} ${IMG_FILE}
  fi
fi
