//   Partite with gold, with circular name and motto,
//   that can be used as background for the DCC abbacus.
//  
//  Assumes defined
//  
//    ring_i_texture = texture for inner part of ring
//    ring_o_texture = texture for outer part of ring
//
//    ring_i_ridge_texture = texture for inner  ridge
//    ring_m_ridge_texture = texture for middle ridge
//    ring_o_ridge_texture = texture for outer  ridge
//
//    ring_i_radius = ring inner  radius
//    ring_m_radius = ring middle radius
//    ring_o_radius = ring outer  radius
//
//    ring_ridge_radius = minor radius of ridges
//
//    ring_i_thickness = ring inner  thickness
//    ring_m_thickness = ring middle thickness
//    ring_o_thickness = ring outer  thickness
//    
//  Defines
//  
//    abacus_base = the ring

#include "dcc-ring-plain.inc"

#declare legend_font_file = "crystal.ttf"
#declare legend_font_depth = 1;
#declare legend_font_width = 0.50;
#declare legend_font_height = 0.75;

#declare ring_min_thickness = min(ring_i_thickness, ring_o_thickness);

#declare legend_radius = (ring_i_radius + ring_m_radius)/2;
#declare legend_width =  (2.0/3.0)*(ring_m_radius - ring_i_radius);
#declare legend_text_up = "INSTITUTO DE COMPUTAO"
#declare legend_text_dn = "UNICAMP"
#include "dcc-ring-legend.inc"
#declare dcc_ring_i_legend = 
  object{ dcc_ring_legend 
    translate < 0.00, 0.5*ring_min_thickness, 0.00 >
  }

#declare legend_radius = (ring_m_radius + ring_o_radius)/2;
#declare legend_width =  (2.0/3.0)*(ring_o_radius - ring_m_radius);
#declare legend_text_up = "ARTE ENGENHARIA E CINCIA"
#declare legend_text_dn = "DA COMPUTAO"
#include "dcc-ring-legend.inc"
#declare dcc_ring_o_legend = 
  object{ dcc_ring_legend 
    translate < 0.00, 0.5*ring_min_thickness, 0.00 >
  }

#declare abacus_base = 
  difference{
    object{ dcc_ring_plain }
    union{
      object{ dcc_ring_i_legend }
      object{ dcc_ring_o_legend }
    }
  }
