// POVRAY description of the DCC "abacus" logo, fancy colors, ring base
// Last edited on 2002-03-23 20:00:43 by stolfi

global_settings{ max_trace_level 3 }

light_source {
  <-10.0000, +50.0000, -10.0000>
  color rgb <1.30, 1.30, 1.30>
} 

light_source {
  <+20.0000, +80.0000, +05.0000>
  color rgb <0.50, 0.50, 0.50>
} 

light_source {
  <+05.0000, +80.0000, +20.0000>
  color rgb <0.30, 0.30, 0.30>
} 

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#include "dcc-wood-new.inc"

#declare bamboo_base_color = color rgb <0.80, 0.70, 0.60>;
#declare bamboo_vein_color = color rgb <0.40, 0.35, 0.20>;
#declare bamboo_color = bamboo_base_color;
#include "textures/bamboo.inc"

#include "textures/lacquers.inc"
#include "textures/metals.inc"

// background{ color rgb <0.00, 0.03, 0.20> }
// background{ color rgb <0.00, 0.00, 0.00> }
#include "background.inc"

#declare abacus_bottom_Y = 0.0;
#declare base_top_Y      = -0.1;

// The babacus:

#declare abacus_frame_texture = texture{texture_wood}
#declare abacus_stick_texture = texture{texture_bamboo} 
#declare abacus_unit_slider_texture = texture{texture_lacquer_blue}
#declare abacus_unit_slider_interior = interior{}
#declare abacus_five_slider_texture = texture{texture_lacquer_red}
#declare abacus_five_slider_interior = interior{}

#include "dcc-std-abacus.inc"

#declare abacus_Y_shift = abacus_bottom_Y + abacus_frame_thickness/2;

object{abacus 
  rotate <0,90,0> 
  translate <0.0, abacus_Y_shift, 0.0> 
}

// The ring base

#declare ring_i_texture = texture{ texture_gold }
#declare ring_o_texture = texture{ texture_silver }

#declare ring_i_ridge_texture = texture{ texture_lacquer_blue }
#declare ring_m_ridge_texture = texture{ texture_lacquer_red }
#declare ring_o_ridge_texture = texture{ texture_lacquer_blue }

#declare ring_i_legend_texture = texture{ texture_lacquer_blue }
#declare ring_o_legend_texture = texture{ texture_lacquer_red }

#declare ring_i_radius = 2.1;
#declare ring_m_radius = 2.9;
#declare ring_o_radius = 3.41;

#declare ring_o_thickness = 0.250;
#declare ring_m_thickness = 0.300;
#declare ring_i_thickness = 0.275;

#declare ring_ridge_radius = 0.03;

#declare ring_legend_relief = 0.05;

#include "dcc-base-ring.inc"

#declare base_Y_shift = base_top_Y;

object{abacus_base
  translate <0.0, base_Y_shift, 0.0>
}

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 0;
#declare camDY = 50;
#declare camDZ = 0;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+7.0000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +7.0000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

