function model = coleta_nspl(dx,h_ax,y_coord,cor)
% Realiza a coleta de pontos para interpolacao de "n" refletores
% por splines cubicas
% Retorna-se em "modelo":
%      => Os pontos dos refletores (modelo.refletores) *
%      => Os pontos interpolados (modelo.entrada)
%      => Informacoes sobre as splines(modelo.splines)
%      => Numero de refletores (modelo.n_refs)
%
% *Os refletores sao discretizados em unidades de abcissa
%  iguais a "dx"

% Inicializacao de variaveis
%linhas = cell(1,n); % conterah refletores
%linha1=cell(1,n);   % conterah pontos de entrada
%spl = cell(1,n);    % conterah informacoes sobre as splines
axes(h_ax);
%cla;


[x,z,but]=ginput(1);

%primeiro ponto no extremo esquerdo
x=min(get(h_ax,'xlim'));

linha1=[x,y_coord,z];
plot(x,z,'kx');

if(but~=2)

	but=1;

        while(but ==1)
            [x,z,but]=ginput(1);

            % Arredondamento das coordenadas (2 casas decimais)
            x = round(100*x);
            z = round(100*z);
            x = x/100;
            z = z/100;


            if(but~=1)% se ultimo ponto-> joga ponto p/ extremo
                x=max(get(h_ax,'xlim'));
            end;

            plot(x,z,'kx');

            linha1 = [linha1;x,y_coord,z];

        end;

else
    	% refletor plano
        linha1 = [linha1;max(get(h_ax,'xlim')),y_coord,z];
end


% Obtencao dos pontos do refletor "i"
xlim = get(gca,'Xlim');
xx = xlim(1):dx:xlim(2);
zz=spline(linha1(:,1),linha1(:,3),xx);

t =length(xx);
yy = zeros(t,1);
for i=1:t
	yy(i,1)=y_coord;
end

aux = zeros(length(xx),3);
aux(:,1)=xx';
aux(:,2)=yy ;
aux(:,3)=zz';

linhas =aux;

% Obtencao das informacoes das splines do refletor "i"
spl =spline(linha1(:,1),linha1(:,3));

% Plotando refletor "i"
h=plot(xx,zz);
set(h,'Color',[1/cor 0 0]);


% Atribuicao dos valores de retorno
model.reflector = linhas;
model.breaks = linha1;
model.splines = spl;
model.samp_num = t;
