#! /usr/bin/python3
# Last edited on 2018-07-06 17:51:37 by stolfilocal

# {muff_capture.py}: Main program of the multi-light,
# multi-focus image capture software for the 
# MUFF v2.0 microscope positioner.

# This program only starts the two processes
# {muff_mainloop.py} and {muff_camview.py}, 
# that do the real work, connected by a pipeline.

# USAGE: "muff_capture.py"


import os, sys

HELP = \
  "  muff_capture.py\n"

INFO = \
  "  This is the top-level program in the MUFF 2.0 microscope positioner software suite.  Its automatically captures a complete multi-light, multi-view, multi-focus set of images of an object, suitable for 3D recovery using photometric, geometric, and focus stereo techniques.\n" \
  "\n" \
  "  The task of this program in fact is only to start the two processes tha do the actual work, {muff_mainloop.py} and {muff_camview.py}, connected by a pipe.  The images are written to the directory '{muff_scans}'.  See those two programs for more details on the operation, such as the output file naming schema.\n" \
  "\n" \
  "  The program asks the user for the index {camix} of the microscope camera in the system, the number {nL} of distinct light settings to use, the number {nH} of microscope Z positions (frames per stack), and the distance {Z_step} between consecutive positions (float, in millimeters).  Currently the number of views must be 1.\n" \
  "\n" \
  "  The number of distinct views is currently fixed at 1 due to the lack of a remotely controlled tiltatbe stage.\n" \
  "\n" \
  "  The Arduino development environment should be running too, in order to download the firmware to the Arduino and to position the microscope manually for the lowest frame.  (Eventually there will be manual motion buttons on the support itself, so this need will go away.)"


if len(sys.argv) != 1 or (len(sys.argv) > 1 and sys.argv[1] == "-help"):
  # Display the help text and exit:
  stderr.write("SYNOPSIS\n")
  stderr.write(HELP + "\n\n")
  stderr.write("DESCRIPTION\n")
  stderr.write(INFO + "\n")
  exit(0)

camix = int(input("camera index (0,1,..)? "))
nL = int(input("number of lights? "))
nV = 1 # For now.
Z_step = float(input("displacement between focus planes (mm)? "))
nH = int(input("number of focus planes? "))

mainloop_cmd = "./muff_mainloop.py %d %d %d %+.3f" % (nL, nV, nH, Z_step)
camview_cmd = "./muff_camview.py %s" % camix
pipe_cmd = mainloop_cmd + " | " + camview_cmd
os.system(pipe_cmd)
