// POVRAY description of the DCC "abacus" logo, fancy colors
// Last edited on 2002-04-01 00:45:20 by stolfi

background{ color rgb <0.00, 0.03, 0.20> }

light_source {
  <-10.0000, +50.0000, -10.0000>
  color rgb <1.30, 1.30, 1.30>
} 

light_source {
  <50.0000, 10.0000, 10.0000>
  color rgb <0.50, 0.50, 0.50>
} 

light_source {
  <10.0000, 10.0000, 50.0000>
  color rgb <0.30, 0.30, 0.30>
} 

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 3.1;
#declare camDY = 7;
#declare camDZ = 4.2;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+3.1000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +3.1000>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

#declare crystal_color = color rgb <1.00, 0.60, 0.25>;
#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#declare wood_texture =
  texture{
    pigment{
      wood
      turbulence 0.2
      color_map{ 
        [ 0.0, 0.8  
          color red 0.500 green 0.220 blue 0.053
          color red 0.500 green 0.220 blue 0.053
        ]
        [ 0.8, 1.01 
          color red 0.300 green 0.100 blue 0.040
          color red 0.200 green 0.033 blue 0.033
        ]
      }
      scale <0.5, 0.05, 0.05>
    }
    normal{
      wrinkles 0.2
      scale <0.01, 0.01, 0.5>
    }
    finish {diffuse 0.95 ambient 0.05}
    rotate <0, 90, 0>
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.5, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.4 roughness 0.01}
  }

#declare light_bamboo_texture =
  texture{
    pigment{
      color rgb <0.80, 0.70, 0.60>
    }
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.95 ambient 0.05}
  }

#declare dark_bamboo_texture =
  texture{
    pigment{
      color rgb <0.50, 0.25, 0.00>
    }
    normal{
      wrinkles 0.2
      scale <0.01, 0.01, 0.50>
    }
    finish {diffuse 0.95 ambient 0.05}
    rotate <0, 90, 0>
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.2 roughness 0.05}
  }

#declare opaque_texture = 
    texture{
      pigment {color crystal_color filter 0.00}
      finish {diffuse 0.95 ambient 0.05}
    }

#declare crystal_texture = 
    texture{
      pigment {color crystal_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }
#declare crystal_interior = interior {ior 1.2}     

#declare abacus_slider_width       = 1.20;
#declare abacus_slider_round_min_R = 0.30;
#declare abacus_slider_sin_t       = 0.7071067812;
#declare abacus_slider_cos_t       = 0.7071067812;
#declare abacus_slider_hole_R      = 0.32;

#declare abacus_width              = 2.0;
#declare abacus_height             = 1.8;
#declare abacus_frame_width        = 0.15;
#declare abacus_frame_thickness    = 0.30;
#declare abacus_stick_R            = 0.040;

#declare abacus_frame_texture = texture{wood_texture}
#declare abacus_stick_texture = texture{light_bamboo_texture} 
#declare abacus_slider_texture = texture{crystal_texture}
#declare abacus_slider_interior = interior{crystal_interior}

#include "dcc-abacus-special.inc"

// object{
//   abacus_slider
//   texture{crystal_texture} interior{crystal_interior}
// }

// #declare baseY = - (1.5 * abacus_slider_width/2)

object{abacus rotate <0,180,0>}

#declare baseHY = 0.10;
#declare baseY = - (2 * abacus_frame_thickness/2);
#declare baseR = 1.5;

cylinder {
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{
    pigment {color rgb <1.00, 0.40, 0.43>}
    finish {diffuse 0.95 ambient 0.05}
  }
}

