// Last edited on 2002-03-28 12:13:57 by stolfi

//  Dark bamboo textures for the DCC abacus
//  
//  Assumes defined
//
//    highlight_color
//
//  Defines
//  
//    bamboo_texture_light
//    bamboo_texture_dark

#declare bamboo_texture_light =
  texture{
    pigment{
      color rgb <0.80, 0.70, 0.60>
    }
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.9 ambient 0.1}
  }

#declare bamboo_texture_dark =
  texture{
    pigment{
      color rgb <0.30, 0.25, 0.15>
    }
    normal{
      wrinkles 0.2
      scale <0.01, 0.01, 0.50>
    }
    finish {diffuse 0.9 ambient 0.1}
    rotate <0, 90, 0>
  }
  texture{
    pigment{color highlight_color filter 0.80}
    normal{
      wrinkles 0.2
      scale <0.50, 0.01, 0.01>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.2 roughness 0.05}
  }
