#ifndef MULTIINDEX_H_
#define MULTIINDEX_H_

#include<stdio.h>
#include "../dataType/Integer.h"
#include<stdlib.h>
#include <vector>

class MultiIndex
{
public:
	int dim;
	int *mIdx;
	
public:
	MultiIndex(int dim);
	MultiIndex(int dim,int set_all_values_to);
	virtual ~MultiIndex();
	
	MultiIndex* getSubIndex(int subDim,int* subIdx);
	
	
	bool equals(MultiIndex* op);
	MultiIndex* insertElement(int pos,int el);
	MultiIndex* clone();
	
	
	
	Integer* factorial();
	
	


	int  max();
	int  sum();
	void  setAll(int v);
	MultiIndex*  addPrefix(int p);
	bool  isCompatible(MultiIndex* op);
	MultiIndex*  append(MultiIndex* op);
	MultiIndex*  sub(MultiIndex* op);
	MultiIndex*  add(MultiIndex* op);
	static Integer*  combination(MultiIndex* n, MultiIndex* k);
	MultiIndex*  supressFirst();
	MultiIndex*  supressLast();
	bool  isGreaterThan(MultiIndex* op);
	bool  isGreaterEqThan(MultiIndex* op);
	bool  isLessThan(MultiIndex* op);
	bool  isLessEqThan(MultiIndex* op);
	
	static std::vector<MultiIndex*>  addPrefix(int p, std::vector<MultiIndex*> v,std::vector<MultiIndex*> acum);
	std::vector<MultiIndex*>  getLessThan();
	std::vector<MultiIndex*>  getLessEqThan();
	std::vector<MultiIndex*>  selectGreaterFrom(std::vector<MultiIndex*> v);
	std::vector<MultiIndex*> selectGreaterEqFrom(std::vector<MultiIndex*> v);
	std::vector<MultiIndex*> selectLessFrom(std::vector<MultiIndex*> v);
	std::vector<MultiIndex*> selectLessEqFrom(std::vector<MultiIndex*> v);
	static std::vector<MultiIndex*>  getMultiIdxSet(int sum,int dim);
	static std::vector<MultiIndex*> getMultiIdxSetLessEq(int sum,int dim);
	
	
	
	
	
	
	
	
	
	
	
	/*
	 * Debugging methods
	 */
	void print(FILE* fp);
	
};

#endif /*MULTIINDEX_H_*/
