#ifndef DOMAINPOINT_H_
#define DOMAINPOINT_H_

#include "DomainType.h"
#include "../dataType/Matrix.h"

class DomainPoint : public IrregularMatrix
{
	
public:
	DomainType* domainType;
	
	
public:
	static std::vector<DomainPoint*> insertElement(int i,int j, Number* n, std::vector<DomainPoint*> v, std::vector<DomainPoint*> accum);
	static std::vector<DomainPoint*> insertRow(int i,DomainPoint* row, std::vector<DomainPoint*> v, std::vector<DomainPoint*> accum);
	DomainPoint* extendPoint2Simplex(int i);
	
public:
	static std::vector<DomainPoint*> domainPoints(int dim,int n);
	static std::vector<DomainPoint*> domainPoints(MultiIndex* mDim, int n);	
	
	DomainPoint(MultiIndex* domain);
	virtual ~DomainPoint();
	
	void printPlot(Number* val,FILE *fp);
	
	
	
};

#endif /*DOMAINPOINT_H_*/
