#ifndef VARFACTORY_H_
#define VARFACTORY_H_

#include "../dataType/Number.h"

class VarFactory
{

	/*
	 * Size of the factory.
	 * More specifically, how many Numbers
	 * are allocated
	 */
	static int size;


	/*
	 * Every time more memory is needed, the space is increased in
	 * "allocSize" Numbers;
	 */
	static int allocSize;


	static int* blockIds;
	static int* varIds;
	static Number** values;



public:




	static void setVar(int varId, Number* value);
	static void accumVar(int varId, Number* value);
	static Number* getVar(int varId);

	VarFactory();
	virtual ~VarFactory();
};

#endif /*VARFACTORY_H_*/
