#ifndef GRAPH_H_
#define GRAPH_H_

#include <vector>

typedef struct vertexTag {
  int blockId;
  int visited;
  struct edgeTag *edges;
  struct vertexTag *next;
} vertexT;

typedef struct edgeTag {
  struct vertexTag *connectsTo;
  struct edgeTag *next;
} edgeT;


class Graph
{
public:

	std::vector<vertexT> vvec;
	std::vector<edgeT> evec;


	std::vector<vertexT>::iterator findVertex(vertexT v);
	std::vector<edgeT>::iterator findEdge(edgeT e);

	int isBorderEdge(edgeT e);


	void addEdge(vertexT v, edgeT e);
	void addVertex(vertexT v);



	Graph();
	virtual ~Graph();
};

#endif /*GRAPH_H_*/
