// The abacus slider
// Last edited on 2002-03-31 21:21:34 by stolfi

//  Requires
//     abacus_slider_angle       = angle between chamfer and flat face, in degrees
//
// Defines 
//  abacus_slider  = 
//     the slider piece, outer radius = 1, thickness = 2*abacus_slider_HY
//     centered on the origin and threaded on the Y axis.

#declare abacus_slider_width       = 1.00;
#declare abacus_slider_hole_R      = 0.32;
#declare abacus_slider_round_min_R = 0.25;

#declare abacus_slider_sin_t       = sin(radians(abacus_slider_angle));
#declare abacus_slider_cos_t       = cos(radians(abacus_slider_angle));

#declare abacus_slider_HY          = abacus_slider_width / 2;

#declare abacus_slider_round_maj_R  =  
  1 - abacus_slider_round_min_R;

#declare abacus_slider_round_HY  =  
  abacus_slider_round_min_R * abacus_slider_cos_t;

#declare abacus_slider_cap_base_Y  =  
  abacus_slider_round_HY;

#declare abacus_slider_cap_base_R  =  
  abacus_slider_round_maj_R  + abacus_slider_round_min_R / abacus_slider_sin_t;

#declare abacus_slider_cap_height  =  
  abacus_slider_cap_base_R * (abacus_slider_sin_t / abacus_slider_cos_t);

#declare abacus_slider_cap_join_R  =  
  abacus_slider_round_maj_R  + abacus_slider_round_min_R * abacus_slider_sin_t;

#declare abacus_slider_bounder =
  cylinder{
    <0, -abacus_slider_HY, 0>, 
    <0, +abacus_slider_HY, 0>, 
    1.0
  }

#declare abacus_slider_joiner_cyl =
  cylinder{
    <0, -abacus_slider_HY, 0>, 
    <0, +abacus_slider_HY, 0>, 
    1.00001*abacus_slider_cap_join_R
  }

#declare abacus_slider_cap_cone =
  cone{
    <0, -0.0001*abacus_slider_cap_height, 0>, 1.0001*abacus_slider_cap_base_R 
    <0, abacus_slider_cap_height, 0>, 0
  }

#declare abacus_slider_caps =
  intersection{
    merge{
      object{abacus_slider_cap_cone}
      object{abacus_slider_cap_cone scale <1,-1,1>}
    }
    object{abacus_slider_joiner_cyl}
  }

#declare abacus_slider_round =
  difference{
    torus{abacus_slider_round_maj_R, abacus_slider_round_min_R}
    object{abacus_slider_joiner_cyl scale <0.99999, 1.00001, 0.99999>}
  }
    
#declare abacus_slider_hole =
  cylinder{
    <0, -1.1*abacus_slider_HY, 0>, 
    <0, +1.1*abacus_slider_HY, 0>, 
    abacus_slider_hole_R
  }

#declare abacus_slider =
  difference{
    merge{
      object{abacus_slider_caps}
      abacus_slider_round
    }
    object{abacus_slider_hole}
    bounded_by{object{abacus_slider_bounder scale 1.0001}}
  }    

