// Test of single slider
// Last edited on 2002-03-31 22:08:20 by stolfi

background{ color rgb <0.00, 0.03, 0.20> }

light_source {
  <10.0000, 50.0000, 10.0000>
  color rgb <1.20, 1.20, 1.20>
} 

light_source {
  <50.0000, 10.0000, 10.0000>
  color rgb <0.50, 0.50, 0.50>
} 

light_source {
  <10.0000, 10.0000, 50.0000>
  color rgb <0.30, 0.30, 0.30>
} 

#declare centerX = 0;
#declare centerY = 0;
#declare centerZ = 0;

#declare camDX = 8.1;
#declare camDY = 3;
#declare camDZ = -4.2;

#declare skyX = 0;
#declare skyY = 1;
#declare skyZ = 0;

camera {
  location  <centerX, centerY, centerZ> + <camDX, camDY, camDZ>
  direction <-camDX, -camDY, -camDZ>
  right     <+2.8000, 00.0000, 00.0000>
  up        <00.0000, 00.0000, +2.800>
  sky       <skyX, skyY, skyZ>
  look_at   <centerX, centerY, centerZ>
} 

#declare crystal_color = color rgb <1.00, 0.60, 0.25>;
#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#declare opaque_texture = 
    texture{
      pigment {color crystal_color filter 0.00}
      finish {diffuse 0.95 ambient 0.05}
    }

#declare crystal_texture = 
    texture{
      pigment {color crystal_color filter 1.00}
      finish {diffuse 0.0 ambient 0.0}
    }
    texture{
      pigment {color highlight_color filter 0.70}
      finish {diffuse 0.0 ambient 0.0 specular 0.5 roughness 0.1}
    }

#declare crystal_interior = interior { ior 1.2 }

#declare abacus_slider_angle = 30;

#include "dcc-abacus-slider.inc"

object{
  abacus_slider
  texture{ crystal_texture } interior{ crystal_interior }
}

#declare baseHY = 0.10;
#declare baseY = - (1.5 * abacus_slider_HY);
#declare baseR = 1.5;

cylinder {
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{
    pigment {color rgb <1.00, 1.00, 1.00>}
    finish {diffuse 0.95 ambient 0.05}
  }
}

