//  Requires
//    legend_font_file
//    legend_font_depth
//    legend_font_width
//    legend_font_height
//    legend_char = a string with the desired character

#declare ch_box = 
  box{
    <  
      -0.5*legend_font_width-0.001, 
      -0.001,               
      -0.5*legend_font_height-0.001
    >, 
    <
      +1.5*legend_font_width+0.001, 
      +legend_font_depth+0.001, 
      +1.5*legend_font_height+0.001
    >
  }


#debug concat("[", legend_char, "]")
#if (strcmp(legend_char,"") = 0)
  #declare ch = 
    cylinder{ <0,0,0>, <0,legend_font_depth,0>, 0.2*legend_font_width }
#else
  #declare ch = 
    text{ 
      ttf legend_font_file,
      legend_char,
      legend_font_depth, 0*x
      rotate <90,0,0>
      translate <0,legend_font_depth,0>
      bounded_by{ object{ ch_box } }
      translate <-legend_font_width/2,0,-legend_font_height/2>
    }
#end
