# Tools to create printer/job parameter tables.
# Last edited on 2021-02-19 14:32:47 by jstolfi

import job_parms_IMP

# A /parameter table/ {parms} is a Python dict that specifies a bunch of
# parameters that determine the computation of move and jump times, the
# details of generated G-code, the nominal widths of traces, etc.
#
# Some parameters depend on the printer. Some on the filament used.
# Some are chosen by the user for a specific job.

import job_parms_IMP

def typical():
  # Return a parameter table with typical values for testing.
  return job_parms_IMP.typical()

def write(wr, pref, parms, suff):
  # Writes the parameter table {parms} nicely to {wr}, one parameter per line.
  # Each line is prefixed by the string {pref} and suffixed by the string 
  # {suff} (if they are not {None}).
  job_parms_IMP.write(wr, pref, parms, suff) 
  
