#! /bin/bash 

NEO="$1"; shift
OSHAPE="$1"; shift
INNER="$1"; shift
SUBDIV="$1"; shift
PLANES="$1"; shift

QUICK=1
if [[ ${QUICK} -ne 0 ]]; then
  WIDTH=400
  HEIGHT=400
  NRAYS=1
else
  WIDTH=800
  HEIGHT=800
  NRAYS=2
fi

printf "run_fan_povray.sh:\n" 1>&2
printf "  NEO = ${NEO}\n" 1>&2
printf "  OSHAPE = ${OSHAPE}\n" 1>&2
printf "  INNER =  ${INNER}\n" 1>&2
printf "  SUBDIV = ${SUBDIV}\n" 1>&2
printf "  PLANES = ${PLANES}\n" 1>&2

printf "run_fan_povray.sh: QUICK = ${QUICK}" 1>&2
printf " ( WIDTH = ${WIDTH} HEIGHT = ${HEIGHT} NRAYS = ${NRAYS} )\n" 1>&2

# Should images be displayed automatically?
SHOW=YES

# Should filter error messages (0 or 1):
FILTER=1

# Directories where POV-Ray is installed:
POVRAY=/usr/bin/povray
POVINC=( +L.. )

NEO8="`printf '%08d' ${NEO}`"

# Main input files:
POV_FILE=fan_main.pov
INC_PREF="fan_${NEO8}_osh${OSHAPE}_ich${INNER}"
INC_FILE="out/${INC_PREF}.inc"

# Output image file:
IMG_PREF="fan_n${NEO8}_osh${OSHAPE}_ich${INNER}_sub${SUBDIV}_pla${PLANES}"
IMG_FILE="out/${IMG_PREF}.png"

# Command to display resultin image:
IMVIEW=( display -title '%d/%f' )

rm -f ${IMG_FILE} params.inc
echo "#declare inc_file = \"${INC_FILE}\"" >> params.inc
echo "#declare subdiv = ${SUBDIV};" >> params.inc
echo "#declare show_planes = ${PLANES};" >> params.inc
${POVRAY} \
    +K0.5000 \
    +FN +Q9 \
    +W${WIDTH} +H${HEIGHT} \
    +AM1 +A0.0 +R${NRAYS} \
    +D \
    ${POV_INC[@]} \
    +I${POV_FILE} \
    +O${IMG_FILE} \
  2>&1 \
  | povray-output-filter.gawk -v do_filter=${FILTER}

if [[ "/${SHOW}" == "/YES" ]]; then
  if [[ -s ${IMG_FILE} ]]; then
    ${IMVIEW[@]} ${IMG_FILE}
  fi
fi
