import java.awt.*;

// importa a classe de Layout personalizado
import InterfaceLayout;

// Classe: CanvasMapaReduzido
// Autor: Fbio Dalla Vecchia - RA:981091
// Canvas que controla o Mapa Reduzido mostrado no canto direito superior da tela
class CanvasMapaReduzido extends Canvas {
    private int largura;
    private int altura;
    private Image img;

    // acessveis ao Applet
    protected String msg = "Mapa reduzido da Unicamp/Baro Geraldo";
    protected boolean msgStatus=false;

    // construtor
    public CanvasMapaReduzido( int larg,int alt, Image img_map ) {
        largura = larg;
        altura = alt;
        img = img_map;
        reshape( 0,0,larg,alt );
        }

    public void paint( Graphics g ) {
        g.setColor( Color.blue );
        g.drawImage( img,0,0,this );
        g.drawRect(0,0,largura-1,altura-1);  // desenha borda
        }

    // Quando mouse passa sobre controle, exibimos uma mensagem
    // na linha de estado inferior da tela
    public boolean mouseEnter( Event evt,int x,int y ) {
        //showStatus( "Mapa reduzido da Unicamp/Baro Geraldo" );
        msgStatus=true;
        //repaint();
        return( true );
        }

    public boolean mouseExit( Event evt,int x,int y ) {
        msgStatus=false;        
        return true;
        }

    public boolean mouseDown( Event evt,int x, int y ) {
        if( x < largura && y < altura ) 
            {
            System.out.println( "Mouse no Mapa Reduzido: ("+x+","+y+")" );
            return true;
            }
        return false;
        }
    }
