//  Arquivo:
//  InterfaceLayout.java
//
//  Objetivo:
//  Implementacao de um controlador de posicionamento de componenetes
//  para permitir colocar os componenetes do Applet em qualquer lugar
//  da tela dando maior flexibilidade na interface com o usuario
//  
//  Compilador: javac 1.3
//  Autor: Fbio Dalla Vecchia - RA:981091
//  ltima Atualizao: 15-Jun-2001  
// 

import java.awt.*;

// Classe: InterfaceLayout
// Autor: Fbio Dalla Vecchia - RA:981091
// OBS: Todos os mtodos padro da estrutura Layout sero sobreescritos 
public class InterfaceLayout implements LayoutManager {

    // Construtor
    public InterfaceLayout() {
        }

    // Mtodo para adicionar os componentes 
    public void addLayoutComponent( String name,Component comp ) {
        // apenas sobreescreve mtodo (no precisa fazer nada)
        }

    // Mtodo para remover componentes
    public void removeLayoutComponent( Component comp ) {
        // apenas sobreescreve mtodo (no precisa fazer nada)
        }

    // Mtodo para acertar a dimenso do controlador em funo da 
    // dimenso dos componentes (e suas posies) para que seja 
    // possvel visualizar todos eles no espao destinado ao 
    // controlador de layout
    public Dimension preferredLayoutSize( Container parent ) {
        Insets insets = parent.insets();
        int numero = parent.countComponents();
        int largura = 0;
        int altura = 0;

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();
            Point p = comp.location();

            if( ( p.x + d.width ) > largura )
                largura = p.x + d.width;
            if( ( p.y + d.height ) > altura )
                altura = p.y + d.height;
            }

        return( new Dimension( insets.left + insets.right + largura,
            insets.top + insets.bottom + altura ) );
        }

    
    // Mtodo para controlar a dimenso mnima que deve ter o 
    // controlador de Layout
    public Dimension minimumLayoutSize( Container parent ) {
        Insets insets = parent.insets();
        int numero = parent.countComponents();
        int largura = 0;
        int altura = 0;

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();
            Point p = comp.location();

            if( ( p.x + d.width ) > largura )
                largura = p.x + d.width;
            if( ( p.y + d.height ) > altura )
                altura = p.y + d.height;
            }

        return( new Dimension( insets.left + insets.right + largura,
            insets.top + insets.bottom + altura ) );
        }


    // Mtodo para Reescalar os componentes a seus tamanhos 
    // preferidos (caso isso seja possvel)
    public void layoutContainer( Container parent ) {
        int numero = parent.countComponents();

        for( int i=0; i < numero; i++ ) 
            {
            Component comp = parent.getComponent( i );
            Dimension d = comp.preferredSize();

            comp.resize( d.width,d.height );
            }
        }
    }
