#! /usr/bin/python3
# Test program for module {input_data}.
# Last edited on 2021-02-17 19:20:26 by jstolfi

import input_data
import block
import path
import move
import contact
import hacks
import job_parms
import color
import rn
import pyx
import sys
from math import sqrt, sin, cos, floor, ceil, inf, nan, pi

parms = job_parms.very_slow()
job_parms.write(sys.stderr, None, parms, None)
wdfill = parms['solid_raster_width']

def test_multi_raster_roads(nrd, nbc, nmv):
  wdf = parms['solid_raster_width']
  BS, CS = input_data.multi_raster_roads(nrd, nbc, nmv, wdf, parms)
  block.print_contact_table(sys.stderr, BS, CS, None)
  o = (1,1)
  input_data.plot("tests/out/input_data_TST_mrr", BS, CS, o, wdf)
  
def test_two_roads_and_islands(nmv, nmg, nis):
  wdc = parms['contour_trace_width']
  wdf = parms['solid_raster_width']
  BS, CS = input_data.two_roads_and_islands(nmv, nmg, nis, wdc, wdf, parms)
  block.print_contact_table(sys.stderr, BS, CS, None)
  o = (1,1)
  input_data.plot("tests/out/input_data_TST_rdis", BS, CS, o, wdf)
  
test_two_roads_and_islands(8,1,3)
test_two_roads_and_islands(19,3,2)
test_multi_raster_roads(3,3,4)
    
 
