function [sites,n,xlim,ylim] = makesites(nsites,p)

rx = random('unid',p,1,nsites);
ry = random('unid',p,1,nsites);

ctrl = zeros(max(rx),max(ry));

xlim(1)=min([0,rx]);
xlim(2)=max(rx);

ylim(1)=min([0,ry]);
ylim(2)=max(ry);


n = nsites;

sites = cell(1,nsites)

for i=1:nsites
   if(ctrl(rx(i),ry(i))~=1)
	   sites{i}.x = rx(i);
      sites{i}.y = ry(i);
      ctrl(rx(i),ry(i))=1;
   else
      n = n-1;
   end;
   
end;

%void makesites()
%  {
%    int i, j;
%    float s, t;
%    
%    srandom(4615);
%
%    if (NORMAL) 

%{	/* central limit approx to normal distribuition: */
%	for (i=0; i < NSITES; i++) 
%          {
%            s = t = 0.0;
%	    for (j=0; j<9; j++)
%              { s += frandom() - 0.5; t += frandom() - 0.5; }
%	    sites[i].x = s;
%	    sites[i].y = t;
%	  }
%      }
%    else 
%      {	/* uniform distribution: */
%	for (i=0; i<NSITES; i++) 
%	  {           
%	    sites[i].x = frandom() - 0.5;
%	    sites[i].y = frandom() - 0.5;
%	  }
%      }
%  }
