// Last edited on 2024-06-12 12:51:25 by stolfi
// Figure for topological slicing paper

#version 3.7;

global_settings{ max_trace_level 6 assumed_gamma 1.2 }
background{ color rgb < 1.000, 1.000, 1.000 > }
#debug "!! === hel_main.pov =============================\n"

// ----------------------------------------------------------------------
// THING TO SHOW

#local view = 0;
#local show_axes = 0;
#local show_ground = 0;

// Read the parameters {incfile}, {subfig}:
#include "params.inc"

// The {subfig} specifies the sub-figure:
//
//   0 = hel object as given.
//   1 = with triangulated faces, dumb triangulation.
//   2 = with triangulated faces, smart triangulation.
//   3 = same as 0, without slicing planes.
//   4 = reserved.
//   5 = with dumb convex decomposition of faces.
//   6 = with smart convex decomposition of faces.
//   7 = reserved.
//   8 = with dumb monotonic decomposition of faces.
//   9 = with smart monotonic decomposition of faces.

#declare eps = 0.0005; // Fudge distance for contacting surfaces etc.

#include "hel_textures.inc"

// Read the elements of the hel:
#include inc_file

#local Ro_even  = hel_outer_chain_even_radius; #debug concat("!! Ro_even = ", str(Ro_even, 0,4), "\n")
#local Ro_odd  =  hel_outer_chain_odd_radius;  #debug concat("!! Ro_odd  = ", str(Ro_odd,  0,4), "\n")
#local Ri_even  = hel_inner_chain_even_radius; #debug concat("!! Ri_even = ", str(Ri_even, 0,4), "\n")
#local Ri_odd  =  hel_inner_chain_odd_radius;  #debug concat("!! Ri_odd  = ", str(Ri_odd,  0,4), "\n")
#local Ha  =      hel_thickness;               #debug concat("!! Ha      = ", str(Ha,      0,4), "\n")
#local Amin  =    hel_min_elevation;           #debug concat("!! Amin    = ", str(Amin,    0,4), "\n")
#local Amax  =    hel_max_elevation;           #debug concat("!! Amax    = ", str(Amax,    0,4), "\n")

#local Nv  =      hel_num_vertices;            #debug concat("!! Nv      = ", str(Nv,      0,0), "\n")
#local Ne  =      hel_num_edges;               #debug concat("!! Ne      = ", str(Ne,      0,0), "\n")
#local Nf  =      hel_num_faces;               #debug concat("!! Nf      = ", str(Nf,      0,0), "\n")
#local Neo =      hel_num_outer_chain_edges;   #debug concat("!! Neo     = ", str(Neo,     0,0), "\n")
#local Nei =      hel_num_inner_chain_edges;   #debug concat("!! Nei     = ", str(Nei,     0,0), "\n")
#local oshape =   hel_outer_chain_shape;       #debug concat("!! oshape  = ", str(oshape,  0,0), "\n")

// To avoid stupid POV-Ray CSG warning:
#local Zmid = (Ri_even+Ro_even)/2*sin(radians((Amin+Amax)/2));
#local Ymid = (Ri_even+Ro_even)/2*cos(radians((Amin+Amax)/2));
#macro nothing(rad)
  sphere{ <0,Ymid,Zmid>, rad*eps texture{ hel_tx_invisible } }
#end

#macro check_pow2(n,msg)
  #local k = n; #while (mod(k,2) = 0) #local k = k / 2; #end
  #if (k != 1) #debug msg #end
#end

// Paranoia:
#if (Nv != 2*(Neo + Nei + 2)) kaboom("inconsistent {Nv,Neo,Nei}") #end 
#if (Ne != 3*(Neo + Nei + 2)) kaboom("inconsistent {Ne,Neo,Nei}") #end 
#if (mod(Neo, 2) != 0) kaboom("{Neo} is not even") #end 
#if (mod(Nei, 2) != 0) kaboom("{Nei} is not even") #end 
#if (Nei != 0)
  #if (Neo != Nei) kaboom("{Neo != 2*Nei}") #end 
#end

#local V = hel_vertices()
#local E = hel_edges()
#local F = hel_faces()

#include "eixos.inc"
#include "misc_arrows.inc"

#macro hel_debug_vertex(name, kv, vk)
  #if (kv >= 1)
    #local kvx = concat(" (v", str(kv,0,0), ")")
  #else
    #local kvx = ""
  #end
  #local vtx = concat("( ", str(vk.x,9,4), " ", str(vk.y,9,4), " ", str(vk.z,9,4), ")")
  #debug concat("!!   ", name, kvx, " = ", vtx, "\n")
#end

// Choose the positions of the slicing planes:
#include "hel_choose_planes.inc"
#local Zp = hel_choose_planes(V, Neo,Nei,oshape, subfig)

// Choose the face subdivision edges {D[1..Nd]}:
// Entry {D[0]} is not used:
#include "hel_partition.inc"
#if ((subfig >= 1) & (subfig <= 2))
  #if ((subfig = 2) & ((oshape = 1) | (oshape = 3)))
    check_pow2(Neo-2, "{Neo} must be a power of 2 plus 2 for smart triangulation") 
  #end
  #include "hel_triangulate.inc"
  #local D = hel_triangulate(V, E, Neo, Nei, oshape, subfig)
#elseif ((subfig >= 5) & (subfig <= 6))
  #include "hel_convexify.inc"
  #local D = hel_convexify(V, E, Neo, Nei, oshape, subfig)
#elseif ((subfig >= 8) & (subfig <= 9))
  #include "hel_monotonify.inc"
  #local D = hel_monotonify(V, E, Neo, Nei, oshape, subfig)
#else
  #local D = array[1]
  #local D[0] = < -1, -1, -1 >;
#end

#include "hel_skeleton.inc"
#include "hel_solid.inc"
#include "hel_planes.inc"

#local skel = hel_skeleton(V, E, D, Zp, Neo, Nei, oshape, subfig) 
#local surf = hel_solid(V, F, Neo, Nei, oshape, subfig)
#local spla = hel_planes(Zp, V, oshape, subfig)

#local Zrot = 0; // -50; // Degrees.

#local thing = 
  union{
    object{ nothing(1.17) }
    object{ skel }
    object{ surf }
    rotate Zrot*z 
  }

// Leave the slicing planes out of the {thing} or it will mess its bounding box:
object{ spla rotate Zrot*z }

// ----------------------------------------------------------------------

#include "hel_view.inc"
hel_view(thing, show_axes, show_ground, view)

#include "camlight.inc"
#declare intens_luz = 1.50;
camlight(centro_cena, raio_cena, dir_camera, dist_camera , z, intens_luz)
