#! /usr/bin/python3
# Test program for module {contact}
# Last edited on 2021-02-18 15:25:27 by jstolfi

import contact
import move
import path
import block
import palette
import hacks
import job_parms
import rn
import pyx
import sys
from math import sqrt, sin, cos, floor, ceil, pi, nan, inf

parms = job_parms.typical()

sys.stderr.write("--- creating test data ------------\n")
MS, PS, CS, BS = block.create_test_data(parms)
block.print_contact_table(sys.stderr, BS, CS, MS)

def test_plot(MS, PS, CS):
  sys.stderr.write("--- testing {plot} ------------\n")

  wd = 0.5

  box = None
  for oph in PS:
    phbox = path.bbox(oph)
    box = rn.box_join(box, phbox)

  plo = (floor(box[0][0])-1, floor(box[0][1])-1)
  phi = (ceil(box[1][0])+1, ceil(box[1][1])+1)
  szx = phi[0] - plo[0]
  szy = phi[1] - plo[1]
  c = pyx.canvas.canvas()
  hacks.plot_grid(c, None, 0.03, plo, szx, szy, 0.20, 1, 1)

  nph = len(PS)
  clr = [None]*nph
  for k in range(nph):
    RGBk = palette.discrete(k, 0.400, 0.600, 0.700, 1.000)
    clr[k] = pyx.color.rgb(RGBk[0], RGBk[1], RGBk[2])
  wref = wd
  waxes = 0.05*wref   
  axes = False
  dots = True
  arrows = True
  matter = False
  for k in range(nph):
    path.plot_standard(c, PS[k], None, None, clr[k], waxes, axes, dots, arrows, matter)

  nct = len(CS)
  wcont = 0.15*wref
  ccont = pyx.color.rgb.blue
  for k in range(nct):
    contact.plot(c, CS[k], None, wcont, ccont)

  hacks.write_plot(c, "tests/out/contact_TST")
  return
  # ----------------------------------------------------------------------

def test_endpoints_sides(MS, PS, CS):
  sys.stderr.write("--- testing {endpoints,pmid,side,which_side,covindices} ------------\n")
  
  wd = 0.5

  # Testing {pmid}
  q00, q01 = contact.endpoints(CS[0])
  m1a = rn.mix(0.50, q00, 0.50, q01)
  m1b = contact.pmid(CS[0])
  assert rn.dist(m1a, m1b) < 1.0e-8
 
  # This validation depends on the specific {PS,CS} created above:
  for   ctk,    omvk0,            omvk1,            oph0,    ix0, oph1,    ix1 in ( 
      ( CS[0], MS[0],           move.rev(MS[1]), PS[0], 0,   PS[2], 2   ),
      ( CS[1], move.rev(MS[1]), move.rev(MS[2]), PS[2], 2,   PS[1], 0   ),
      ( CS[2], MS[0],           move.rev(MS[2]), PS[0], 0,   PS[1], 0   ),
      ( CS[3], move.rev(MS[2]), move.rev(MS[3]), PS[1], 0,   PS[2], 0   ),
      ( CS[4], MS[0],           MS[4],           PS[0], 0,   PS[1], 4   ),
    ):
      contact.show(sys.stderr, ctk)
      mvk0, drk0 = move.unpack(omvk0)
      mvk1, drk1 = move.unpack(omvk1)
      assert contact.side(ctk, 0) == mvk0
      assert contact.side(ctk, 1) == mvk1
      assert contact.which_side(mvk0, ctk) == 0
      assert contact.which_side(mvk1, ctk) == 1
      assert contact.which_side(MS[5], ctk) == None
      assert path.elem(oph0, ix0) == omvk0
      assert path.elem(oph1, ix1) == omvk1
      assert contact.covindices(oph0, ctk) == ( ix0, None )
      assert contact.covindices(oph1, ctk) == ( None, ix1 )
      oph01 = path.concat((oph0, oph1), True, parms)
      n0 = path.nelems(oph0)
      n1 = path.nelems(oph1)
      assert path.nelems(oph01) == n0 + 1 + n1
      assert contact.covindices(oph01, ctk) == ( ix0, n0+1+ix1 )

  return
  # ----------------------------------------------------------------------

def test_coverage_times(MS, PS, CS, BS):
  sys.stderr.write("--- testing {covtimes,tcool,max_tcool,min_tcov} ------------\n")

  wd = 0.5

  for dr in 0, 1:
    # sys.stderr.write("- - - - - - - - - - - - - - - - - - - - - - - - \n")
    # sys.stderr.write("dr = %d\n" % dr)
    maxtcool = -inf
    mintcov = +inf
    nclosed = 0
    nactive = 0
    ninactive = 0
    # Make a test path from the first two paths:
    phsubs = [path.orient(PS[0],dr), path.orient(PS[1],dr),]
    oph = path.concat(phsubs, jumps=True, parms=parms)
    assert path.nelems(oph) == path.nelems(PS[0]) + 1 + path.nelems(PS[1])
    for ct in CS:
      ixs = contact.covindices(oph, ct)
      tcs = contact.covtimes(oph, ct)
      # sys.stderr.write("tcs = %s\n" % str(tcs))
      for i in range(2):
        k = ixs[i]
        if k == None:
          assert path.find(oph, contact.side(ct, i)) == None
          assert tcs[i] == None
        else:
          omvk = path.elem(oph, k)
          mvk, drk = move.unpack(omvk)
          assert mvk == contact.side(ct, i)
          if drk == 0:
            assert tcs[i] == path.tini(oph,k) + contact.tcov(ct, i)
          else:
            assert tcs[i] == path.tfin(oph,k) - contact.tcov(ct, i)
          assert tcs[i] <= path.extime(oph)
      tcool = contact.tcool(oph, ct)
      if tcs[0] == None and tcs[1] == None:
        assert tcool == None
        ninactive += 1
      elif tcs[0] == None or tcs[1] == None:
        tci = tcs[0] if tcs[0] != None else tcs[1]
        if tci < mintcov: mintcov = tci
        assert tcool == None
        nactive += 1
      else:
        assert tcool == abs(tcs[0] - tcs[1])
        if tcool > maxtcool: maxtcool = tcool
        nclosed += 1
    # These tests are specific for the {create_test} above:
    assert nclosed == 2
    assert nactive == 3
    assert ninactive == 2
    assert contact.max_tcool(oph, CS) == maxtcool
    assert contact.min_tcov(oph, CS) == mintcov

    # Block tests:
    tcb = contact.block_pair_min_tcool(BS[0], BS[1], ct, parms)
    tca = contact.blocks_min_tcool(BS, ct, parms)
    # ??? Should check the results ???
  return
  # ----------------------------------------------------------------------

test_plot(MS, PS, CS)
test_endpoints_sides(MS, PS, CS)
test_coverage_times(MS, PS, CS, BS)
