// Last edited on 2024-06-09 07:59:07 by stolfi

#debug "!! Loading fan_planes.inc ...\n"

#macro fan_planes(Zp, V, oshape, subfig)
  // A stack of slicing planes. Parameters:
  //
  //   {Zp}      The {Z}-coordinates of the planes, {Zp[1..Np]}.
  //   {V}       Coordinates of vertices.
  //   {oshape}  Shape of outer chain.
  //   {subfig}  Which sub-figure we are generating.

  #debug "!! Generating the slicing planes ...\n"

  #local Np = dimension_size(Zp, 1) - 1;
  #local Nv = dimension_size(V, 1) - 1;
  
  #if (subfig != 3)
    // Find X and Y ranges :
    #local Xmin = +99999;
    #local Xmax = -99999;
    #local Ymin = +99999;
    #local Ymax = -99999;
    #for (kv,1,Nv)
      #local Xk = V[kv].x;
      #if (Xk < Xmin) #local Xmin = Xk; #end
      #if (Xk > Xmax) #local Xmax = Xk; #end
      #local Yk = V[kv].y;
      #if (Yk < Ymin) #local Ymin = Yk; #end
      #if (Yk > Ymax) #local Ymax = Yk; #end
    #end
    #local XYmrg = 0.75*(Xmax - Xmin); // Extra margin in X and Y.

    #local P = 
      union{
        #for (kp,1,Np)
          object{ fan_slicing_plane(Xmin, Xmax, Ymin, Ymax, XYmrg, Zp[kp]) }
        #end
      }
  #else
    #local P = object{ nothing(3.14) }
  #end

  P
#end

#macro fan_slicing_plane(Xmin, Xmax, Ymin, Ymax, XYmrg, Z)
  #local dZ = 0.1; // Half-thickness of plane.
  intersection{
    box{ 
      < Xmin-XYmrg-eps, Ymin-XYmrg-eps, Z-dZ >,
      < Xmax+XYmrg+eps, Ymax+XYmrg+eps, Z+dZ >
      texture{ fan_tx_spla }
    }
    box{ 
      < Xmin-XYmrg, Ymin-XYmrg, Z-dZ-eps >,
      < Xmax+XYmrg, Ymax+XYmrg, Z+dZ+eps >
      texture{ fan_tx_spla_edge }
    }
  }
    
#end
