# Tools to create some example blocks.
# Last edited on 2021-02-18 21:18:10 by jstolfi

import example_block_IMP

def single_raster(xlo, xhi, y, wd, parms):
  # Returns a block that is a single raster line with endpoints 
  # {(xlo,y)} and {(xhy, y)}, with two choices -- the two 
  # orientations.
  return example_block_IMP.single_raster(xlo, xhi, y, wd, parms)

def raster_rectangle(xlo, xhi, ylo, wd, nr, parms):
  # Returns a block that is a serpentine path of {nr} raster traces in
  # alternating directions, connected by {nr-1} links (traces, not jumps).
  # Each raster spans abscissas from {xlo} to {xhi}. The lowest raster is
  # at height {y}. All traces have nominal width {wd} and are vertically
  # spaced {wd} apart.
  #
  # The count {nr} must be positive. If {nr} is 1, the block has only two
  # choices, namely a single-raster path {ph} and its reversal. 
  #
  # If {nr} is 2 or more, the block has four choices: {ph0} with the bottom trace
  # going from {xlo} to {xhi}, {ph1} with it going from {x1} to {xlo}, and
  # their reversals.  Each raster trace is shared among all four choices,
  # but each of {ph0} and {ph1} has its own set of links.
  return example_block_IMP.raster_rectangle(xlo, xhi, ylo, wd, nr, parms)

def onion(ctr, Rc, wdc, Rf, wdf, phase, parms):
  # Returns a block that has a single choice, namely a circular contour
  # of radius {Rc}, with traces of nominal width {wdc}, and 
  # zero or more circular filling elements inside or outside it,
  # up to radius {Rf}.  The {phase} is the  angular position of the
  # start of the contour. See {example_path.onion}.
  return example_block_IMP.onion(ctr, Rc, wdc, Rf, wdf, phase, parms)
  
# CONTACTS

def raster_raster_contact(bc0, bc1, parms):
  # Assumes that {bc0} and {bc1} are vertically adjacent blocks
  # whose paths are single rasters or serpentine raster paths,
  # such that the topmost trace of {bc0} is adjacent to the
  # bottommost trace of {bc1}, and they have overlapping {X} ranges.
  # Creates and returns a new {Contact} object between them.
  #
  # Assumes that every raster line trace in any choice of a block is
  # shared by all other choices of the same block (even if they may have
  # different sets of connectors between the rasters).
  return example_block_IMP.raster_raster_contact(bc0, bc1, parms)

