#! /usr/bin/python3
# Last edited on 2024-09-13 06:08:24 by stolfi
 
import sys

def write_object(fname, Vlst, Elst, Flst, prec):
  # Writes to file {fname} a description of the mesh {Vlst,Elst,Flst}
  # in OBJ format.  Point coordinates are written with {prec}
  # decimal fraction digits.  See the functions below for details.
  wro = open(fname, "w")
  write_vertices(wro, Vlst, prec)
  wro.write("\n")
  write_faces(wro, Flst)
  wro.close()
  return None

def write_vertices(wro, Vlst, prec):
  # Expects {Vlst[1..Nv]} to be a list of the {Nv} vertext records of the object.
  # Writes them to the file {wro} in OBJ format, using {prec} decimal
  # fraction digits for each coordinate.
  
  Nv = len(Vlst) - 1 # Expected non-null vertices.

  nv = 0
  for v in Vlst:
    if v != None:
      vx,vy,vz,kv,vlab = v
      wro.write("v");
      for i in range(3): wro.write(" %.*f" % (prec, v[i]))
      wro.write(" # %s\n" % vlab)
      nv += 1
  wro.flush()
  
  assert nv == Nv
  return None
  
def write_faces(wro, Flst):
  # Expects {Flst[1..Nf]} to be a list of the {Nf} face records of the object.
  # Writes those faces to the OBJ file {wro}.

  Nf = len(Flst) - 1

  nf = 0
  for f in Flst:
    if f != None:
      Nx,Ny,Nz,Fiv,kf,flab = f
      wro.write("f")
      for kv in Fiv:
        wro.write(" %d" % kv);
      # wro.write(" # %s\n" % flab)
      wro.write("\n")
      nf += 1
  wro.flush()
  
  assert nf == Nf
  return None
  
