// Last edited on 2024-09-13 06:59:30 by stolfi

#debug "!! Loading slicing_choose_planes.inc ...\n"

#macro slicing_choose_planes(V, Np, Zp_min, Zp_max)
  // Chooses the {Z} coordinates of the slicing planes. Parameters:
  //
  //   {V[1..Nv]}    The vertices of the object.
  //   {Np}          Num of slicing planes.
  //   {Zp_min}      {Z} of lowest plane.
  //   {Zp_max}      {Z} of highest plane.
  // 
  // Returns array {Z[1..Np]} of {Z}-coordinates.

  #debug "!! Choosing {Z} of slicing planes ...\n"
  
  #local Nv = dimension_size(V, 1) - 1;
  
  #local Zp = array[Np+1];
  #local Zp[0] = -1; // Unused element.
  
  #if (Np > 0)
    #for (kp,1,Np)
      #local fp = (kp - 1)/(Np -1);
      #local Zp[kp] = (1-fp)*Zp_min + fp*Zp_max;
    #end
  #end

  Zp
#end
