#! /usr/bin/python3
# Last edited on 2024-07-26 08:21:15 by stolfi

# Generic definitions for creating a mesh data structure that defines a
# solid polyhedral object model for the topological slicing project.

def tilt_matrix(xrot,yrot):
  # Returns a 3x3 orthonormal matrix that rotates by {xrot} degrees
  # towards the {X}-axis and {yrot} degrees toward the {Y}-axis.
  return slicing_mesh_IMP.tilt_matrix(xrot,yrot)

def rotate(M,rmat):
  # Multiplies each vertex coord vector of {M} (as row) by the 3x3 matrix
  # that tilts the object by the matrix {rmat}.
  slicing_mesh_IMP.rotate(M,rmat)
  
def perturb_vertices(M,pert):
  # Adds a random amount in {[-pert _ pert]} to each vertex coordinate in {M}.
  slicing_mesh_IMP.perturb_vertices(M,pert)
  
def round_vertices(vtot,eps):
  # Rounds each vertex coordinate in {M} to an even multiple of {eps}.
  slicing_mesh_IMP.round_vertices(M,eps)
