%Interface para entrada do modelo

h_fig_fr = figure;
set(h_fig_fr,'Units','centimeters','Position',[0 1.5 20 7]);
set(h_fig_fr,'Menubar','none');
set(h_fig_fr,'Name','Ray Tracer');
set(h_fig_fr,'Numbertitle','off');

%%%% Up side view %%%%%%%%%%%%%
h_fig_ax_up = figure;
set(h_fig_ax_up,'Units','centimeters','Position',[0 8.1 10 8]);
set(h_fig_ax_up,'Menubar','none');
set(h_fig_ax_up,'Name','View 1');
set(h_fig_ax_up,'Numbertitle','off');


h_ax_up = axes('Units','normalized','Position',[0.1 0.1 0.8 0.8],'box','on');
xlabel('Y');
ylabel('X');
set(gca,'XLim',[0 10000]);
set(gca,'Xtick',1000:1000:10000);
axis([0 10000 0 10000]);
%axis ij;
set(h_ax_up,'XTickLabel',[]);
set(h_ax_up,'YTickLabel',[]);
hold on;

%%%% 3D view %%%%%%%%%%%%%
h_fig_ax_3d = figure;
set(h_fig_ax_3d,'Units','centimeters','Position',[10 8.1 10 8]);
%set(h_fig_ax_3d,'Menubar','none');
set(h_fig_ax_3d,'Name','3D View');
set(h_fig_ax_3d,'Numbertitle','off');

h_ax_3d = axes('Units','normalized','Position',[0.1 0.1 0.8 0.8],'box','on');
set(h_ax_3d,'CameraPosition', [-13133.6 -25070.2 9885.55]);
set(h_ax_3d,'CameraPositionMode','manual');
set(h_ax_3d,'CameraTarget',[5000 2000 2250]);
set(h_ax_3d,'CameraTargetMode','manual');
set(h_ax_3d,'CameraUpVector',[0 0 1]);
set(h_ax_3d,'CameraUpVectorMode','manual');
set(h_ax_3d,'CameraViewAngle',[10.089]);
set(h_ax_3d,'CameraViewAngleMode','manual');

ylabel('Y');
xlabel('X');
zlabel('Z');

axis([0 10000 0 10000 0 4000]);
axis equal;
%set(gca,'XLim',[0 5000]);
%set(gca,'Xtick',1000:1000:5000);
%axis([0 5000 0 4000]);
%axis ij;
%set(h_ax_3d,'XTickLabel',[]);
%set(h_ax_3d,'YTickLabel',[]);
hold on;
rotate3d on;


%%%% X-Z Plane view %%%%%%%%%%%%%
h_fig_ax = figure;
set(h_fig_ax,'Units','centimeters','Position',[0 9.3 20 8]);
set(h_fig_ax,'Menubar','none');
set(h_fig_ax,'Name','View 2');
set(h_fig_ax,'Numbertitle','off');


h_ax = axes('Units','normalized','Position',[0 0 1 1],'box','on');
set(gca,'XLim',[0 10000]);
set(gca,'Xtick',1000:1000:10000);
axis([0 10000 0 4000]);
%axis ij;
set(h_ax,'XTickLabel',[]);
set(h_ax,'YTickLabel',[]);
hold on;


%------------------------- FRAMES ------------------------------
h_fr_modelo = uicontrol(h_fig_fr,'Units','normalized','Style','frame',...
   'Position',[0 0 .35 1]);

h_fr_disparo = uicontrol(h_fig_fr,'Units','normalized','Style','frame',...
   'Position',[.35 0 .3 1]);

h_fr_plot = uicontrol(h_fig_fr,'Units','normalized','Style','frame',...
   'Position',[.65 0 .35 1]);
%----------------------- (FIM FRAMES)---------------------------------

%************************* TITULOS FRAMES ****************************
h_tit_modelo = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[1 5.3 4 1],'String','Seismic Model','Fontsize',[15]);

h_tit_disparo = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[7.3 5.3 5.5 1],'String','Acquisition Configuration','Fontsize',[13]);

h_tit_plot = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[15 5.3 3 1],'String','Display','Fontsize',[15]);
%********************** (FIM TITULOS FRAMES) **************************

%%%%%%%%%%%%%%%%%%%   OBJETOS EM FRAMES   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Frame "Modelo"
h_tex_n_ref = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[0 4 3 0.6],'String','Number of interfaces:');

h_tex_vel_mod = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[0.2 3 3 0.6],'String','Velocity type' );

h_edit_ref = uicontrol(h_fig_fr,'Units','centimeters','Style','edit',...
   'Position',[5.4 4 1 0.6],'String','2');

h_pop_vel_mod = uicontrol(h_fig_fr,'Units','centimeters','Style','pop',...
   'Position',[3.4 3 3 0.6],'String','Constant.|Not const.');

h_but_ref = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[0.2 2 3 0.6],'String','Interfaces');

h_but_vel_mod = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[0.2 1 3 0.6],'String','Velocity model.','Enable','off');

h_but_load_mod = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[3.4 2 3 0.6],'String','Load','Enable','on');

h_but_salva_mod = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
'Position',[3.4 1 3 0.6],'String','Save','Enable','off');

% (Fim Frame "Modelo")



% Frame Disparo
h_tex_n_rai = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[7.2 5 2 .4],'String','# of rays');

h_tex_abertura = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[7.2 4 2 .4],'String','Aperture (rad)');

h_tex_dir = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[7.2 3 2 .4],'String','Direction');

h_edit_rai = uicontrol(h_fig_fr,'Units','centimeters','Style','edit',...
   'Position',[10.2 4.9 1 0.6],'String','5');

h_edit_abertura = uicontrol(h_fig_fr,'Units','centimeter','Style','edit',...
   'Position',[10.2 3.9 1 0.6],'String','0.1');

h_pop_dir = uicontrol(h_fig_fr,'Units','centimeters','Style','pop',...
   'Position',[10.2 2.9 1.5 0.7],'String','left|right');

h_but_tiro = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[7.2 2 2 0.6],'String','Source',...
   'Enable','off');

h_but_load_config = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[10.2 2 2.0 0.6],'String','Load',...
   'Enable','off');

h_but_salva_config = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[10.2 1 2 .6],'String','Save',...
   'Enable','off');

h_but_run = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[10.2 0.1 2 .6],'String','Run',...
   'Enable','off');


h_but_geofones = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[7.2 1 2 .6],'String','Receivers',...
   'Enable','off');

h_but_amostras = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[7.2 .2 2 .6],'String','Samples',...
   'Enable','off','Callback',['interf_amost;' 'set(h_but_geofones,''Enable'',''on'');']);
% (Fim Frame "Disparo")

% Frame "Desenhando"
h_tex_interf = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
   'Position',[13.2 4 3 0.5],'String','Reflector number');

%h_tex_opcao = uicontrol(h_fig_fr,'Units','centimeters','Style','text',...
 %  'Position',[15.2 3.1 2 .6],'String','Desenhar:');

h_pop_interf = uicontrol(h_fig_fr,'Units','centimeters','Style','pop',...
	'Position',[17.2 4 2 .6],'String','2|3|4','Enable','off');

h_pop_opcao = uicontrol(h_fig_fr,'Units','centimeters','Style','pop',...
   'Position',[14.7 3 5 .6],'String','Wave-fronts|Wave-fronts & rays|Rays',...
   'Enable','off');

h_but_cor = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[13.2 5 3 .6],'String','Colour model',...
   'Enable','off');

h_but_g = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[17.2 5 2 .6],'String','Receivers',...
   'Enable','off');

h_but_plot = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[13.2 3 2 .6],'String','Draw ...',...
   'Enable','off');


h_but_sism = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[13.2 2 4.5 .6],'String','Seismogram computation',...
   'Enable','off');

h_but_sism2 = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[13.2 1 4.5 .6],'String','Display seismic data',...
   'Enable','off');
% (Fim Frame "Desenhando")
%%%%%%%%%%%%%%%%%%%%% (FIM OBJETOS EM FRAMES) %%%%%%%%%%%%%%%%%%%%%%%%%

%///////////////////// SETANDO FUNCIONALIDADES /////////////////////

% Botao "Entrar Refletores"
set(h_but_ref,'Callback','botao_ref')
        
% Botao "Entrar Mod. Vel"
set(h_but_vel_mod,'Callback','botao_vel');
            
% Botao "Disparar Tiro"
set(h_but_tiro,'Callback','interf_fonte');

set(h_but_run,'Callback','botao_dispara');

% Botao "Desenhar"
set(h_but_plot,'Callback','botao_plot');

% Botao "do arquivo...(modelo)"
set(h_but_load_mod,'Callback','botao_load_mod');

% Botao "do arquivo...(config)"
set(h_but_load_config,'Callback','botao_load_config');


% Botao "do arquivo...(modelo)"
set(h_but_salva_mod,'Callback','botao_salva_mod');

% Botao "do arquivo...(config)"
set(h_but_salva_config,'Callback','botao_salva_config');

%Botao "geofones"
set(h_but_geofones,'Callback','interf_geof');

%Botao Sismograma
set(h_but_sism,'Callback',[...
        '[traces,t] = calcula_tracos(config,model,rays,h_ax);' ...
        'set(h_but_sism2,''Enable'',''on'')']);
set(h_but_sism2,'Callback',[...
                'figure(''name'',''Ray Tracer - Display 2 - Seismogram'',''numbertitle'',''off''); wigbplot(traces,t,config.recv.xini:config.recv.dxs:config.recv.xini+(config.recv.n-1)*config.recv.dxs);']);
        
set(h_but_g,'Callback',[...
        'receivers=[];'...
        'geofones=plota_geofones(config,model,receivers,h_ax);']);

set(h_but_cor,'Callback','botao_colore')

%/////////////// (FIM SETANDO FUNCIONALIDADES )  //////////////////////

% Botao "Sair"
h_but_sair = uicontrol(h_fig_fr,'Units','centimeters','Style','pushbutton',...
   'Position',[17.8 .2 2 0.6],'String','Quit','Callback',['close(h_fig_fr);' ...
       'close(h_fig_ax);' 'close(h_fig_ax_up);' 'close(h_fig_ax_3d);' 'clear;']);


axes(h_ax);
